/*     */ package org.jboss.remoting.samples.callback.statistics;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.CallbackListener;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class CallbackServer
/*     */ {
/*  51 */   private static String transport = "socket";
/*  52 */   private static String host = "localhost";
/*  53 */   private static int port = 5400;
/*     */ 
/*  56 */   private static int callbackCounter = 1;
/*     */   private Connector connector;
/*     */   private static final String RESPONSE_VALUE = "This is the return to SampleInvocationHandler invocation";
/*     */ 
/*     */   public CallbackServer()
/*     */   {
/*  59 */     this.connector = null;
/*     */   }
/*     */ 
/*     */   public void setupServer(String locatorURI)
/*     */     throws Exception
/*     */   {
/*  72 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  73 */     System.out.println("Starting remoting server with locator uri of: " + locatorURI);
/*  74 */     this.connector = new Connector();
/*  75 */     this.connector.setInvokerLocator(locator.getLocatorURI());
/*  76 */     this.connector.create();
/*     */ 
/*  78 */     SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
/*  79 */     this.connector.addInvocationHandler("sample", invocationHandler);
/*     */ 
/*  81 */     this.connector.start();
/*     */   }
/*     */ 
/*     */   public void shutdownServer()
/*     */   {
/*  89 */     this.connector.stop();
/*  90 */     this.connector.destroy();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  98 */     if ((args != null) && (args.length == 2))
/*     */     {
/* 100 */       transport = args[0];
/* 101 */       port = Integer.parseInt(args[1]);
/*     */     }
/* 103 */     String locatorURI = transport + "://" + host + ":" + port;
/* 104 */     CallbackServer server = new CallbackServer();
/*     */     try
/*     */     {
/* 107 */       server.setupServer(locatorURI);
/*     */       while (true)
/*     */       {
/* 112 */         Thread.sleep(1000L);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 118 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler, Runnable, CallbackListener
/*     */   {
/* 130 */     private List listeners = new ArrayList();
/*     */ 
/* 133 */     private boolean shouldGenerateCallbacks = false;
/*     */ 
/*     */     public SampleInvocationHandler()
/*     */     {
/* 138 */       Thread callbackThread = new Thread(this);
/* 139 */       callbackThread.setDaemon(true);
/* 140 */       callbackThread.start();
/*     */     }
/*     */ 
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 148 */       return "This is the return to SampleInvocationHandler invocation";
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/* 157 */       System.out.println("Adding callback listener.");
/* 158 */       this.listeners.add(callbackHandler);
/* 159 */       this.shouldGenerateCallbacks = true;
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/* 168 */       System.out.println("Removing callback listener.");
/* 169 */       this.listeners.remove(callbackHandler);
/* 170 */       if (this.listeners.size() == 0)
/*     */       {
/* 172 */         this.shouldGenerateCallbacks = false;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       while (true)
/*     */       {
/* 185 */         if (this.shouldGenerateCallbacks)
/*     */         {
/* 188 */           Callback callback = new Callback("Callback " + CallbackServer.callbackCounter + ": This is the payload of callback invocation.");
/* 189 */           System.out.println("sending callback: " + CallbackServer.callbackCounter);
/*     */ 
/* 192 */           HashMap returnPayload = new HashMap();
/* 193 */           returnPayload.put("callbackListener", this);
/* 194 */           returnPayload.put("callbackId", new Integer(CallbackServer.access$008()));
/* 195 */           returnPayload.put("remotingAcknowledgesPushCallbacks", "true");
/* 196 */           callback.setReturnPayload(returnPayload);
/*     */ 
/* 198 */           Iterator itr = this.listeners.iterator();
/* 199 */           while (itr.hasNext())
/*     */           {
/* 201 */             InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)itr.next();
/*     */             try
/*     */             {
/* 204 */               callbackHandler.handleCallback(callback);
/*     */             }
/*     */             catch (HandleCallbackException e)
/*     */             {
/* 208 */               e.printStackTrace();
/*     */             }
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 214 */             Thread.sleep(1000L);
/*     */           }
/*     */           catch (InterruptedException e) {
/*     */           }
/* 218 */           continue;
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 224 */           Thread.sleep(1000L);
/*     */         } catch (InterruptedException e) {
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server) {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker) {
/*     */     }
/*     */ 
/*     */     public void acknowledgeCallback(InvokerCallbackHandler callbackHandler, Object callbackId, Object response) {
/* 237 */       System.out.println("received acknowledgement for callback: " + callbackId);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.callback.statistics.CallbackServer
 * JD-Core Version:    0.6.0
 */