/*     */ package org.jboss.remoting.samples.callback.statistics;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ 
/*     */ public class CallbackClient
/*     */ {
/*  43 */   private static String transport = "socket";
/*  44 */   private static String host = "localhost";
/*  45 */   private static int port = 5400;
/*     */ 
/*     */   public void getPolledCallbacks(String locatorURI)
/*     */     throws Throwable
/*     */   {
/*  53 */     System.out.println("Calling remoting server with locator uri of: " + locatorURI);
/*  54 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  55 */     Client client = new Client(locator);
/*  56 */     client.connect();
/*     */ 
/*  59 */     CallbackHandler callbackHandler = new CallbackHandler();
/*  60 */     HashMap metadata = new HashMap();
/*  61 */     metadata.put("reportStatistics", "true");
/*  62 */     client.addListener(callbackHandler, metadata);
/*     */ 
/*  65 */     Thread.sleep(20000L);
/*     */ 
/*  68 */     client.removeListener(callbackHandler);
/*  69 */     client.disconnect();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  78 */     if ((args != null) && (args.length == 2))
/*     */     {
/*  80 */       transport = args[0];
/*  81 */       port = Integer.parseInt(args[1]);
/*     */     }
/*  83 */     String locatorURI = transport + "://" + host + ":" + port;
/*  84 */     CallbackClient callbackClient = new CallbackClient();
/*     */     try
/*     */     {
/*  87 */       callbackClient.getPolledCallbacks(locatorURI);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  91 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public class CallbackHandler
/*     */     implements InvokerCallbackHandler
/*     */   {
/*     */     public CallbackHandler()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void handleCallback(Callback callback) throws HandleCallbackException
/*     */     {
/*     */       try
/*     */       {
/* 106 */         Thread.sleep(1000L);
/*     */       }
/*     */       catch (InterruptedException e) {
/*     */       }
/* 110 */       System.out.println("Received push callback.");
/* 111 */       System.out.println("Received callback value of: " + callback.getCallbackObject());
/* 112 */       System.out.println("Received callback server invoker of: " + callback.getServerLocator());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.callback.statistics.CallbackClient
 * JD-Core Version:    0.6.0
 */