/*     */ package org.jboss.remoting.samples.callback.acknowledgement;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.HashMap;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.CallbackListener;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class CallbackAcknowledgeServer
/*     */ {
/*     */   public static final String APPLICATION_ACKNOWLDEGEMENTS = "applicationAcknowledgements";
/*     */   public static final String REMOTING_ACKNOWLDEGEMENTS = "remotingAcknowledgements";
/*  57 */   private static String transport = "socket";
/*     */   private static String host;
/*  59 */   private static int port = 5401;
/*     */   private Connector connector;
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  71 */     if ((args != null) && (args.length == 2))
/*     */     {
/*  73 */       transport = args[0];
/*  74 */       port = Integer.parseInt(args[1]);
/*     */     }
/*     */     try
/*     */     {
/*  78 */       host = InetAddress.getLocalHost().getHostName();
/*     */     }
/*     */     catch (UnknownHostException e1)
/*     */     {
/*  82 */       System.err.println("cannot get local host name");
/*  83 */       return;
/*     */     }
/*  85 */     String locatorURI = transport + "://" + host + ":" + port;
/*  86 */     CallbackAcknowledgeServer server = new CallbackAcknowledgeServer();
/*     */     try
/*     */     {
/*  89 */       server.setupServer(locatorURI);
/*     */       while (true)
/*     */       {
/*  94 */         Thread.sleep(1000L);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 100 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setupServer(String locatorURI) throws Exception
/*     */   {
/* 106 */     this.connector = new Connector(new InvokerLocator(locatorURI));
/* 107 */     this.connector.start();
/* 108 */     this.connector.addInvocationHandler("test", new TestInvoocationHandler());
/*     */   }
/*     */   static class TestInvoocationHandler implements ServerInvocationHandler, CallbackListener {
/*     */     InvokerCallbackHandler callbackHandler;
/*     */     int counter;
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server) {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker) {
/*     */     }
/*     */ 
/*     */     public Object invoke(InvocationRequest invocation) throws Throwable {
/* 123 */       String command = (String)invocation.getParameter();
/* 124 */       System.out.println("command: " + command);
/*     */ 
/* 126 */       Callback cb = new Callback("callback " + ++this.counter);
/*     */ 
/* 129 */       HashMap returnPayload = new HashMap();
/* 130 */       returnPayload.put("callbackListener", this);
/* 131 */       returnPayload.put("callbackId", new GUID());
/* 132 */       cb.setReturnPayload(returnPayload);
/*     */ 
/* 134 */       if ("remotingAcknowledgements".equals(command))
/*     */       {
/* 136 */         returnPayload.put("remotingAcknowledgesPushCallbacks", "true");
/*     */       }
/*     */ 
/* 139 */       this.callbackHandler.handleCallback(cb);
/* 140 */       return null;
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/* 145 */       this.callbackHandler = callbackHandler;
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void acknowledgeCallback(InvokerCallbackHandler callbackHandler, Object callbackId, Object response)
/*     */     {
/* 155 */       System.out.println("received acknowledgment for callback: " + callbackId);
/* 156 */       System.out.println("response: " + response);
/* 157 */       System.out.println("");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.callback.acknowledgement.CallbackAcknowledgeServer
 * JD-Core Version:    0.6.0
 */