/*     */ package org.jboss.remoting.samples.callback;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class CallbackServer
/*     */ {
/*  48 */   private static String transport = "socket";
/*  49 */   private static String host = "localhost";
/*  50 */   private static int port = 5400;
/*     */ 
/*  53 */   private static int callbackCounter = 1;
/*     */   private Connector connector;
/*     */   private static final String RESPONSE_VALUE = "This is the return to SampleInvocationHandler invocation";
/*     */ 
/*     */   public CallbackServer()
/*     */   {
/*  56 */     this.connector = null;
/*     */   }
/*     */ 
/*     */   public void setupServer(String locatorURI)
/*     */     throws Exception
/*     */   {
/*  69 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  70 */     System.out.println("Starting remoting server with locator uri of: " + locatorURI);
/*  71 */     this.connector = new Connector();
/*  72 */     this.connector.setInvokerLocator(locator.getLocatorURI());
/*  73 */     this.connector.create();
/*     */ 
/*  75 */     SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
/*     */ 
/*  77 */     this.connector.addInvocationHandler("sample", invocationHandler);
/*     */ 
/*  79 */     this.connector.start();
/*     */   }
/*     */ 
/*     */   public void shutdownServer()
/*     */   {
/*  87 */     this.connector.stop();
/*  88 */     this.connector.destroy();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  99 */     if ((args != null) && (args.length == 2))
/*     */     {
/* 101 */       transport = args[0];
/* 102 */       port = Integer.parseInt(args[1]);
/*     */     }
/* 104 */     String locatorURI = transport + "://" + host + ":" + port;
/* 105 */     CallbackServer server = new CallbackServer();
/*     */     try
/*     */     {
/* 108 */       server.setupServer(locatorURI);
/*     */       while (true)
/*     */       {
/* 113 */         Thread.sleep(1000L);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 119 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler, Runnable
/*     */   {
/* 130 */     private List listeners = new ArrayList();
/*     */ 
/* 133 */     private boolean shouldGenerateCallbacks = false;
/*     */ 
/*     */     public SampleInvocationHandler()
/*     */     {
/* 138 */       Thread callbackThread = new Thread(this);
/* 139 */       callbackThread.setDaemon(true);
/* 140 */       callbackThread.start();
/*     */     }
/*     */ 
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 153 */       System.out.println("Invocation request is: " + invocation.getParameter());
/*     */ 
/* 156 */       return "This is the return to SampleInvocationHandler invocation";
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/* 167 */       System.out.println("Adding callback listener.");
/* 168 */       this.listeners.add(callbackHandler);
/* 169 */       this.shouldGenerateCallbacks = true;
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/* 180 */       System.out.println("Removing callback listener.");
/* 181 */       this.listeners.remove(callbackHandler);
/* 182 */       if (this.listeners.size() == 0)
/*     */       {
/* 184 */         this.shouldGenerateCallbacks = false;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       while (true)
/*     */       {
/* 197 */         if (this.shouldGenerateCallbacks)
/*     */         {
/* 200 */           Callback callback = new Callback("Callback " + CallbackServer.access$008() + ": This is the payload of callback invocation.");
/* 201 */           Iterator itr = this.listeners.iterator();
/* 202 */           while (itr.hasNext())
/*     */           {
/* 204 */             InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)itr.next();
/*     */             try
/*     */             {
/* 207 */               callbackHandler.handleCallback(callback);
/*     */             }
/*     */             catch (HandleCallbackException e)
/*     */             {
/* 211 */               e.printStackTrace();
/*     */             }
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 217 */             Thread.currentThread(); Thread.sleep(1000L);
/*     */           }
/*     */           catch (InterruptedException e) {
/*     */           }
/* 221 */           continue;
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 227 */           Thread.currentThread(); Thread.sleep(1000L);
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.callback.CallbackServer
 * JD-Core Version:    0.6.0
 */