/*     */ package org.jboss.remoting.network;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
/*     */ import org.jboss.remoting.InvokerRegistry;
/*     */ import org.jboss.remoting.detection.ServerInvokerMetadata;
/*     */ import org.jboss.remoting.ident.Identity;
/*     */ 
/*     */ public class NetworkRegistry
/*     */   implements NetworkRegistryMBean
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(NetworkRegistry.class);
/*     */   private MBeanServer mBeanServer;
/*     */   private ObjectName objectName;
/*  55 */   private final JBossNotificationBroadcasterSupport broadcaster = new JBossNotificationBroadcasterSupport();
/*  56 */   private final Map servers = new HashMap();
/*     */   private static NetworkRegistry singleton;
/*     */ 
/*     */   public NetworkRegistry()
/*     */   {
/*  62 */     singleton = this;
/*     */   }
/*     */ 
/*     */   public static final NetworkRegistry getInstance()
/*     */   {
/*  72 */     if (singleton == null)
/*     */     {
/*  74 */       new NetworkRegistry();
/*     */     }
/*  76 */     return singleton;
/*     */   }
/*     */ 
/*     */   public void addServer(Identity identity, ServerInvokerMetadata[] invokers)
/*     */   {
/*  87 */     boolean found = false;
/*  88 */     synchronized (this.servers)
/*     */     {
/*  90 */       if (!this.servers.containsKey(identity))
/*     */       {
/*  92 */         this.servers.put(identity, new NetworkInstance(identity, invokers));
/*  93 */         found = true;
/*     */       }
/*     */     }
/*  96 */     if (found)
/*     */     {
/*  98 */       log.debug("addServer - " + identity);
/*     */ 
/* 102 */       new Thread(identity, invokers) { private final Identity val$identity;
/*     */         private final ServerInvokerMetadata[] val$invokers;
/*     */ 
/* 106 */         public void run() { NetworkRegistry.this.broadcaster.sendNotification(new NetworkNotification(NetworkRegistry.this.objectName, "jboss.network.server.added", this.val$identity, this.val$invokers));
/*     */         }
/*     */       }
/* 102 */       .start();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateServer(Identity identity, ServerInvokerMetadata[] invokers)
/*     */   {
/* 120 */     boolean found = false;
/*     */ 
/* 122 */     synchronized (this.servers)
/*     */     {
/* 124 */       if (this.servers.containsKey(identity))
/*     */       {
/* 126 */         this.servers.put(identity, new NetworkInstance(identity, invokers));
/* 127 */         found = true;
/*     */       }
/*     */     }
/* 130 */     if (found)
/*     */     {
/* 134 */       new Thread(identity, invokers) { private final Identity val$identity;
/*     */         private final ServerInvokerMetadata[] val$invokers;
/*     */ 
/* 138 */         public void run() { NetworkRegistry.this.broadcaster.sendNotification(new NetworkNotification(NetworkRegistry.this.objectName, "jboss.network.server.updated", this.val$identity, this.val$invokers));
/*     */         }
/*     */       }
/* 134 */       .start();
/*     */     }
/*     */   }
/*     */ 
/*     */   public NetworkInstance[] getServers()
/*     */   {
/* 151 */     synchronized (this.servers)
/*     */     {
/* 153 */       return (NetworkInstance[])this.servers.values().toArray(new NetworkInstance[this.servers.size()]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean hasServer(Identity identity)
/*     */   {
/* 165 */     synchronized (this.servers)
/*     */     {
/* 167 */       return this.servers.containsKey(identity);
/*     */     }
/*     */   }
/*     */ 
/*     */   public NetworkInstance[] queryServers(NetworkFilter filter)
/*     */   {
/* 180 */     NetworkInstance[] servers = getServers();
/* 181 */     if ((servers == null) || (servers.length <= 0))
/*     */     {
/* 183 */       return new NetworkInstance[0];
/*     */     }
/* 185 */     Set result = new HashSet();
/* 186 */     for (int c = 0; c < servers.length; c++)
/*     */     {
/* 188 */       NetworkInstance instance = (NetworkInstance)this.servers.get(servers[c]);
/* 189 */       if ((filter != null) && (!filter.filter(servers[c].getIdentity(), instance.getLocators()))) {
/*     */         continue;
/*     */       }
/* 192 */       if (result.contains(servers[c])) {
/*     */         continue;
/*     */       }
/* 195 */       result.add(servers[c]);
/*     */     }
/*     */ 
/* 199 */     return (NetworkInstance[])result.toArray(new NetworkInstance[result.size()]);
/*     */   }
/*     */ 
/*     */   public void removeServer(Identity identity)
/*     */   {
/* 209 */     NetworkInstance instance = null;
/*     */ 
/* 211 */     synchronized (this.servers)
/*     */     {
/* 213 */       instance = (NetworkInstance)this.servers.remove(identity);
/*     */     }
/* 215 */     if (instance != null)
/*     */     {
/* 217 */       log.debug("removeServer - " + identity);
/*     */ 
/* 219 */       ServerInvokerMetadata[] il = instance.getServerInvokers();
/*     */ 
/* 222 */       new Thread(identity, il) { private final Identity val$identity;
/*     */         private final ServerInvokerMetadata[] val$il;
/*     */ 
/* 226 */         public void run() { NetworkRegistry.this.broadcaster.sendNotification(new NetworkNotification(NetworkRegistry.this.objectName, "jboss.network.server.removed", this.val$identity, this.val$il));
/*     */         }
/*     */       }
/* 222 */       .start();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object o)
/*     */     throws IllegalArgumentException
/*     */   {
/* 234 */     this.broadcaster.addNotificationListener(notificationListener, notificationFilter, o);
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 239 */     MBeanNotificationInfo[] info = new MBeanNotificationInfo[3];
/* 240 */     info[0] = new MBeanNotificationInfo(new String[] { "jboss.network.server.added" }, NetworkNotification.class.getName(), "Fired when Server is added");
/* 241 */     info[1] = new MBeanNotificationInfo(new String[] { "jboss.network.server.updated" }, NetworkNotification.class.getName(), "Fired when Server is updated");
/* 242 */     info[2] = new MBeanNotificationInfo(new String[] { "jboss.network.server.removed" }, NetworkNotification.class.getName(), "Fired when Server is removed");
/* 243 */     return info;
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException
/*     */   {
/* 248 */     this.broadcaster.removeNotificationListener(notificationListener);
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean aBoolean)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception
/*     */   {
/* 265 */     this.mBeanServer = mBeanServer;
/* 266 */     this.objectName = objectName;
/*     */ 
/* 268 */     Identity identity = Identity.get(this.mBeanServer);
/*     */ 
/* 271 */     System.setProperty("jboss.remoting.jmxid", identity.getJMXId());
/* 272 */     System.setProperty("jboss.remoting.instanceid", identity.getInstanceId());
/* 273 */     System.setProperty("jboss.remoting.domain", identity.getDomain());
/* 274 */     return objectName;
/*     */   }
/*     */ 
/*     */   public synchronized void changeDomain(String newDomain)
/*     */   {
/* 284 */     System.setProperty("jboss.remoting.domain", newDomain);
/* 285 */     NetworkInstance[] servers = getServers();
/* 286 */     if ((servers == null) || (servers.length <= 0))
/*     */     {
/* 288 */       return;
/*     */     }
/*     */ 
/* 291 */     for (int c = 0; c < servers.length; c++)
/*     */     {
/* 293 */       NetworkInstance instance = (NetworkInstance)this.servers.get(servers[c]);
/* 294 */       if (newDomain.equals(instance.getIdentity().getDomain()))
/*     */         continue;
/* 296 */       this.servers.remove(servers[c]);
/*     */     }
/*     */ 
/* 299 */     new Thread()
/*     */     {
/*     */       public void run()
/*     */       {
/* 303 */         NetworkRegistry.this.broadcaster.sendNotification(new NetworkNotification(NetworkRegistry.this.objectName, "jboss.network.domain.changed", Identity.get(NetworkRegistry.this.mBeanServer), InvokerRegistry.getRegisteredServerLocators()));
/*     */       }
/*     */     }
/* 299 */     .start();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.network.NetworkRegistry
 * JD-Core Version:    0.6.0
 */