/*     */ package org.jboss.remoting.marshal.serializable;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.util.Map;
/*     */ import org.jboss.remoting.Version;
/*     */ import org.jboss.remoting.marshal.PreferredStreamUnMarshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedUnMarshaller;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ 
/*     */ public class SerializableUnMarshaller
/*     */   implements PreferredStreamUnMarshaller, VersionedUnMarshaller
/*     */ {
/*     */   static final long serialVersionUID = -1554017376768780738L;
/*     */   public static final String DATATYPE = "serializable";
/*  49 */   protected ClassLoader customClassLoader = null;
/*     */   protected String serializationType;
/*     */ 
/*     */   public InputStream getMarshallingStream(InputStream inputStream)
/*     */     throws IOException
/*     */   {
/*  55 */     return getMarshallingStream(inputStream, null);
/*     */   }
/*     */ 
/*     */   public InputStream getMarshallingStream(InputStream inputStream, Map config)
/*     */     throws IOException
/*     */   {
/*  64 */     if ((inputStream instanceof ObjectInputStream))
/*     */     {
/*  66 */       return inputStream;
/*     */     }
/*     */ 
/*  70 */     BufferedInputStream bis = new BufferedInputStream(inputStream);
/*  71 */     SerializationManager manager = SerializationStreamFactory.getManagerInstance(getSerializationType());
/*  72 */     return manager.createInput(bis, this.customClassLoader);
/*     */   }
/*     */ 
/*     */   public Object read(InputStream inputStream, Map metadata)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  96 */     int version = Version.getDefaultVersion();
/*  97 */     return read(inputStream, metadata, version);
/*     */   }
/*     */ 
/*     */   public Object read(InputStream inputStream, Map metadata, int version)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 119 */     ObjectInputStream ois = (ObjectInputStream)getMarshallingStream(inputStream, null);
/* 120 */     return SerializationStreamFactory.getManagerInstance(getSerializationType()).receiveObject(ois, this.customClassLoader, version);
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classloader)
/*     */   {
/* 132 */     this.customClassLoader = classloader;
/*     */   }
/*     */ 
/*     */   public UnMarshaller cloneUnMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 138 */     SerializableUnMarshaller unmarshaller = new SerializableUnMarshaller();
/* 139 */     unmarshaller.setClassLoader(this.customClassLoader);
/* 140 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   public void setSerializationType(String serializationType)
/*     */   {
/* 145 */     this.serializationType = serializationType;
/*     */   }
/*     */ 
/*     */   public String getSerializationType()
/*     */   {
/* 150 */     if (this.serializationType == null)
/*     */     {
/* 152 */       return "java";
/*     */     }
/*     */ 
/* 156 */     return this.serializationType;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.serializable.SerializableUnMarshaller
 * JD-Core Version:    0.6.0
 */