/*     */ package org.jboss.remoting.marshal.http;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
/*     */ import org.jboss.remoting.transport.web.WebUtil;
/*     */ 
/*     */ public class HTTPUnMarshaller extends SerializableUnMarshaller
/*     */ {
/*     */   static final long serialVersionUID = 1085086661310576768L;
/*     */   public static final String DATATYPE = "http";
/*  50 */   protected final Logger log = Logger.getLogger(getClass());
/*     */ 
/*     */   public Object read(InputStream inputStream, Map metadata, int version)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  65 */     if (isBinaryData(metadata))
/*     */     {
/*     */       try
/*     */       {
/*  69 */         return super.read(inputStream, metadata, version);
/*     */       }
/*     */       catch (EOFException e)
/*     */       {
/*  73 */         return null;
/*     */       }
/*     */     }
/*     */ 
/*  77 */     int contentLength = -1;
/*  78 */     Object ret = null;
/*  79 */     int bufferSize = 1024;
/*  80 */     byte[] byteBuffer = new byte[bufferSize];
/*  81 */     ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
/*     */ 
/*  84 */     if (metadata != null)
/*     */     {
/*  86 */       Object value = metadata.get("Content-Length");
/*  87 */       if (value == null)
/*     */       {
/*  89 */         value = metadata.get("content-length");
/*     */       }
/*  91 */       if (value != null)
/*     */       {
/*  93 */         if ((value instanceof List))
/*     */         {
/*  95 */           List valueList = (List)value;
/*  96 */           if ((valueList != null) && (valueList.size() > 0))
/*     */           {
/*  98 */             value = valueList.get(0);
/*     */           }
/*     */         }
/* 101 */         if ((value instanceof String))
/*     */         {
/*     */           try
/*     */           {
/* 105 */             contentLength = Integer.parseInt((String)value);
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/* 109 */             this.log.warn("Error converting Content-Length value (" + value + ") from metadata into int value.");
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 114 */           this.log.warn("Can not get Content-Length from header for http unmarshalling.");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 119 */     int pointer = 0;
/* 120 */     int amtRead = inputStream.read(byteBuffer);
/* 121 */     while (amtRead > 0)
/*     */     {
/* 123 */       byteOutputStream.write(byteBuffer, pointer, amtRead);
/* 124 */       if ((amtRead < bufferSize) && (byteOutputStream.size() >= contentLength))
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/* 129 */       amtRead = inputStream.read(byteBuffer);
/*     */     }
/*     */ 
/* 132 */     byteOutputStream.flush();
/*     */ 
/* 134 */     byte[] totalByteArray = byteOutputStream.toByteArray();
/*     */ 
/* 136 */     if (totalByteArray.length == 0)
/*     */     {
/* 139 */       return null;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 148 */       BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(totalByteArray)));
/* 149 */       StringBuffer buffer = new StringBuffer();
/* 150 */       String str = null;
/* 151 */       while ((str = reader.readLine()) != null)
/*     */       {
/* 153 */         buffer.append(str);
/*     */       }
/* 155 */       reader.close();
/*     */ 
/* 157 */       ret = buffer.toString();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 162 */       this.log.error("Can not unmarshall inputstream.  Tried to unmarshall as both an object and string type.", e);
/* 163 */       throw new IOException("Can not unmarshall inputstream.");
/*     */     }
/*     */ 
/* 166 */     return ret;
/*     */   }
/*     */ 
/*     */   public UnMarshaller cloneUnMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 172 */     HTTPUnMarshaller unmarshaller = new HTTPUnMarshaller();
/* 173 */     unmarshaller.setClassLoader(this.customClassLoader);
/* 174 */     return unmarshaller;
/*     */   }
/*     */ 
/*     */   private boolean isErrorReturn(Map metadata)
/*     */   {
/* 179 */     boolean isError = false;
/* 180 */     if (metadata != null)
/*     */     {
/* 183 */       Object value = metadata.get("ResponseCode");
/* 184 */       if ((value != null) && ((value instanceof Integer)))
/*     */       {
/* 186 */         int responseCode = ((Integer)value).intValue();
/* 187 */         if (responseCode > 400)
/*     */         {
/* 189 */           isError = true;
/*     */         }
/*     */       }
/*     */     }
/* 193 */     return isError;
/*     */   }
/*     */ 
/*     */   private boolean isBinaryData(Map metadata) throws IOException
/*     */   {
/* 198 */     boolean isBinary = false;
/*     */ 
/* 200 */     if (metadata != null)
/*     */     {
/* 203 */       Object value = metadata.get("Content-Type");
/* 204 */       if (value == null)
/*     */       {
/* 206 */         value = metadata.get("content-type");
/*     */       }
/* 208 */       if (value != null)
/*     */       {
/* 210 */         if ((value instanceof List))
/*     */         {
/* 212 */           List valueList = (List)value;
/* 213 */           if ((valueList != null) && (valueList.size() > 0))
/*     */           {
/* 215 */             value = valueList.get(0);
/*     */           }
/*     */         }
/* 218 */         isBinary = WebUtil.isBinary((String)value);
/*     */       }
/*     */     }
/* 221 */     return isBinary;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.http.HTTPUnMarshaller
 * JD-Core Version:    0.6.0
 */