/*     */ package org.jboss.remoting.marshal.encryption;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.security.Key;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.crypto.CipherOutputStream;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ 
/*     */ public class EncryptingMarshaller extends SerializableMarshaller
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   public static final String DATATYPE = "encrypt";
/*     */   private Marshaller wrappedMarshaller;
/*  67 */   private String cipherAlgorithm = "DES";
/*     */ 
/*  69 */   private Cipher cipher = EncryptionManager.getCipher(1, this.cipherAlgorithm);
/*     */ 
/*     */   public EncryptingMarshaller()
/*     */   {
/*     */   }
/*     */ 
/*     */   public EncryptingMarshaller(String algo, Key key)
/*     */   {
/*  88 */     this.cipher = EncryptionManager.getCipher(1, algo, key);
/*     */   }
/*     */ 
/*     */   public EncryptingMarshaller(Marshaller marshaller)
/*     */   {
/*  99 */     this.wrappedMarshaller = marshaller;
/*     */   }
/*     */ 
/*     */   public void setCipherAlgorithm(String algo)
/*     */   {
/* 109 */     this.cipherAlgorithm = algo;
/* 110 */     this.cipher = EncryptionManager.getCipher(1, this.cipherAlgorithm);
/*     */   }
/*     */ 
/*     */   public void write(Object dataObject, OutputStream output, int version)
/*     */     throws IOException
/*     */   {
/* 123 */     if (this.cipher == null)
/* 124 */       throw new IllegalStateException("Cipher is null for algo=" + this.cipherAlgorithm);
/* 125 */     output.flush();
/*     */ 
/* 128 */     EncryptionOutputStream eos = new EncryptionOutputStream(output);
/*     */ 
/* 130 */     CipherOutputStream cos = new CipherOutputStream(eos, this.cipher);
/*     */ 
/* 132 */     SerializationManager sm = SerializationStreamFactory.getManagerInstance(getSerializationType());
/* 133 */     ObjectOutputStream oos = sm.createOutput(cos);
/*     */ 
/* 135 */     if (this.wrappedMarshaller != null)
/*     */     {
/* 137 */       if ((this.wrappedMarshaller instanceof VersionedMarshaller))
/* 138 */         ((VersionedMarshaller)this.wrappedMarshaller).write(dataObject, oos, version);
/*     */       else {
/* 140 */         this.wrappedMarshaller.write(dataObject, oos);
/*     */       }
/*     */     }
/*     */     else {
/* 144 */       super.write(dataObject, oos, version);
/*     */     }
/* 146 */     oos.flush();
/*     */ 
/* 149 */     cos.close();
/* 150 */     oos.close();
/*     */   }
/*     */ 
/*     */   public Marshaller cloneMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 161 */     EncryptingMarshaller em = new EncryptingMarshaller(this.wrappedMarshaller);
/* 162 */     em.setCipherAlgorithm(this.cipherAlgorithm);
/* 163 */     return em;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.encryption.EncryptingMarshaller
 * JD-Core Version:    0.6.0
 */