/*     */ package org.jboss.remoting.marshal.compress;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.util.zip.GZIPOutputStream;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ 
/*     */ public class CompressingMarshaller extends SerializableMarshaller
/*     */ {
/*     */   public static final String DATATYPE = "compressible";
/*     */   private Marshaller wrappedMarshaller;
/*     */   private static final long serialVersionUID = 8731343309128430753L;
/*     */ 
/*     */   public CompressingMarshaller()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CompressingMarshaller(Marshaller marshaller)
/*     */   {
/*  78 */     this.wrappedMarshaller = marshaller;
/*     */   }
/*     */ 
/*     */   public void write(Object dataObject, OutputStream output, int version)
/*     */     throws IOException
/*     */   {
/*  91 */     output.flush();
/*     */ 
/*  93 */     GZIPOutputStream gzos = new GZIPOutputStream(output);
/*  94 */     ObjectOutputStream oos = SerializationStreamFactory.getManagerInstance(getSerializationType()).createOutput(gzos);
/*     */ 
/*  96 */     if (this.wrappedMarshaller != null)
/*     */     {
/*  98 */       if ((this.wrappedMarshaller instanceof VersionedMarshaller))
/*  99 */         ((VersionedMarshaller)this.wrappedMarshaller).write(dataObject, oos, version);
/*     */       else {
/* 101 */         this.wrappedMarshaller.write(dataObject, oos);
/*     */       }
/*     */     }
/*     */     else {
/* 105 */       super.write(dataObject, oos, version);
/*     */     }
/*     */ 
/* 108 */     gzos.finish();
/* 109 */     oos.flush();
/*     */   }
/*     */ 
/*     */   public Marshaller cloneMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 120 */     return new CompressingMarshaller(this.wrappedMarshaller);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.compress.CompressingMarshaller
 * JD-Core Version:    0.6.0
 */