/*     */ package org.jboss.remoting.marshal;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.loading.ClassBytes;
/*     */ import org.jboss.remoting.loading.ClassUtil;
/*     */ 
/*     */ public class MarshallerLoaderHandler
/*     */   implements ServerInvocationHandler, MarshallerLoaderConstants
/*     */ {
/*  44 */   private ServerInvoker invoker = null;
/*  45 */   private MBeanServer server = null;
/*     */ 
/*  47 */   protected static final Logger log = Logger.getLogger(MarshallerLoaderHandler.class);
/*     */ 
/*     */   public void setMBeanServer(MBeanServer server)
/*     */   {
/*  57 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public void setInvoker(ServerInvoker invoker)
/*     */   {
/*  67 */     this.invoker = invoker;
/*     */   }
/*     */ 
/*     */   public Object invoke(InvocationRequest invocation)
/*     */     throws Throwable
/*     */   {
/*  81 */     Object ret = null;
/*     */ 
/*  83 */     Object param = invocation.getParameter();
/*  84 */     Map metadMap = invocation.getRequestPayload();
/*  85 */     if (metadMap == null)
/*     */     {
/*  87 */       throw new RuntimeException("Can not load class as invocation request metadat map is null.");
/*     */     }
/*     */ 
/*  90 */     String dataType = (String)metadMap.get("datatype");
/*     */ 
/*  92 */     log.debug("MarshallerLoaderHandler received invocation with param of " + param + " and data type of " + dataType);
/*     */ 
/*  94 */     if ("get_marshaller".equals(param))
/*     */     {
/*  96 */       ret = MarshalFactory.getMarshaller(dataType, this.invoker.getSerializationType());
/*     */     }
/*  98 */     else if ("get_unmarshaller".equals(param))
/*     */     {
/* 100 */       ret = MarshalFactory.getUnMarshaller(dataType, this.invoker.getSerializationType());
/*     */     }
/* 102 */     else if ("load_class".equals(param))
/*     */     {
/* 104 */       String className = (String)metadMap.get("classname");
/* 105 */       if (className != null)
/*     */       {
/* 107 */         ret = loadClassBytes(className, this.invoker.getClassLoader());
/*     */       }
/*     */       else
/*     */       {
/* 111 */         log.error("Received invocation " + param + " to load class, but metadata map key " + "classname" + " contains a null value for the class name to load.");
/*     */       }
/*     */ 
/*     */     }
/* 115 */     else if ("load_marshaller".equals(param))
/*     */     {
/* 118 */       Marshaller marshaller = MarshalFactory.getMarshaller(dataType, this.invoker.getSerializationType());
/* 119 */       if (marshaller != null)
/*     */       {
/* 121 */         String className = marshaller.getClass().getName();
/* 122 */         ret = loadClassBytes(className, this.invoker.getClassLoader());
/*     */       }
/*     */       else
/*     */       {
/* 126 */         log.warn("Could not find registered marshaller for data type: " + dataType);
/*     */       }
/*     */     }
/* 129 */     else if ("load_unmarshaller".equals(param))
/*     */     {
/* 131 */       UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller(dataType, this.invoker.getSerializationType());
/* 132 */       if (unmarshaller != null)
/*     */       {
/* 134 */         String className = unmarshaller.getClass().getName();
/* 135 */         ret = loadClassBytes(className, this.invoker.getClassLoader());
/*     */       }
/*     */       else
/*     */       {
/* 139 */         log.warn("Could not find registered unmarshaller for data type: " + dataType);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 144 */       log.warn("Received invocation with unknown parameter request: " + param);
/*     */     }
/*     */ 
/* 148 */     return ret;
/*     */   }
/*     */ 
/*     */   private Object loadClassBytes(String className, ClassLoader classLoader)
/*     */   {
/* 153 */     ClassBytes classBytes = null;
/*     */ 
/* 155 */     if (className != null)
/*     */     {
/* 157 */       byte[] classDefinition = ClassUtil.getClassBytes(className, classLoader);
/* 158 */       classBytes = new ClassBytes(className, classDefinition);
/*     */     }
/* 160 */     return classBytes;
/*     */   }
/*     */ 
/*     */   public void addListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.MarshallerLoaderHandler
 * JD-Core Version:    0.6.0
 */