/*     */ package org.jboss.remoting.marshal;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
/*     */ 
/*     */ public class MarshallerLoaderClient
/*     */   implements MarshallerLoaderConstants
/*     */ {
/*  41 */   protected static final Logger log = Logger.getLogger(MarshallerLoaderClient.class);
/*     */ 
/*     */   public static Marshaller getMarshaller(InvokerLocator loaderLocator, String dataType, ClassLoader classByteLoader)
/*     */   {
/*  54 */     Marshaller marshaller = null;
/*     */     try
/*     */     {
/*  57 */       Marshaller loaderMarshaller = new SerializableMarshaller();
/*  58 */       UnMarshaller loaderUnMarshaller = new SerializableUnMarshaller();
/*  59 */       loaderUnMarshaller.setClassLoader(classByteLoader);
/*     */ 
/*  61 */       String marshallerMethodName = "get_marshaller";
/*  62 */       Map metadata = new HashMap();
/*  63 */       metadata.put("datatype", dataType);
/*  64 */       Client loaderClient = new Client(loaderLocator);
/*  65 */       loaderClient.connect();
/*  66 */       loaderClient.setMarshaller(loaderMarshaller);
/*  67 */       loaderClient.setUnMarshaller(loaderUnMarshaller);
/*     */ 
/*  69 */       Object obj = null;
/*  70 */       obj = loaderClient.invoke(marshallerMethodName, metadata);
/*  71 */       if (obj != null)
/*     */       {
/*  73 */         marshaller = (Marshaller)obj;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  79 */       log.error("Error creating remoting client to connect to marhsaller loader.", e);
/*     */     }
/*  81 */     if (marshaller == null)
/*     */     {
/*  83 */       log.error("Can not load marshall for loader locator " + loaderLocator + ".");
/*     */     }
/*     */ 
/*  86 */     return marshaller;
/*     */   }
/*     */ 
/*     */   public static UnMarshaller getUnMarshaller(InvokerLocator loaderLocator, String dataType, ClassLoader classByteLoader)
/*     */   {
/* 100 */     UnMarshaller unmarshaller = null;
/*     */     try
/*     */     {
/* 104 */       SerializableMarshaller loaderMarshaller = new SerializableMarshaller();
/* 105 */       SerializableUnMarshaller loaderUnMarshaller = new SerializableUnMarshaller();
/* 106 */       loaderUnMarshaller.setClassLoader(classByteLoader);
/*     */ 
/* 108 */       String marshallerMethodName = "get_unmarshaller";
/* 109 */       Map metadata = new HashMap();
/* 110 */       metadata.put("datatype", dataType);
/* 111 */       Client loaderClient = new Client(loaderLocator);
/* 112 */       loaderClient.connect();
/* 113 */       loaderClient.setMarshaller(loaderMarshaller);
/* 114 */       loaderClient.setUnMarshaller(loaderUnMarshaller);
/*     */ 
/* 116 */       Object obj = null;
/*     */ 
/* 118 */       obj = loaderClient.invoke(marshallerMethodName, metadata);
/* 119 */       if (obj != null)
/*     */       {
/* 121 */         unmarshaller = (UnMarshaller)obj;
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 126 */       log.error("Error creating remoting client to connecto to marhsaller loader.", e);
/*     */     }
/* 128 */     if (unmarshaller == null)
/*     */     {
/* 130 */       log.error("Can not load unmarshaller for loader locator " + loaderLocator + ".");
/*     */     }
/* 132 */     return unmarshaller;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.MarshallerLoaderClient
 * JD-Core Version:    0.6.0
 */