/*     */ package org.jboss.remoting.loading;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.io.StreamCorruptedException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ObjectInputStreamWithClassLoader extends ObjectInputStream
/*     */ {
/*     */   protected static Method clearMethod;
/*  46 */   protected static final Logger log = Logger.getLogger(ObjectInputStreamWithClassLoader.class);
/*     */   private ClassLoader cl;
/*     */   private static final HashMap primClasses;
/*     */ 
/*     */   public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl)
/*     */     throws IOException, StreamCorruptedException
/*     */   {
/*  95 */     super(in);
/*  96 */     this.cl = cl;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader cl)
/*     */   {
/* 107 */     this.cl = cl;
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 118 */     return this.cl;
/*     */   }
/*     */ 
/*     */   public void clearCache()
/*     */   {
/*     */     try
/*     */     {
/* 125 */       clearMethod.invoke(this, new Object[0]);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 129 */       log.error(e.getMessage(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Class resolveClass(ObjectStreamClass v)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 165 */     if (this.cl == null)
/*     */     {
/* 167 */       return super.resolveClass(v);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 174 */       return Class.forName(v.getName(), false, this.cl);
/*     */     }
/*     */     catch (ClassNotFoundException ex)
/*     */     {
/* 178 */       Class cl = (Class)primClasses.get(v.getName());
/* 179 */       if (cl != null)
/* 180 */         return cl;
/*     */     }
/* 182 */     throw ex;
/*     */   }
/*     */ 
/*     */   protected Class resolveProxyClass(String[] interfaces)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 239 */     if (this.cl == null)
/*     */     {
/* 241 */       return super.resolveProxyClass(interfaces);
/*     */     }
/*     */ 
/* 245 */     Class[] classObjs = new Class[interfaces.length];
/* 246 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 248 */       classObjs[i] = Class.forName(interfaces[i], false, this.cl);
/*     */     }
/*     */     try
/*     */     {
/* 252 */       return Proxy.getProxyClass(this.cl, classObjs);
/*     */     }
/*     */     catch (IllegalArgumentException e) {
/*     */     }
/* 256 */     throw new ClassNotFoundException(null, e);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  53 */       clearMethod = ObjectInputStream.class.getDeclaredMethod("clear", new Class[0]);
/*  54 */       clearMethod.setAccessible(true);
/*     */     } catch (SecurityException e) {
/*  56 */       log.error(e.getMessage(), e);
/*     */     } catch (NoSuchMethodException e) {
/*  58 */       log.error(e.getMessage(), e);
/*     */     }
/*     */ 
/*  66 */     primClasses = new HashMap(8, 1.0F);
/*     */ 
/*  68 */     primClasses.put("boolean", Boolean.TYPE);
/*  69 */     primClasses.put("byte", Byte.TYPE);
/*  70 */     primClasses.put("char", Character.TYPE);
/*  71 */     primClasses.put("short", Short.TYPE);
/*  72 */     primClasses.put("int", Integer.TYPE);
/*  73 */     primClasses.put("long", Long.TYPE);
/*  74 */     primClasses.put("float", Float.TYPE);
/*  75 */     primClasses.put("double", Double.TYPE);
/*  76 */     primClasses.put("void", Void.TYPE);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.loading.ObjectInputStreamWithClassLoader
 * JD-Core Version:    0.6.0
 */