/*     */ package org.jboss.remoting.loading;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassUtil
/*     */ {
/*  41 */   protected static final Logger log = Logger.getLogger(ClassUtil.class);
/*     */ 
/*     */   public static Object deserialize(ClassBytes cb, ClassLoader cl)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  46 */     if (cb.getClassBytes() == null)
/*     */     {
/*  48 */       return null;
/*     */     }
/*  50 */     ByteArrayInputStream bis = new ByteArrayInputStream(cb.getClassBytes());
/*  51 */     ObjectInputStream ois = new ObjectInputStreamWithClassLoader(bis, cl);
/*  52 */     Object result = ois.readObject();
/*  53 */     bis = null;
/*  54 */     ois = null;
/*  55 */     return result;
/*     */   }
/*     */ 
/*     */   public static Object deserialize(byte[] buf)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  61 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*  62 */     if (cl == null)
/*     */     {
/*  64 */       cl = ClassUtil.class.getClassLoader();
/*     */     }
/*  66 */     return deserialize(buf, cl);
/*     */   }
/*     */ 
/*     */   public static Object deserialize(byte[] buf, ClassLoader cl)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  72 */     if (buf == null)
/*     */     {
/*  74 */       return null;
/*     */     }
/*  76 */     ByteArrayInputStream bis = new ByteArrayInputStream(buf);
/*  77 */     ObjectInputStream ois = new ObjectInputStreamWithClassLoader(bis, cl);
/*  78 */     Object result = ois.readObject();
/*  79 */     bis = null;
/*  80 */     ois = null;
/*  81 */     return result;
/*     */   }
/*     */ 
/*     */   public static byte[] serialize(Object obj)
/*     */     throws IOException
/*     */   {
/*  87 */     ByteArrayOutputStream bos = new ByteArrayOutputStream();
/*  88 */     ObjectOutputStream oos = new ObjectOutputStream(bos);
/*  89 */     oos.writeObject(obj);
/*  90 */     oos.flush();
/*  91 */     bos.flush();
/*  92 */     byte[] buf = bos.toByteArray();
/*  93 */     bos = null;
/*  94 */     oos = null;
/*  95 */     return buf;
/*     */   }
/*     */ 
/*     */   public static boolean isArrayClass(String className)
/*     */   {
/* 100 */     return (className.startsWith("[L")) && (className.endsWith(";"));
/*     */   }
/*     */ 
/*     */   public static String getArrayClassPart(String className)
/*     */   {
/* 105 */     String cn = className;
/* 106 */     int i = className.indexOf("[L");
/* 107 */     if (i > -1)
/*     */     {
/* 109 */       cn = className.substring(i + 2, className.length() - 1);
/*     */     }
/* 111 */     return cn;
/*     */   }
/*     */ 
/*     */   public static String getPackageName(Class cl)
/*     */   {
/* 116 */     String n = cl.getName();
/* 117 */     int i = n.lastIndexOf(".");
/* 118 */     return i > -1 ? n.substring(0, i) : n;
/*     */   }
/*     */ 
/*     */   public static String getShortClassName(Class cl)
/*     */   {
/* 123 */     String n = cl.getName();
/* 124 */     int i = n.lastIndexOf(".");
/* 125 */     return i > -1 ? n.substring(i + 1) : n;
/*     */   }
/*     */ 
/*     */   public static Class[] getInterfacesFor(Class clazz)
/*     */   {
/* 138 */     Set set = new HashSet();
/* 139 */     addInterfaces(set, clazz);
/* 140 */     return (Class[])set.toArray(new Class[set.size()]);
/*     */   }
/*     */ 
/*     */   private static void addInterfaces(Set list, Class clazz)
/*     */   {
/* 145 */     if ((clazz != null) && (clazz != Object.class))
/*     */     {
/* 147 */       if ((clazz.isInterface()) && (!list.contains(clazz)))
/*     */       {
/* 149 */         list.add(clazz);
/*     */       }
/* 151 */       Class[] interfaces = clazz.getInterfaces();
/* 152 */       if ((interfaces != null) && (interfaces.length > 0))
/*     */       {
/* 154 */         for (int c = 0; c < interfaces.length; c++)
/*     */         {
/* 156 */           Class interfaceClass = interfaces[c];
/* 157 */           if (!list.contains(interfaceClass))
/*     */           {
/* 159 */             list.add(interfaceClass);
/*     */           }
/* 161 */           addInterfaces(list, interfaceClass);
/*     */         }
/*     */       }
/* 164 */       addInterfaces(list, clazz.getSuperclass());
/*     */     }
/*     */   }
/*     */ 
/*     */   public static byte[] getClassBytes(String className, ClassLoader classbyteloader)
/*     */   {
/* 176 */     String cn = null;
/* 177 */     if (isArrayClass(className))
/*     */     {
/* 182 */       cn = getArrayClassPart(className).replace('.', '/') + ".class";
/*     */     }
/*     */     else
/*     */     {
/* 186 */       cn = className.replace('.', '/') + ".class";
/*     */     }
/* 188 */     if (log.isTraceEnabled())
/*     */     {
/* 190 */       log.trace("trying to load class: " + className + " from path: " + cn);
/*     */     }
/* 192 */     InputStream in = null;
/* 193 */     ClassLoader cl = classbyteloader;
/*     */ 
/* 195 */     if (cl == null)
/*     */     {
/* 197 */       cl = ClassLoader.getSystemClassLoader();
/*     */     }
/* 199 */     if (cl != null)
/*     */     {
/* 201 */       in = cl.getResourceAsStream(cn);
/* 202 */       if (in != null)
/*     */       {
/* 204 */         if (log.isTraceEnabled())
/*     */         {
/* 206 */           log.trace("looking for classes at: " + cl);
/*     */         }
/*     */         try
/*     */         {
/* 210 */           byte[] data = read(in);
/* 211 */           if (log.isTraceEnabled())
/*     */           {
/* 213 */             log.trace("found class at classloader: " + cl);
/*     */           }
/* 215 */           arrayOfByte1 = data;
/*     */         }
/*     */         catch (IOException io)
/*     */         {
/*     */         }
/*     */         finally
/*     */         {
/*     */           byte[] arrayOfByte1;
/* 222 */           if (in != null)
/*     */           {
/*     */             try
/*     */             {
/* 226 */               in.close();
/*     */             }
/*     */             catch (Exception ig)
/*     */             {
/*     */             }
/* 231 */             in = null;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 236 */     return null;
/*     */   }
/*     */ 
/*     */   protected static byte[] read(InputStream in)
/*     */     throws IOException
/*     */   {
/* 249 */     ByteArrayOutputStream out = new ByteArrayOutputStream();
/* 250 */     byte[] buf = new byte[4096];
/*     */     while (true)
/*     */     {
/* 253 */       int c = in.read(buf);
/* 254 */       if (c < 0)
/*     */       {
/*     */         break;
/*     */       }
/* 258 */       out.write(buf, 0, c);
/*     */     }
/* 260 */     return out.toByteArray();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.loading.ClassUtil
 * JD-Core Version:    0.6.0
 */