/*     */ package org.jboss.remoting.loading;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.ref.ReferenceQueue;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ 
/*     */ public class ClassByteClassLoader extends ClassLoader
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(ClassByteClassLoader.class);
/*  49 */   private final Map loadedClasses = Collections.synchronizedMap(new HashMap());
/*  50 */   private final Map loadedResources = Collections.synchronizedMap(new HashMap());
/*  51 */   private final ReferenceQueue queue = new ReferenceQueue();
/*     */ 
/*  53 */   private Client loaderClient = null;
/*     */ 
/*     */   public ClassByteClassLoader()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ClassByteClassLoader(ClassLoader parent)
/*     */   {
/*  62 */     super(parent);
/*     */   }
/*     */ 
/*     */   public void setClientInvoker(Client loaderClient)
/*     */   {
/*  67 */     this.loaderClient = loaderClient;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  75 */     if ((this.loaderClient != null) && (this.loaderClient.isConnected()))
/*     */     {
/*  77 */       this.loaderClient.disconnect();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void clean(MyRef myref)
/*     */   {
/* 103 */     this.loadedClasses.remove(myref.key);
/* 104 */     File f = (File)this.loadedResources.remove(myref.key);
/* 105 */     if (f != null)
/*     */     {
/* 107 */       f.delete();
/*     */     }
/* 109 */     myref.clear();
/* 110 */     myref = null;
/*     */   }
/*     */ 
/*     */   private void performMaintenance()
/*     */   {
/* 119 */     int count = 0;
/* 120 */     Reference ref = null;
/* 121 */     while ((ref = this.queue.poll()) != null)
/*     */     {
/* 123 */       count++;
/* 124 */       MyRef myref = (MyRef)ref;
/* 125 */       clean(myref);
/*     */     }
/*     */ 
/* 128 */     if ((count > 0) && (log.isTraceEnabled()))
/*     */     {
/* 130 */       log.trace("ClassByteClassLoader reclaimed " + count + " objects");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 137 */     return "ClassByteClassLoader [" + this.loadedClasses + "]";
/*     */   }
/*     */ 
/*     */   protected void finalize()
/*     */     throws Throwable
/*     */   {
/* 143 */     performMaintenance();
/*     */ 
/* 145 */     Iterator iter = this.loadedResources.values().iterator();
/* 146 */     while (iter.hasNext())
/*     */     {
/* 148 */       ((File)iter.next()).delete();
/*     */     }
/* 150 */     this.loadedResources.clear();
/* 151 */     this.loadedClasses.clear();
/* 152 */     super.finalize();
/*     */   }
/*     */ 
/*     */   public Class loadClass(String className, ClassBytes[] bytes)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 159 */     performMaintenance();
/*     */ 
/* 161 */     if (log.isTraceEnabled())
/*     */     {
/* 163 */       log.trace("loadClass: " + className + ", bytes: " + bytes);
/*     */     }
/* 165 */     if (bytes != null)
/*     */     {
/* 167 */       for (int c = 0; c < bytes.length; c++)
/*     */       {
/* 169 */         addClass(bytes[c]);
/*     */       }
/*     */     }
/* 172 */     Class cl = lookupCachedClass(className);
/* 173 */     if (cl != null)
/*     */     {
/* 175 */       return cl;
/*     */     }
/* 177 */     cl = findLoadedClass(className);
/* 178 */     if (cl != null)
/*     */     {
/* 180 */       return cl;
/*     */     }
/* 182 */     cl = Class.forName(className, false, ClassLoader.getSystemClassLoader());
/* 183 */     if (cl != null)
/*     */     {
/* 185 */       return cl;
/*     */     }
/* 187 */     cl = Class.forName(className, false, getParent());
/* 188 */     if (cl != null)
/*     */     {
/* 190 */       return cl;
/*     */     }
/* 192 */     cl = loadFromNetwork(className);
/* 193 */     if (cl != null)
/*     */     {
/* 195 */       return cl;
/*     */     }
/* 197 */     throw new ClassNotFoundException("Could not load class " + className);
/*     */   }
/*     */ 
/*     */   private void addClassResource(String name, byte[] buf)
/*     */     throws IOException
/*     */   {
/* 204 */     performMaintenance();
/*     */ 
/* 206 */     OutputStream out = null;
/* 207 */     File file = null;
/*     */     try
/*     */     {
/* 210 */       file = File.createTempFile("cbc", ".class");
/* 211 */       file.deleteOnExit();
/* 212 */       if (log.isTraceEnabled())
/*     */       {
/* 214 */         log.trace("adding resource at: " + name + " to file: " + file);
/*     */       }
/* 216 */       out = new FileOutputStream(file);
/* 217 */       out.write(buf);
/* 218 */       out.flush();
/*     */     }
/*     */     catch (IOException ex)
/*     */     {
/* 222 */       file = null;
/* 223 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/* 227 */       if (out != null)
/*     */       {
/*     */         try
/*     */         {
/* 231 */           out.close();
/*     */         }
/*     */         catch (Exception ig)
/*     */         {
/*     */         }
/* 236 */         out = null;
/*     */       }
/* 238 */       if (file != null)
/*     */       {
/* 240 */         this.loadedResources.put(name, file);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getResourceAsStream(String name)
/*     */   {
/* 248 */     performMaintenance();
/*     */ 
/* 250 */     String denormalized = name.replace('/', '.').substring(0, name.length() - 6);
/* 251 */     File file = (File)this.loadedResources.get(denormalized);
/* 252 */     if (log.isTraceEnabled())
/*     */     {
/* 254 */       log.trace("getResourceAsStream =>" + denormalized + " = " + file);
/*     */     }
/* 256 */     if ((file != null) && (file.exists()))
/*     */     {
/*     */       try
/*     */       {
/* 260 */         return new BufferedInputStream(new FileInputStream(file));
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 267 */     return super.getResourceAsStream(name);
/*     */   }
/*     */ 
/*     */   public Class addClass(ClassBytes classBytes)
/*     */     throws IOException
/*     */   {
/* 274 */     performMaintenance();
/*     */ 
/* 276 */     Class cl = null;
/* 277 */     String name = classBytes.getClassName();
/* 278 */     if (!this.loadedClasses.containsKey(name))
/*     */     {
/* 280 */       byte[] buf = classBytes.getClassBytes();
/* 281 */       boolean array = ClassUtil.isArrayClass(name);
/* 282 */       String cn = array ? ClassUtil.getArrayClassPart(name) : name;
/* 283 */       if (log.isTraceEnabled())
/*     */       {
/* 285 */         log.trace("  add class: " + name + ", array?" + array + ", using as: " + cn);
/*     */       }
/* 287 */       cl = defineClass(cn, buf, 0, buf.length);
/* 288 */       resolveClass(cl);
/* 289 */       addClassResource(cn, buf);
/* 290 */       this.loadedClasses.put(cn, new MyRef(cn, cl));
/*     */     }
/* 292 */     return cl;
/*     */   }
/*     */ 
/*     */   private Class lookupCachedClass(String cn)
/*     */   {
/* 300 */     Class cl = null;
/* 301 */     MyRef ref = (MyRef)this.loadedClasses.get(cn);
/* 302 */     if (ref != null)
/*     */     {
/* 305 */       cl = (Class)ref.get();
/* 306 */       if (cl == null)
/*     */       {
/* 309 */         clean(ref);
/*     */       }
/*     */     }
/* 312 */     return cl;
/*     */   }
/*     */ 
/*     */   protected Class findClass(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/* 330 */     performMaintenance();
/*     */ 
/* 332 */     boolean array = ClassUtil.isArrayClass(name);
/* 333 */     String cn = array ? ClassUtil.getArrayClassPart(name) : name;
/* 334 */     if (log.isTraceEnabled())
/*     */     {
/* 336 */       log.trace("++ loadClass: " + name + ", array?" + array + ", normalized: [" + cn + "]");
/*     */     }
/* 338 */     Class cl = lookupCachedClass(cn);
/*     */ 
/* 340 */     if (cl == null)
/*     */     {
/* 343 */       cl = findLoadedClass(cn);
/*     */     }
/* 345 */     if (cl != null)
/*     */     {
/* 347 */       if (array)
/*     */       {
/* 351 */         Object obj = Array.newInstance(cl, 1);
/* 352 */         return obj.getClass();
/*     */       }
/* 354 */       return cl;
/*     */     }
/*     */ 
/* 357 */     cl = loadFromNetwork(cn);
/* 358 */     if (cl != null)
/*     */     {
/* 360 */       if (log.isTraceEnabled())
/*     */       {
/* 362 */         log.trace("Loaded " + cn + " can class is " + cl);
/*     */       }
/* 364 */       return cl;
/*     */     }
/*     */ 
/* 368 */     if (log.isTraceEnabled())
/*     */     {
/* 370 */       log.trace("++ findClass: " + name + " not found, throwing ClassNotFoundException");
/*     */     }
/* 372 */     throw new ClassNotFoundException(name);
/*     */   }
/*     */ 
/*     */   private Class loadFromNetwork(String className)
/*     */   {
/* 377 */     Class loadedClass = null;
/*     */ 
/* 379 */     if (this.loaderClient != null)
/*     */     {
/* 381 */       String marshallerMethodName = "load_class";
/* 382 */       Map metadata = new HashMap();
/* 383 */       metadata.put("classname", className);
/*     */       try
/*     */       {
/* 387 */         if (!this.loaderClient.isConnected())
/*     */         {
/* 389 */           this.loaderClient.connect();
/*     */         }
/* 391 */         Object obj = this.loaderClient.invoke(marshallerMethodName, metadata);
/*     */ 
/* 393 */         if (obj != null)
/*     */         {
/* 395 */           if ((obj instanceof ClassBytes))
/*     */           {
/* 397 */             ClassBytes classBytes = (ClassBytes)obj;
/* 398 */             String name = classBytes.getClassName();
/*     */ 
/* 400 */             loadedClass = addClass(classBytes);
/*     */           }
/*     */           else
/*     */           {
/* 404 */             log.error("Can not load remote class bytes.  Returned object (" + obj + ") is not ClassBytes.");
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 409 */           log.error("Can not load remote class bytes.");
/*     */         }
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/* 414 */         log.error("Error loading remote class.", throwable);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 419 */       log.trace("Remoting Client for ClassByteClassLoader is null.  Can not load class remotely.");
/*     */     }
/*     */ 
/* 422 */     return loadedClass;
/*     */   }
/*     */ 
/*     */   private final class MyRef extends WeakReference
/*     */   {
/*     */     private final String key;
/*     */ 
/*     */     MyRef(String key, Object obj)
/*     */     {
/*  92 */       super();
/*  93 */       this.key = key;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.loading.ClassByteClassLoader
 * JD-Core Version:    0.6.0
 */