/*     */ package org.jboss.remoting.ident;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.rmi.dgc.VMID;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Random;
/*     */ import java.util.Set;
/*     */ import java.util.WeakHashMap;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.remoting.network.NetworkRegistry;
/*     */ 
/*     */ public class Identity
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -2788084303665751253L;
/*  51 */   private static transient Random random = new Random(System.currentTimeMillis());
/*  52 */   public static transient String DEFAULT_DOMAIN = "JBOSS";
/*  53 */   private static transient String _domain = System.getProperty("jboss.identity.domain", DEFAULT_DOMAIN);
/*  54 */   private static transient Map identities = new WeakHashMap(2);
/*     */   private final String instanceid;
/*     */   private final InetAddress ip;
/*     */   private final String serverid;
/*     */   private String domain;
/*     */   private int hashCode;
/*     */ 
/*     */   private Identity(InetAddress addr, String instanceid, String serverid)
/*     */   {
/*  64 */     this.ip = addr;
/*  65 */     this.instanceid = instanceid;
/*  66 */     this.serverid = serverid;
/*  67 */     this.domain = ((_domain == null) || (_domain.equals("")) ? DEFAULT_DOMAIN : _domain);
/*  68 */     calcHashCode();
/*     */   }
/*     */ 
/*     */   private void calcHashCode()
/*     */   {
/*  73 */     this.hashCode = (this.ip.hashCode() + this.instanceid.hashCode() + this.serverid.hashCode() - this.domain.hashCode());
/*     */   }
/*     */ 
/*     */   public static void setDomain(String domain)
/*     */   {
/*  81 */     Iterator iter = identities.keySet().iterator();
/*  82 */     while (iter.hasNext())
/*     */     {
/*  84 */       Identity ident = (Identity)identities.get(iter.next());
/*  85 */       if (ident != null)
/*     */       {
/*  87 */         ident.domain = domain;
/*     */       }
/*  89 */       ident.calcHashCode();
/*     */     }
/*  91 */     System.setProperty("jboss.identity.domain", domain);
/*  92 */     _domain = domain;
/*  93 */     NetworkRegistry.getInstance().changeDomain(domain);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  99 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 105 */     return "JBOSS Identity\n\taddress:" + this.ip + "\n\tinstanceid:" + this.instanceid + "\n\tJMX id:" + this.serverid + "\n\tdomain:" + this.domain + "\n";
/*     */   }
/*     */ 
/*     */   public final String getDomain()
/*     */   {
/* 115 */     return this.domain;
/*     */   }
/*     */ 
/*     */   public String getInstanceId()
/*     */   {
/* 126 */     return this.instanceid;
/*     */   }
/*     */ 
/*     */   public InetAddress getAddress()
/*     */   {
/* 136 */     return this.ip;
/*     */   }
/*     */ 
/*     */   public String getJMXId()
/*     */   {
/* 147 */     return this.serverid;
/*     */   }
/*     */ 
/*     */   public boolean isSameJVM(Identity identity)
/*     */   {
/* 158 */     return identity.equals(this);
/*     */   }
/*     */ 
/*     */   public boolean isSameInstance(Identity identity)
/*     */   {
/* 171 */     return identity.getInstanceId().equals(this.instanceid);
/*     */   }
/*     */ 
/*     */   public boolean isSameMachine(Identity identity)
/*     */   {
/* 184 */     return identity.getAddress().equals(this.ip);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 189 */     if ((obj instanceof Identity))
/*     */     {
/* 191 */       return this.hashCode == obj.hashCode();
/*     */     }
/* 193 */     return false;
/*     */   }
/*     */ 
/*     */   public static final synchronized Identity get(MBeanServer server)
/*     */   {
/* 198 */     if (identities.containsKey(server))
/*     */     {
/* 200 */       return (Identity)identities.get(server);
/*     */     }
/*     */     try
/*     */     {
/* 204 */       String serverid = (String)server.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
/* 205 */       Identity identity = new Identity(InetAddress.getLocalHost(), createId(server), serverid);
/* 206 */       identities.put(server, identity);
/* 207 */       return identity;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 211 */     throw new RuntimeException("Exception creating identity: " + ex.getMessage());
/*     */   }
/*     */ 
/*     */   private static final synchronized String createId(MBeanServer server)
/*     */   {
/* 218 */     String myid = System.getProperty("jboss.identity");
/* 219 */     if (myid != null)
/*     */     {
/* 221 */       return myid;
/*     */     }
/* 223 */     String id = null;
/* 224 */     File file = null;
/*     */     try
/*     */     {
/* 228 */       ObjectName obj = new ObjectName("jboss.system:type=ServerConfig");
/* 229 */       File dir = (File)server.getAttribute(obj, "ServerDataDir");
/* 230 */       if (dir != null)
/*     */       {
/* 232 */         if (!dir.exists())
/*     */         {
/* 234 */           dir.mkdirs();
/*     */         }
/* 236 */         file = new File(dir, "jboss.identity");
/*     */       }
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */     }
/* 242 */     if (file == null)
/*     */     {
/* 245 */       String fl = System.getProperty("jboss.identity.dir", ".");
/* 246 */       File dir = new File(fl);
/* 247 */       if (!dir.exists())
/*     */       {
/* 249 */         dir.mkdirs();
/*     */       }
/* 251 */       file = new File(dir, "jboss.identity");
/*     */     }
/* 253 */     if ((file.exists()) && (file.canRead()))
/*     */     {
/* 255 */       InputStream is = null;
/*     */       try
/*     */       {
/* 258 */         is = new FileInputStream(file);
/* 259 */         byte[] buf = new byte[800];
/* 260 */         int c = is.read(buf);
/* 261 */         id = new String(buf, 0, c);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 265 */         throw new RuntimeException("Error loading jboss.identity: " + ex.toString());
/*     */       }
/*     */       finally
/*     */       {
/* 269 */         if (is != null)
/*     */         {
/*     */           try
/*     */           {
/* 273 */             is.close();
/*     */           }
/*     */           catch (Exception ig)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 283 */       OutputStream out = null;
/*     */       try
/*     */       {
/* 286 */         id = createUniqueID();
/* 287 */         if (!file.exists())
/*     */         {
/* 289 */           file.createNewFile();
/*     */         }
/* 291 */         out = new FileOutputStream(file);
/* 292 */         out.write(id.getBytes());
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 296 */         throw new RuntimeException("Error creating Instance ID: " + ex.toString());
/*     */       }
/*     */       finally
/*     */       {
/* 300 */         if (out != null)
/*     */         {
/*     */           try
/*     */           {
/* 304 */             out.flush();
/* 305 */             out.close();
/*     */           }
/*     */           catch (Exception ig)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 313 */     System.setProperty("jboss.identity", id);
/* 314 */     return id;
/*     */   }
/*     */ 
/*     */   public static final String createUniqueID()
/*     */   {
/* 319 */     String id = new VMID().toString();
/*     */ 
/* 321 */     return id.replace(':', 'x') + random.nextInt(1000);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.ident.Identity
 * JD-Core Version:    0.6.0
 */