/*     */ package org.jboss.remoting.detection.jndi;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.naming.Binding;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NameAlreadyBoundException;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.InvokerRegistry;
/*     */ import org.jboss.remoting.detection.AbstractDetector;
/*     */ import org.jboss.remoting.detection.Detection;
/*     */ import org.jboss.remoting.ident.Identity;
/*     */ import org.jboss.remoting.transport.PortUtil;
/*     */ import org.jnp.interfaces.NamingContextFactory;
/*     */ import org.jnp.server.Main;
/*     */ 
/*     */ public class JNDIDetector extends AbstractDetector
/*     */   implements JNDIDetectorMBean
/*     */ {
/*     */   private int port;
/*     */   private String host;
/*  74 */   private String contextFactory = NamingContextFactory.class.getName();
/*     */ 
/*  76 */   private String urlPackage = "org.jboss.naming:org.jnp.interfaces";
/*     */   private Identity id;
/*     */   private Context context;
/*  81 */   private int cleanDetectionCount = 0;
/*     */   public static final String DETECTION_SUBCONTEXT_NAME = "detection";
/*  85 */   private String subContextName = "detection";
/*     */ 
/*  90 */   private int detectionNumber = 5;
/*     */ 
/*  92 */   protected final Logger log = Logger.getLogger(getClass());
/*     */ 
/*     */   public JNDIDetector()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JNDIDetector(Map config)
/*     */   {
/* 100 */     super(config);
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 110 */     return this.port;
/*     */   }
/*     */ 
/*     */   public void setPort(int port)
/*     */   {
/* 120 */     this.port = port;
/*     */   }
/*     */ 
/*     */   public String getHost()
/*     */   {
/* 130 */     return this.host;
/*     */   }
/*     */ 
/*     */   public void setHost(String host)
/*     */   {
/* 140 */     this.host = host;
/*     */   }
/*     */ 
/*     */   public String getContextFactory()
/*     */   {
/* 150 */     return this.contextFactory;
/*     */   }
/*     */ 
/*     */   public void setSubContextName(String subContextName)
/*     */   {
/* 160 */     this.subContextName = subContextName;
/*     */   }
/*     */ 
/*     */   public String getSubContextName()
/*     */   {
/* 170 */     return this.subContextName;
/*     */   }
/*     */ 
/*     */   public void setContextFactory(String contextFactory)
/*     */   {
/* 181 */     this.contextFactory = contextFactory;
/*     */   }
/*     */ 
/*     */   public String getURLPackage()
/*     */   {
/* 191 */     return this.urlPackage;
/*     */   }
/*     */ 
/*     */   public void setURLPackage(String urlPackage)
/*     */   {
/* 201 */     this.urlPackage = urlPackage;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 211 */     createContext();
/* 212 */     this.id = Identity.get(this.mbeanserver);
/* 213 */     super.start();
/*     */   }
/*     */ 
/*     */   protected void heartbeat()
/*     */   {
/*     */     try
/*     */     {
/* 226 */       if (this.context == null)
/*     */       {
/* 228 */         createContext();
/*     */       }
/* 230 */       checkRemoteDetectionMsg();
/*     */     }
/*     */     catch (NamingException nex)
/*     */     {
/* 234 */       this.log.error("Can not connect to JNDI server to register local connectors.", nex);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void forceHeartbeat()
/*     */   {
/* 240 */     heartbeat();
/*     */   }
/*     */ 
/*     */   public int getCleanDetectionNumber()
/*     */   {
/* 251 */     return this.detectionNumber;
/*     */   }
/*     */ 
/*     */   public void setCleanDetectionNumber(int cleanDetectionNumber)
/*     */   {
/* 264 */     this.detectionNumber = cleanDetectionNumber;
/*     */   }
/*     */ 
/*     */   private void checkRemoteDetectionMsg()
/*     */   {
/*     */     try
/*     */     {
/* 271 */       boolean localFound = false;
/* 272 */       this.cleanDetectionCount += 1;
/* 273 */       boolean cleanDetect = this.cleanDetectionCount > this.detectionNumber;
/* 274 */       String bindName = "";
/* 275 */       NamingEnumeration enumeration = this.context.listBindings(bindName);
/* 276 */       while (enumeration.hasMore())
/*     */       {
/* 278 */         Binding binding = (Binding)enumeration.next();
/* 279 */         Detection regMsg = (Detection)binding.getObject();
/*     */ 
/* 281 */         if (isRemoteDetection(regMsg))
/*     */         {
/* 283 */           this.log.debug("Detected id: " + regMsg.getIdentity().getInstanceId() + ", message: " + regMsg);
/*     */ 
/* 285 */           if (cleanDetect)
/*     */           {
/* 287 */             if (this.log.isTraceEnabled())
/*     */             {
/* 289 */               this.log.trace("Doing clean detection.");
/*     */             }
/*     */ 
/* 293 */             ClassLoader cl = getClass().getClassLoader();
/* 294 */             if (!checkInvokerServer(regMsg, cl))
/*     */             {
/* 296 */               unregisterDetection(regMsg.getIdentity().getInstanceId());
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 302 */             detect(regMsg);
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 308 */           if (!verifyLocalDetectionMsg(regMsg))
/*     */           {
/* 310 */             addLocalDetectionMsg();
/*     */           }
/* 312 */           localFound = true;
/*     */         }
/*     */       }
/* 315 */       if (cleanDetect)
/*     */       {
/* 318 */         this.cleanDetectionCount = 0;
/*     */       }
/* 320 */       if (!localFound)
/*     */       {
/* 323 */         addLocalDetectionMsg();
/*     */       }
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 328 */       this.log.error("Exception getting detection messages from JNDI server.", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean verifyLocalDetectionMsg(Detection regMsg) throws NamingException
/*     */   {
/* 334 */     boolean verified = false;
/*     */ 
/* 336 */     InvokerLocator[] locators = InvokerRegistry.getRegisteredServerLocators();
/* 337 */     Detection msg = createDetection();
/* 338 */     String sId = this.id.getInstanceId();
/* 339 */     InvokerLocator[] invokers = regMsg.getLocators();
/*     */ 
/* 342 */     if (sId.equals(regMsg.getIdentity().getInstanceId()))
/*     */     {
/* 346 */       boolean changed = false;
/* 347 */       if (locators.length != invokers.length)
/*     */       {
/* 349 */         changed = true;
/*     */       }
/*     */       else
/*     */       {
/* 355 */         boolean found = false;
/* 356 */         for (int i = 0; i < locators.length; i++)
/*     */         {
/* 358 */           found = false;
/* 359 */           for (int x = 0; x < invokers.length; x++)
/*     */           {
/* 361 */             if (!locators[i].equals(invokers[x]))
/*     */               continue;
/* 363 */             found = true;
/* 364 */             break;
/*     */           }
/*     */ 
/* 367 */           if (!found)
/*     */           {
/*     */             break;
/*     */           }
/*     */         }
/* 372 */         if (!found)
/*     */         {
/* 374 */           changed = true;
/*     */         }
/*     */       }
/* 377 */       if (changed)
/*     */       {
/* 379 */         registerDetectionMsg(sId, msg);
/*     */       }
/*     */ 
/* 382 */       verified = true;
/*     */     }
/* 384 */     return verified;
/*     */   }
/*     */ 
/*     */   private void addLocalDetectionMsg() throws NamingException
/*     */   {
/* 389 */     Detection msg = createDetection();
/* 390 */     String sId = this.id.getInstanceId();
/* 391 */     registerDetectionMsg(sId, msg);
/*     */   }
/*     */ 
/*     */   private void registerDetectionMsg(String sId, Detection msg) throws NamingException
/*     */   {
/* 396 */     if ((sId != null) && (msg != null))
/*     */     {
/*     */       try
/*     */       {
/* 400 */         this.context.bind(sId, msg);
/* 401 */         this.log.info("Added " + sId + " to registry.");
/*     */       }
/*     */       catch (NameAlreadyBoundException nabex)
/*     */       {
/* 405 */         if (this.log.isTraceEnabled())
/*     */         {
/* 407 */           this.log.trace(sId + " already bound to server.");
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void verifyJNDIServer()
/*     */   {
/* 420 */     if ((this.host == null) || (this.host.length() == 0))
/*     */     {
/*     */       try
/*     */       {
/* 424 */         this.log.info("JNDI Server configuration information not present so will create a local server.");
/* 425 */         this.host = InetAddress.getLocalHost().getHostName();
/* 426 */         this.port = PortUtil.findFreePort(this.host);
/*     */ 
/* 428 */         this.log.info("Remoting JNDI detector starting JNDI server instance since none where specified via configuration.");
/* 429 */         this.log.info("Remoting JNDI server started on host + " + this.host + " and port " + this.port);
/*     */ 
/* 432 */         Main server = new Main();
/* 433 */         server.setPort(this.port);
/* 434 */         server.setBindAddress(this.host);
/* 435 */         server.start();
/*     */ 
/* 437 */         this.contextFactory = NamingContextFactory.class.getName();
/* 438 */         this.urlPackage = "org.jboss.naming:org.jnp.interfaces";
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 442 */         this.log.error("Error starting up JNDI server since none was specified via configuration.", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void createContext()
/*     */     throws NamingException
/*     */   {
/* 455 */     verifyJNDIServer();
/*     */ 
/* 457 */     Properties env = new Properties();
/*     */ 
/* 459 */     env.put("java.naming.factory.initial", this.contextFactory);
/* 460 */     env.put("java.naming.provider.url", this.host + ":" + this.port);
/* 461 */     env.put("java.naming.factory.url.pkgs", this.urlPackage);
/*     */ 
/* 463 */     InitialContext initialContext = new InitialContext(env);
/*     */     try
/*     */     {
/* 466 */       this.context = ((Context)initialContext.lookup(this.subContextName));
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/*     */       try
/*     */       {
/* 472 */         this.context = initialContext.createSubcontext(this.subContextName);
/*     */       }
/*     */       catch (NameAlreadyBoundException e1)
/*     */       {
/* 476 */         this.log.debug("The sub context " + this.subContextName + " was created before we could.");
/* 477 */         this.context = ((Context)initialContext.lookup(this.subContextName));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 486 */       super.stop();
/*     */     }
/*     */     finally
/*     */     {
/* 490 */       String sId = this.id.getInstanceId();
/*     */       try
/*     */       {
/* 493 */         unregisterDetection(sId);
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 497 */         this.log.warn("Could not unregister " + sId + " before shutdown.  " + "Root cause is " + e.getMessage());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void unregisterDetection(String sId)
/*     */     throws NamingException
/*     */   {
/* 505 */     if (this.log.isTraceEnabled())
/*     */     {
/* 507 */       this.log.trace("unregistering detector " + sId);
/*     */     }
/* 509 */     this.context.unbind(sId);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.detection.jndi.JNDIDetector
 * JD-Core Version:    0.6.0
 */