/*     */ package org.jboss.remoting.callback;
/*     */ 
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ 
/*     */ public class DefaultCallbackErrorHandler
/*     */   implements CallbackErrorHandler
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(DefaultCallbackErrorHandler.class);
/*     */   public static final String CALLBACK_ERRORS_ALLOWED = "callbackErrorsAllowed";
/*     */   private static final int DEFAULT_NUMBER_OF_ERRORS_ALLOWED = 5;
/*     */   private ServerInvoker serverInvoker;
/*     */   private ServerInvokerCallbackHandler callbackHandler;
/*     */   private int numOfErrorsAllowed;
/*     */   private int currentNumberOfErrors;
/*     */   private String handlerSubsystem;
/*     */ 
/*     */   public DefaultCallbackErrorHandler()
/*     */   {
/*  71 */     this.numOfErrorsAllowed = 5;
/*     */   }
/*     */ 
/*     */   public void setConfig(Map errorHandlerConfig)
/*     */   {
/*  78 */     if (errorHandlerConfig == null)
/*     */     {
/*  80 */       log.warn(this + " got null configuration");
/*  81 */       return;
/*     */     }
/*     */ 
/*  85 */     this.handlerSubsystem = ((String)errorHandlerConfig.get("handlerSubsystem"));
/*     */ 
/*  87 */     Object value = errorHandlerConfig.get("callbackErrorsAllowed");
/*  88 */     if (value != null)
/*     */     {
/*  90 */       if ((value instanceof String))
/*     */       {
/*  92 */         String stringValue = (String)value;
/*     */         try
/*     */         {
/*  95 */           this.numOfErrorsAllowed = Integer.parseInt(stringValue);
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/*  99 */           log.warn(this + " could not convert configuration value for " + "callbackErrorsAllowed" + " (" + stringValue + ") into a numeric value.");
/*     */         }
/*     */ 
/*     */       }
/* 103 */       else if ((value instanceof Integer))
/*     */       {
/* 105 */         this.numOfErrorsAllowed = ((Integer)value).intValue();
/*     */       }
/*     */       else
/*     */       {
/* 109 */         log.warn(this + " could not convert configuration value for " + "callbackErrorsAllowed" + " (" + value + ") into a numeric value. " + "Type of value should be either String or Integer.");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void handleError(Throwable ex)
/*     */     throws Throwable
/*     */   {
/* 118 */     this.currentNumberOfErrors += 1;
/*     */ 
/* 120 */     log.debug(this + " handling " + ex + ". Number of errors so far " + this.currentNumberOfErrors);
/*     */ 
/* 122 */     if (this.currentNumberOfErrors < this.numOfErrorsAllowed)
/*     */     {
/* 124 */       log.debug(this + " ignoring the callback error");
/* 125 */       throw ex;
/*     */     }
/*     */ 
/* 128 */     log.warn(this + " reached maximum number of callback errors allowed (" + this.numOfErrorsAllowed + "). Will clean up callback hander now.");
/*     */ 
/* 131 */     if (this.serverInvoker != null)
/*     */     {
/* 133 */       this.serverInvoker.removeCallbackListener(this.handlerSubsystem, this.callbackHandler);
/* 134 */       this.callbackHandler.destroy();
/*     */     }
/*     */ 
/* 138 */     throw ex;
/*     */   }
/*     */ 
/*     */   public void setServerInvoker(ServerInvoker serverInvoker)
/*     */   {
/* 143 */     log.debug(this + " setting server invoker to " + serverInvoker);
/* 144 */     this.serverInvoker = serverInvoker;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandler(ServerInvokerCallbackHandler callbackHandler)
/*     */   {
/* 149 */     log.debug(this + " setting callback handler to " + callbackHandler);
/* 150 */     this.callbackHandler = callbackHandler;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 157 */     StringBuffer sb = new StringBuffer("DefaultCallbackErrorHandler[");
/*     */ 
/* 159 */     if (this.serverInvoker == null)
/*     */     {
/* 161 */       sb.append("UNITIALIZED");
/*     */     }
/*     */     else
/*     */     {
/* 165 */       sb.append(this.serverInvoker);
/*     */     }
/*     */ 
/* 168 */     sb.append(']');
/*     */ 
/* 170 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.callback.DefaultCallbackErrorHandler
 * JD-Core Version:    0.6.0
 */