/*     */ package org.jboss.remoting.callback;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ 
/*     */ public class CallbackPoller extends TimerTask
/*     */   implements Runnable
/*     */ {
/*     */   public static final long DEFAULT_POLL_PERIOD = 5000L;
/*     */   public static final int DEFAULT_BLOCKING_TIMEOUT = 5000;
/*     */   public static final int DEFAULT_MAX_ERROR_COUNT = 5;
/*     */   public static final String SYNCHRONIZED_SHUTDOWN = "doSynchronizedShutdown";
/*     */   public static final String CALLBACK_POLL_PERIOD = "callbackPollPeriod";
/*     */   public static final String SCHEDULE_FIXED_RATE = "scheduleFixedRate";
/*     */   public static final String SCHEDULE_FIXED_DELAY = "scheduleFixedDelay";
/*     */   public static final String MAX_ERROR_COUNT = "maxErrorCount";
/*     */   public static final String REPORT_STATISTICS = "reportStatistics";
/* 110 */   private Client client = null;
/* 111 */   private InvokerCallbackHandler callbackHandler = null;
/* 112 */   private Map metadata = null;
/* 113 */   private Object callbackHandlerObject = null;
/* 114 */   private boolean blocking = false;
/* 115 */   private boolean synchronizedShutdown = false;
/* 116 */   private long pollPeriod = 5000L;
/*     */   private Timer timer;
/* 118 */   private String scheduleMode = "scheduleFixedRate";
/*     */   private boolean reportStatistics;
/*     */   private boolean running;
/* 121 */   private int maxErrorCount = -1;
/*     */   private int errorCount;
/* 125 */   private ArrayList toHandleList = new ArrayList();
/* 126 */   private ArrayList toAcknowledgeList = new ArrayList();
/*     */   private HandleThread handleThread;
/*     */   private AcknowledgeThread acknowledgeThread;
/*     */   private BlockingPollerThread blockingPollerThread;
/* 131 */   private static final Logger log = Logger.getLogger(CallbackPoller.class);
/*     */   public static final String CALLBACK_SCHEDULE_MODE = "scheduleMode";
/*     */ 
/*     */   public CallbackPoller(Client client, InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject)
/*     */   {
/* 136 */     this.client = client;
/* 137 */     this.callbackHandler = callbackhandler;
/* 138 */     this.metadata = new HashMap(metadata);
/* 139 */     this.callbackHandlerObject = callbackHandlerObject;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 144 */     if (this.callbackHandler == null)
/*     */     {
/* 146 */       throw new NullPointerException("Can not poll for callbacks when InvokerCallbackHandler is null.");
/*     */     }
/* 148 */     if (this.client != null)
/*     */     {
/* 150 */       this.client.connect();
/*     */     }
/*     */     else
/*     */     {
/* 154 */       throw new NullPointerException("Can not poll for callbacks when Client is null.");
/*     */     }
/*     */ 
/* 157 */     configureParameters();
/*     */ 
/* 159 */     this.handleThread = new HandleThread("HandleThread");
/* 160 */     this.handleThread.start();
/* 161 */     if (log.isTraceEnabled()) log.trace("blocking: " + this.blocking);
/* 162 */     if (this.blocking)
/*     */     {
/* 164 */       if (this.maxErrorCount == -1) {
/* 165 */         this.maxErrorCount = 5;
/*     */       }
/* 167 */       this.running = true;
/* 168 */       this.metadata.put("throwCallbackException", "true");
/* 169 */       this.blockingPollerThread = new BlockingPollerThread();
/* 170 */       this.blockingPollerThread.start();
/*     */     }
/*     */     else
/*     */     {
/* 174 */       this.timer = new Timer(true);
/* 175 */       if ("scheduleFixedDelay".equals(this.scheduleMode))
/* 176 */         this.timer.schedule(this, this.pollPeriod, this.pollPeriod);
/*     */       else
/* 178 */         this.timer.scheduleAtFixedRate(this, this.pollPeriod, this.pollPeriod);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void run()
/*     */   {
/*     */     try
/*     */     {
/* 187 */       if (log.isTraceEnabled()) log.trace(this + " getting callbacks for " + this.callbackHandler);
/* 188 */       List callbacks = this.client.getCallbacks(this.callbackHandler, this.metadata);
/* 189 */       if (log.isTraceEnabled()) log.trace(this + " callback count: " + (callbacks == null ? 0 : callbacks.size()));
/*     */ 
/* 191 */       if ((callbacks != null) && (callbacks.size() > 0))
/*     */       {
/* 193 */         synchronized (this.toHandleList)
/*     */         {
/* 195 */           this.toHandleList.addAll(callbacks);
/* 196 */           if (this.toHandleList.size() == callbacks.size()) {
/* 197 */             this.toHandleList.notify();
/*     */           }
/*     */         }
/*     */       }
/* 201 */       if (this.reportStatistics)
/* 202 */         reportStatistics(callbacks);
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 206 */       if (!this.running)
/*     */       {
/* 208 */         stop();
/* 209 */         return;
/*     */       }
/*     */ 
/* 212 */       log.error(this + " Error getting callbacks from server.", throwable);
/* 213 */       String errorMessage = throwable.getMessage();
/* 214 */       if (errorMessage != null)
/*     */       {
/* 216 */         if (errorMessage.startsWith("Could not find listener id"))
/*     */         {
/* 218 */           log.error("Client no longer has InvokerCallbackHandler (" + this.callbackHandler + ") registered.  Shutting down callback polling");
/*     */ 
/* 221 */           stop();
/* 222 */           return;
/*     */         }
/* 224 */         if (errorMessage.startsWith("Can not make remoting client invocation due to not being connected to server."))
/*     */         {
/* 227 */           log.error("Client no longer connected.  Shutting down callback polling");
/* 228 */           stop();
/* 229 */           return;
/*     */         }
/*     */       }
/* 232 */       if (this.maxErrorCount >= 0)
/*     */       {
/* 234 */         if (++this.errorCount > this.maxErrorCount)
/*     */         {
/* 236 */           log.error("Error limit of " + this.maxErrorCount + " exceeded.  Shutting down callback polling");
/*     */ 
/* 238 */           stop();
/* 239 */           return;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 247 */     stop(-1);
/*     */   }
/*     */ 
/*     */   public void stop(int timeout)
/*     */   {
/* 257 */     log.debug(this + " is shutting down");
/* 258 */     this.running = false;
/*     */ 
/* 260 */     if (!this.blocking)
/*     */     {
/* 262 */       cancel();
/*     */ 
/* 264 */       if (this.timer != null)
/*     */       {
/* 266 */         this.timer.cancel();
/* 267 */         this.timer = null;
/*     */       }
/*     */     }
/*     */ 
/* 271 */     if (timeout == 0) {
/* 272 */       return;
/*     */     }
/* 274 */     if (this.synchronizedShutdown)
/*     */     {
/* 279 */       synchronized (this)
/*     */       {
/* 281 */         shutdown();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 286 */     shutdown();
/*     */ 
/* 289 */     log.debug(this + " has shut down");
/*     */   }
/*     */ 
/*     */   private void shutdown()
/*     */   {
/* 297 */     if (this.handleThread != null)
/*     */     {
/* 299 */       this.handleThread.shutdown();
/* 300 */       this.handleThread = null;
/*     */     }
/*     */ 
/* 305 */     if (this.acknowledgeThread != null)
/*     */     {
/* 307 */       this.acknowledgeThread.shutdown();
/* 308 */       this.acknowledgeThread = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void checkForAcknowledgeRequest(Callback callback)
/*     */   {
/* 550 */     Map returnPayload = callback.getReturnPayload();
/* 551 */     if (returnPayload != null)
/*     */     {
/* 553 */       Object callbackId = returnPayload.get("callbackId");
/* 554 */       if (callbackId != null)
/*     */       {
/* 556 */         Object o = returnPayload.get("remotingAcknowledgesPushCallbacks");
/* 557 */         if ((((o instanceof String)) && (Boolean.valueOf((String)o).booleanValue())) || (((o instanceof Boolean)) && (((Boolean)o).booleanValue())))
/*     */         {
/* 560 */           synchronized (this.toAcknowledgeList)
/*     */           {
/* 562 */             this.toAcknowledgeList.add(callback);
/* 563 */             if (this.toAcknowledgeList.size() == 1)
/*     */             {
/* 565 */               if (this.acknowledgeThread == null)
/*     */               {
/* 567 */                 this.acknowledgeThread = new AcknowledgeThread("AcknowledgeThread");
/* 568 */                 this.acknowledgeThread.start();
/*     */               }
/*     */               else
/*     */               {
/* 572 */                 this.toAcknowledgeList.notify();
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void configureParameters()
/*     */   {
/* 584 */     if (this.metadata != null)
/*     */     {
/* 586 */       Object val = this.metadata.get("blockingMode");
/* 587 */       if (val != null)
/*     */       {
/* 589 */         if ((val instanceof String))
/*     */         {
/* 591 */           if ("blocking".equals(val))
/*     */           {
/* 593 */             this.blocking = true;
/* 594 */             this.synchronizedShutdown = false;
/*     */           }
/* 596 */           else if ("nonblocking".equals(val))
/*     */           {
/* 598 */             this.blocking = false;
/* 599 */             this.synchronizedShutdown = true;
/*     */           }
/*     */           else
/*     */           {
/* 603 */             log.warn("Value for blockingMode configuration is " + val + ". Must be either " + "blocking" + " or " + "nonblocking" + ". Using " + "blocking" + ".");
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 611 */           log.warn("Value for blockingMode configuration must be of type " + String.class.getName() + " and is of type " + val.getClass().getName());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 618 */       if (this.blocking) {
/* 619 */         this.metadata.put("blockingMode", "blocking");
/*     */       }
/* 621 */       val = this.metadata.get("blockingTimeout");
/* 622 */       if (val != null)
/*     */       {
/* 624 */         if ((val instanceof String))
/*     */         {
/*     */           try
/*     */           {
/* 628 */             int blockingTimeout = Integer.parseInt((String)val);
/* 629 */             this.metadata.put("timeout", Integer.toString(blockingTimeout));
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/* 633 */             log.warn("Error converting blockingTimeout to type long.  " + e.getMessage());
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 638 */           log.warn("Value for blockingTimeout configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 643 */       val = this.metadata.get("doSynchronizedShutdown");
/* 644 */       if (val != null)
/*     */       {
/* 646 */         if ((val instanceof String))
/*     */         {
/* 648 */           this.synchronizedShutdown = Boolean.valueOf((String)val).booleanValue();
/*     */         }
/*     */         else
/*     */         {
/* 652 */           log.warn("Value for doSynchronizedShutdown must be of type " + String.class.getName() + " and is " + val.getClass().getName());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 657 */       val = this.metadata.get("callbackPollPeriod");
/* 658 */       if (val != null)
/*     */       {
/* 660 */         if ((val instanceof String))
/*     */         {
/*     */           try
/*     */           {
/* 664 */             this.pollPeriod = Long.parseLong((String)val);
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/* 668 */             log.warn("Error converting callbackPollPeriod to type long.  " + e.getMessage());
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 673 */           log.warn("Value for callbackPollPeriod configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName());
/*     */         }
/*     */       }
/*     */ 
/* 677 */       val = this.metadata.get("scheduleMode");
/* 678 */       if (val != null)
/*     */       {
/* 680 */         if ((val instanceof String))
/*     */         {
/* 682 */           if (("scheduleFixedDelay".equals(val)) || ("scheduleFixedRate".equals(val)))
/*     */           {
/* 684 */             this.scheduleMode = ((String)val);
/*     */           }
/*     */           else
/*     */           {
/* 688 */             log.warn("Unrecognized value for scheduleMode: " + val);
/* 689 */             log.warn("Using " + this.scheduleMode);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 694 */           log.warn("Value for scheduleMode must be of type " + String.class.getName() + " and is " + val.getClass().getName());
/*     */         }
/*     */       }
/*     */ 
/* 698 */       val = this.metadata.get("maxErrorCount");
/* 699 */       if (val != null)
/*     */       {
/* 701 */         if ((val instanceof String))
/*     */         {
/*     */           try
/*     */           {
/* 705 */             this.maxErrorCount = Integer.parseInt((String)val);
/*     */           }
/*     */           catch (NumberFormatException e)
/*     */           {
/* 709 */             log.warn("Error converting maxErrorCount to type int.  " + e.getMessage());
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 714 */           log.warn("Value for maxErrorCount configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName());
/*     */         }
/*     */       }
/*     */ 
/* 718 */       if (this.metadata.get("reportStatistics") != null)
/*     */       {
/* 720 */         this.reportStatistics = true;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void reportStatistics(List callbacks)
/*     */   {
/* 729 */     int toAcknowledge = 0;
/*     */     int toHandle;
/* 731 */     synchronized (this.toHandleList)
/*     */     {
/* 733 */       toHandle = this.toHandleList.size() + this.handleThread.toHandleListCopy.size();
/*     */     }
/*     */     int toHandle;
/* 736 */     synchronized (this.toAcknowledgeList)
/*     */     {
/* 738 */       if (this.acknowledgeThread != null) {
/* 739 */         toAcknowledge = this.toAcknowledgeList.size() + this.acknowledgeThread.toAcknowledgeListCopy.size();
/*     */       }
/*     */     }
/* 742 */     StringBuffer message = new StringBuffer("\n");
/* 743 */     message.append("================================\n").append("  retrieved " + callbacks.size() + " callbacks\n").append("  callbacks waiting to be processed: " + toHandle + "\n").append("  callbacks waiting to be acknowledged: " + toAcknowledge + "\n").append("================================");
/*     */ 
/* 748 */     log.info(message);
/*     */   }
/*     */ 
/*     */   class AcknowledgeThread extends Thread
/*     */   {
/* 443 */     boolean running = true;
/*     */     boolean done;
/* 445 */     ArrayList toAcknowledgeListCopy = new ArrayList();
/*     */ 
/*     */     AcknowledgeThread(String name)
/*     */     {
/* 449 */       super();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       while (true) {
/* 455 */         synchronized (CallbackPoller.this.toAcknowledgeList)
/*     */         {
/* 457 */           if ((!CallbackPoller.this.toAcknowledgeList.isEmpty()) || (!this.running))
/*     */             continue;
/*     */           try
/*     */           {
/* 461 */             CallbackPoller.this.toAcknowledgeList.wait();
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/* 465 */             CallbackPoller.log.warn("unexpected interrupt");
/* 466 */           }continue;
/*     */ 
/* 472 */           if (!CallbackPoller.this.toAcknowledgeList.isEmpty())
/*     */             continue;
/* 474 */           this.done = true;
/* 475 */           CallbackPoller.this.toAcknowledgeList.notify();
/* 476 */           return;
/*     */ 
/* 479 */           this.toAcknowledgeListCopy.addAll(CallbackPoller.this.toAcknowledgeList);
/* 480 */           CallbackPoller.this.toAcknowledgeList.clear();
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 485 */           if (CallbackPoller.log.isTraceEnabled())
/*     */           {
/* 487 */             Iterator it = this.toAcknowledgeListCopy.iterator();
/* 488 */             while (it.hasNext())
/*     */             {
/* 490 */               Callback cb = (Callback)it.next();
/* 491 */               Map map = cb.getReturnPayload();
/* 492 */               CallbackPoller.log.trace("acknowledging: " + map.get("callbackId"));
/*     */             }
/*     */           }
/* 495 */           CallbackPoller.this.client.acknowledgeCallbacks(CallbackPoller.this.callbackHandler, this.toAcknowledgeListCopy);
/* 496 */           this.toAcknowledgeListCopy.clear();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 500 */           CallbackPoller.log.error("Error acknowledging callback for callback handler (" + CallbackPoller.this.callbackHandler + ").", t);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void shutdown()
/*     */     {
/* 528 */       CallbackPoller.log.debug(this + " is shutting down");
/* 529 */       synchronized (CallbackPoller.this.toAcknowledgeList)
/*     */       {
/* 531 */         this.running = false;
/* 532 */         CallbackPoller.this.toAcknowledgeList.notify();
/* 533 */         while (!this.done)
/*     */         {
/*     */           try
/*     */           {
/* 537 */             CallbackPoller.this.toAcknowledgeList.wait();
/*     */           } catch (InterruptedException ignored) {
/*     */           }
/*     */         }
/*     */       }
/* 542 */       CallbackPoller.log.debug(this + " has shut down");
/*     */     }
/*     */   }
/*     */ 
/*     */   class HandleThread extends Thread
/*     */   {
/* 342 */     boolean running = true;
/*     */     boolean done;
/* 344 */     ArrayList toHandleListCopy = new ArrayList();
/*     */     Callback callback;
/*     */ 
/*     */     HandleThread(String name)
/*     */     {
/* 349 */       super();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 355 */       synchronized (CallbackPoller.this.toHandleList)
/*     */       {
/* 357 */         while ((CallbackPoller.this.toHandleList.isEmpty()) && (this.running))
/*     */         {
/*     */           try
/*     */           {
/* 361 */             CallbackPoller.this.toHandleList.wait();
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/* 365 */             CallbackPoller.log.warn("unexpected interrupt");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 372 */         if (CallbackPoller.this.toHandleList.isEmpty())
/*     */         {
/* 374 */           this.done = true;
/* 375 */           CallbackPoller.this.toHandleList.notify();
/* 376 */           return;
/*     */         }
/*     */ 
/* 379 */         this.toHandleListCopy.addAll(CallbackPoller.this.toHandleList);
/* 380 */         CallbackPoller.this.toHandleList.clear();
/*     */       }
/*     */ 
/* 383 */       while (!this.toHandleListCopy.isEmpty())
/*     */       {
/*     */         try
/*     */         {
/* 387 */           this.callback = ((Callback)this.toHandleListCopy.remove(0));
/* 388 */           this.callback.setCallbackHandleObject(CallbackPoller.this.callbackHandlerObject);
/* 389 */           CallbackPoller.this.callbackHandler.handleCallback(this.callback);
/*     */         }
/*     */         catch (HandleCallbackException e)
/*     */         {
/* 393 */           CallbackPoller.log.error("Error delivering callback to callback handler (" + CallbackPoller.this.callbackHandler + ").", e);
/*     */         }
/*     */ 
/* 396 */         CallbackPoller.this.checkForAcknowledgeRequest(this.callback);
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void shutdown()
/*     */     {
/* 421 */       CallbackPoller.log.debug(this + " is shutting down");
/* 422 */       synchronized (CallbackPoller.this.toHandleList)
/*     */       {
/* 424 */         this.running = false;
/* 425 */         CallbackPoller.this.toHandleList.notify();
/* 426 */         while (!this.done)
/*     */         {
/*     */           try
/*     */           {
/* 430 */             CallbackPoller.this.toHandleList.wait();
/*     */           } catch (InterruptedException ignored) {
/*     */           }
/*     */         }
/*     */       }
/* 435 */       CallbackPoller.log.debug(this + " has shut down");
/*     */     }
/*     */   }
/*     */ 
/*     */   class BlockingPollerThread extends Thread
/*     */   {
/*     */     public BlockingPollerThread()
/*     */     {
/* 317 */       String threadName = getName();
/* 318 */       int i = threadName.indexOf('-');
/* 319 */       String threadNumber = null;
/* 320 */       if (i >= 0)
/* 321 */         threadNumber = threadName.substring(i + 1);
/*     */       else
/* 323 */         threadNumber = Long.toString(System.currentTimeMillis());
/* 324 */       String pollerString = CallbackPoller.this.toString();
/* 325 */       String address = pollerString.substring(pollerString.indexOf('@'));
/* 326 */       setName("CallbackPoller:" + threadNumber + "[" + address + "]");
/* 327 */       setDaemon(true);
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 332 */       while (CallbackPoller.this.running)
/*     */       {
/* 334 */         CallbackPoller.this.run();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.callback.CallbackPoller
 * JD-Core Version:    0.6.0
 */