/*     */ package org.jboss.remoting;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.loading.ClassByteClassLoader;
/*     */ import org.jboss.remoting.loading.RemotingClassLoader;
/*     */ import org.jboss.remoting.marshal.InvalidMarshallingResource;
/*     */ import org.jboss.remoting.marshal.MarshalFactory;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public abstract class MicroRemoteClientInvoker extends AbstractInvoker
/*     */   implements ClientInvoker
/*     */ {
/*  34 */   private static final Logger log = Logger.getLogger(MicroRemoteClientInvoker.class);
/*  35 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  37 */   protected boolean connected = false;
/*     */   private Marshaller marshaller;
/*     */   private UnMarshaller unmarshaller;
/*     */   private String dataType;
/*  41 */   private final Object clientLeaseLock = new Object();
/*  42 */   private LeasePinger leasePinger = null;
/*  43 */   private String invokerSessionID = new GUID().toString();
/*     */ 
/*     */   public MicroRemoteClientInvoker(InvokerLocator locator)
/*     */   {
/*  47 */     super(locator);
/*     */   }
/*     */ 
/*     */   public MicroRemoteClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*  52 */     super(locator, configuration);
/*     */   }
/*     */ 
/*     */   public Object invoke(InvocationRequest invocationReq)
/*     */     throws Throwable
/*     */   {
/*  60 */     Object returnValue = null;
/*  61 */     int invokeCount = 0;
/*     */ 
/*  63 */     if (this.trace) { invokeCount++; log.trace(this + "(" + invokeCount + ") invoking " + invocationReq);
/*     */     }
/*  65 */     Marshaller marshaller = getMarshaller();
/*  66 */     UnMarshaller unmarshaller = getUnMarshaller();
/*     */ 
/*  68 */     if (marshaller == null)
/*     */     {
/*  71 */       marshaller = MarshalFactory.getMarshaller(getLocator(), getClassLoader());
/*  72 */       if (marshaller == null)
/*     */       {
/*  75 */         marshaller = MarshalFactory.getMarshaller(getDataType(), getSerializationType());
/*  76 */         if (marshaller == null)
/*     */         {
/*  79 */           throw new InvalidMarshallingResource("Can not find a valid marshaller for data type: " + getDataType());
/*     */         }
/*     */ 
/*  82 */         setMarshaller(marshaller);
/*     */       }
/*     */     }
/*     */ 
/*  86 */     if (unmarshaller == null)
/*     */     {
/*  91 */       ClassLoader remotingClassLoader = new RemotingClassLoader(getClassLoader(), Thread.currentThread().getContextClassLoader());
/*     */ 
/*  95 */       unmarshaller = MarshalFactory.getUnMarshaller(getLocator(), getClassLoader());
/*  96 */       if (unmarshaller == null)
/*     */       {
/*  98 */         unmarshaller = MarshalFactory.getUnMarshaller(getDataType(), getSerializationType());
/*  99 */         if (unmarshaller == null)
/*     */         {
/* 102 */           throw new InvalidMarshallingResource("Can not find a valid unmarshaller for data type: " + getDataType());
/*     */         }
/*     */ 
/* 105 */         setUnMarshaller(unmarshaller);
/*     */       }
/* 107 */       unmarshaller.setClassLoader(remotingClassLoader);
/*     */     }
/*     */ 
/* 111 */     Object payload = null;
/* 112 */     Map metadata = invocationReq.getRequestPayload();
/* 113 */     if ((metadata != null) && (metadata.get("rawPayload") != null))
/*     */     {
/* 115 */       payload = invocationReq.getParameter();
/*     */     }
/*     */     else
/*     */     {
/* 119 */       payload = invocationReq;
/*     */     }
/*     */ 
/* 122 */     returnValue = transport(invocationReq.getSessionId(), payload, metadata, marshaller, unmarshaller);
/*     */ 
/* 126 */     if ((returnValue instanceof InvocationResponse))
/*     */     {
/* 128 */       InvocationResponse response = (InvocationResponse)returnValue;
/* 129 */       returnValue = response.getResult();
/*     */ 
/* 132 */       if (response.isException())
/*     */       {
/* 134 */         Throwable e = (Throwable)returnValue;
/*     */ 
/* 136 */         if (this.trace) log.trace(this + " received a server-side exception as response to the invocation: " + e);
/*     */         StackTraceElement[] serverStackTrace;
/* 139 */         if (e.getCause() != null)
/*     */         {
/* 141 */           StackTraceElement[] serverStackTrace = e.getCause().getStackTrace();
/* 142 */           if ((serverStackTrace == null) || (serverStackTrace.length == 0))
/*     */           {
/* 144 */             serverStackTrace = e.getStackTrace();
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 149 */           serverStackTrace = e.getStackTrace();
/*     */         }
/*     */ 
/* 156 */         if ((serverStackTrace == null) || (serverStackTrace.length == 0))
/*     */         {
/* 158 */           log.warn("An exception occurred on the server side when making remote invocation.  The exception returned from server does not include a stack trace.  Original server side exception message is " + e.getMessage(), e);
/*     */         }
/*     */ 
/* 163 */         Exception clientException = new Exception();
/* 164 */         StackTraceElement[] clientStackTrace = clientException.getStackTrace();
/* 165 */         StackTraceElement[] completeStackTrace = new StackTraceElement[serverStackTrace.length + clientStackTrace.length];
/* 166 */         System.arraycopy(serverStackTrace, 0, completeStackTrace, 0, serverStackTrace.length);
/* 167 */         System.arraycopy(clientStackTrace, 0, completeStackTrace, serverStackTrace.length, clientStackTrace.length);
/*     */ 
/* 169 */         if (e.getCause() != null)
/*     */         {
/* 171 */           e.getCause().setStackTrace(completeStackTrace);
/*     */         }
/*     */         else
/*     */         {
/* 175 */           e.setStackTrace(completeStackTrace);
/*     */         }
/*     */ 
/* 178 */         throw e;
/*     */       }
/*     */ 
/* 181 */       if (this.trace) log.trace(this + " received InvocationResponse so going to return response's return value of " + returnValue);
/*     */ 
/*     */     }
/*     */ 
/* 185 */     return returnValue;
/*     */   }
/*     */ 
/*     */   protected void preProcess(String sessionId, Object param, Map sendPayload, Map receivedPayload)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void postProcess(String sessionId, Object param, Map sendPayload, Map receivedPayload)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected abstract Object transport(String paramString, Object paramObject, Map paramMap, Marshaller paramMarshaller, UnMarshaller paramUnMarshaller)
/*     */     throws IOException, ConnectionFailedException, ClassNotFoundException;
/*     */ 
/*     */   public boolean isConnected()
/*     */   {
/* 230 */     return this.connected;
/*     */   }
/*     */ 
/*     */   public synchronized void connect()
/*     */     throws ConnectionFailedException
/*     */   {
/* 238 */     if (!this.connected)
/*     */     {
/* 240 */       log.debug(this + " connecting");
/*     */ 
/* 242 */       handleConnect();
/* 243 */       this.connected = true;
/*     */ 
/* 245 */       log.debug(this + " connected");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract void handleConnect()
/*     */     throws ConnectionFailedException;
/*     */ 
/*     */   protected abstract void handleDisconnect();
/*     */ 
/*     */   public synchronized void disconnect()
/*     */   {
/* 273 */     if (this.trace) log.trace(this + " disconnecting ...");
/*     */ 
/* 275 */     if (this.connected)
/*     */     {
/* 277 */       this.connected = false;
/* 278 */       handleDisconnect();
/* 279 */       ClassLoader classLoader = getClassLoader();
/* 280 */       if ((classLoader != null) && ((classLoader instanceof ClassByteClassLoader)))
/*     */       {
/* 282 */         this.classbyteloader.destroy();
/*     */       }
/* 284 */       if (this.trace) log.trace(this + " disconnected");
/*     */ 
/*     */     }
/* 288 */     else if (this.trace) { log.trace(this + " is not connected!");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMarshaller(Marshaller marshaller)
/*     */   {
/* 294 */     this.marshaller = marshaller;
/*     */   }
/*     */ 
/*     */   public Marshaller getMarshaller()
/*     */   {
/* 299 */     return this.marshaller;
/*     */   }
/*     */ 
/*     */   public void setUnMarshaller(UnMarshaller unmarshaller)
/*     */   {
/* 304 */     this.unmarshaller = unmarshaller;
/*     */   }
/*     */ 
/*     */   public UnMarshaller getUnMarshaller()
/*     */   {
/* 309 */     return this.unmarshaller;
/*     */   }
/*     */ 
/*     */   public void terminateLease(String sessionId, int disconnectTimeout)
/*     */   {
/* 314 */     synchronized (this.clientLeaseLock)
/*     */     {
/* 316 */       if (this.leasePinger != null)
/*     */       {
/* 318 */         this.leasePinger.setDisconnectTimeout(disconnectTimeout);
/* 319 */         boolean isLastClientLease = this.leasePinger.removeClient(sessionId);
/* 320 */         if (isLastClientLease)
/*     */         {
/*     */           try
/*     */           {
/* 324 */             this.leasePinger.stopPing();
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 328 */             log.error("error shutting down lease pinger");
/*     */           }
/* 330 */           this.leasePinger = null;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public long getLeasePeriod(String sessionID)
/*     */   {
/* 338 */     synchronized (this.clientLeaseLock)
/*     */     {
/* 340 */       if (this.leasePinger == null)
/*     */       {
/* 342 */         return -1L;
/*     */       }
/*     */ 
/* 345 */       return this.leasePinger.getLeasePeriod(sessionID);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void establishLease(String clientSessionID, Map configuration, long leasePeriod)
/*     */     throws Throwable
/*     */   {
/* 352 */     synchronized (this.clientLeaseLock)
/*     */     {
/* 356 */       if (this.leasePinger != null)
/*     */       {
/* 358 */         this.leasePinger.addClient(clientSessionID, configuration, leasePeriod);
/* 359 */         log.debug(this + " added client with session ID " + clientSessionID + " to the lease pinger");
/* 360 */         return;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 365 */         if (this.trace) log.trace(this + " sending initial lease ping to server to determine if server has leasing enabled.");
/*     */ 
/* 370 */         InvocationRequest ir = new InvocationRequest(this.invokerSessionID, null, "$PING$", null, new HashMap(), null);
/*     */ 
/* 373 */         Object ret = invoke(ir);
/*     */ 
/* 375 */         if ((ret instanceof InvocationResponse))
/*     */         {
/* 377 */           InvocationResponse resp = (InvocationResponse)ret;
/* 378 */           Boolean shouldLease = (Boolean)resp.getResult();
/*     */ 
/* 380 */           if (shouldLease.booleanValue())
/*     */           {
/* 382 */             long defaultLeasePeriod = 5000L;
/* 383 */             Map respMap = resp.getPayload();
/*     */ 
/* 385 */             if (respMap != null)
/*     */             {
/* 387 */               Long leaseTimeoutValue = (Long)respMap.get("clientLeasePeriod");
/* 388 */               long serverDefaultLeasePeriod = leaseTimeoutValue.longValue();
/* 389 */               if (serverDefaultLeasePeriod > 0L)
/*     */               {
/* 391 */                 defaultLeasePeriod = serverDefaultLeasePeriod;
/*     */               }
/*     */             }
/*     */ 
/* 395 */             if (this.trace) log.trace("server does have leasing enabled (with default lease period of " + defaultLeasePeriod + ") and will start a new lease pinger.");
/*     */ 
/* 397 */             this.leasePinger = new LeasePinger(this, this.invokerSessionID, defaultLeasePeriod);
/* 398 */             this.leasePinger.addClient(clientSessionID, configuration, leasePeriod);
/* 399 */             this.leasePinger.startPing();
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/* 405 */         Exception e = new Exception("Error setting up client lease");
/* 406 */         e.initCause(throwable);
/* 407 */         throw e;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getDataType()
/*     */   {
/* 420 */     if (this.dataType == null)
/*     */     {
/* 422 */       this.dataType = getDataType(getLocator());
/* 423 */       if (this.dataType == null)
/*     */       {
/* 425 */         this.dataType = getDefaultDataType();
/*     */       }
/*     */     }
/* 428 */     return this.dataType;
/*     */   }
/*     */ 
/*     */   private String getDataType(InvokerLocator locator)
/*     */   {
/* 433 */     String type = null;
/*     */ 
/* 435 */     if (locator != null)
/*     */     {
/* 437 */       Map params = locator.getParameters();
/* 438 */       if (params != null)
/*     */       {
/* 440 */         type = (String)params.get("datatype");
/* 441 */         if (type == null)
/*     */         {
/* 443 */           type = (String)params.get("dataType");
/*     */         }
/*     */       }
/*     */     }
/* 447 */     return type;
/*     */   }
/*     */ 
/*     */   protected abstract String getDefaultDataType();
/*     */ 
/*     */   protected void finalize()
/*     */     throws Throwable
/*     */   {
/* 507 */     disconnect();
/* 508 */     super.finalize();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.MicroRemoteClientInvoker
 * JD-Core Version:    0.6.0
 */