/*     */ package org.jboss.remoting;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ 
/*     */ public class LeasePinger
/*     */ {
/*  24 */   private static final Logger log = Logger.getLogger(LeasePinger.class);
/*     */   public static final long DEFAULT_LEASE_PERIOD = 5000L;
/*     */   public static final int DEFAULT_DISCONNECT_TIMEOUT = -1;
/*  31 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/*  33 */   private static Timer timer = new Timer(true);
/*     */ 
/*  37 */   private long defaultPingPeriod = -1L;
/*     */ 
/*  39 */   private ClientInvoker invoker = null;
/*  40 */   private String invokerSessionID = null;
/*     */ 
/*  42 */   private Map clients = new ConcurrentHashMap();
/*  43 */   private TimerTask timerTask = null;
/*     */ 
/*  45 */   private long pingPeriod = -1L;
/*  46 */   private int disconnectTimeout = -1;
/*     */ 
/*     */   public LeasePinger(ClientInvoker invoker, String invokerSessionID, long defaultLeasePeriod)
/*     */   {
/*  52 */     this.invoker = invoker;
/*  53 */     this.invokerSessionID = invokerSessionID;
/*  54 */     this.pingPeriod = defaultLeasePeriod;
/*  55 */     this.defaultPingPeriod = defaultLeasePeriod;
/*     */   }
/*     */ 
/*     */   public void startPing()
/*     */   {
/*  62 */     if (trace) log.trace(this + " starting lease timer with ping period of " + this.pingPeriod);
/*     */ 
/*  64 */     this.timerTask = new LeaseTimerTask(this);
/*  65 */     timer.schedule(this.timerTask, this.pingPeriod, this.pingPeriod);
/*     */   }
/*     */ 
/*     */   public void stopPing()
/*     */   {
/*  70 */     if (trace) log.trace(this + " stopping lease timer");
/*     */ 
/*  72 */     if (this.timerTask != null)
/*     */     {
/*  74 */       this.timerTask.cancel();
/*  75 */       this.timerTask = null;
/*     */       try
/*     */       {
/*  81 */         HashMap metadata = null;
/*     */ 
/*  84 */         if (this.disconnectTimeout != 0)
/*     */         {
/*  86 */           if (this.disconnectTimeout > 0)
/*     */           {
/*  88 */             metadata = new HashMap(1);
/*  89 */             metadata.put("timeout", Integer.toString(this.disconnectTimeout));
/*     */           }
/*  91 */           InvocationRequest ir = new InvocationRequest(this.invokerSessionID, null, "$DISCONNECT$", metadata, null, null);
/*     */ 
/*  93 */           this.invoker.invoke(ir);
/*     */         }
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/*  98 */         RuntimeException e = new RuntimeException("Error tearing down lease with server.");
/*  99 */         e.initCause(throwable);
/* 100 */         throw e;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addClient(String sessionID, Map configuration, long leasePeriod)
/*     */   {
/* 107 */     if (leasePeriod <= 0L)
/*     */     {
/* 109 */       leasePeriod = this.defaultPingPeriod;
/*     */     }
/*     */ 
/* 112 */     if (trace) log.trace(this + " adding new client with session ID " + sessionID + " and lease period " + leasePeriod);
/*     */ 
/* 114 */     ClientHolder newClient = new ClientHolder(sessionID, configuration, leasePeriod);
/* 115 */     this.clients.put(sessionID, newClient);
/*     */ 
/* 117 */     sendClientPing();
/*     */ 
/* 120 */     if (leasePeriod < this.pingPeriod)
/*     */     {
/* 122 */       this.pingPeriod = leasePeriod;
/*     */ 
/* 125 */       if (this.timerTask != null)
/*     */       {
/* 127 */         this.timerTask.cancel();
/* 128 */         this.timerTask = null;
/* 129 */         startPing();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean removeClient(String sessionID)
/*     */   {
/* 136 */     boolean isLastClientLease = false;
/*     */ 
/* 138 */     if (trace) log.trace(this + " removing client with session ID " + sessionID);
/*     */ 
/* 140 */     ClientHolder holder = (ClientHolder)this.clients.remove(sessionID);
/*     */ 
/* 142 */     if (holder != null)
/*     */     {
/*     */       try
/*     */       {
/* 147 */         Map clientMap = new HashMap();
/* 148 */         clientMap.put("ClientHolderKey", holder);
/*     */ 
/* 151 */         if (this.disconnectTimeout != 0)
/*     */         {
/* 153 */           if (this.disconnectTimeout > 0) {
/* 154 */             clientMap.put("timeout", Integer.toString(this.disconnectTimeout));
/*     */           }
/* 156 */           InvocationRequest ir = new InvocationRequest(this.invokerSessionID, null, "$DISCONNECT$", clientMap, null, null);
/*     */ 
/* 158 */           this.invoker.invoke(ir);
/*     */ 
/* 160 */           if (trace) log.trace(this + " sent out disconnect message to server for lease tied to client with session ID " + sessionID);
/*     */         }
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/* 165 */         log.warn(this + " failed sending disconnect for client lease for " + "client with session ID " + sessionID);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 171 */       log.warn(this + " tried to remove lease for client with session ID " + sessionID + ", but no such lease was found");
/*     */     }
/*     */ 
/* 175 */     if (this.clients.isEmpty())
/*     */     {
/* 177 */       isLastClientLease = true;
/* 178 */       if (trace) log.trace(this + " has no more client leases");
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 185 */       long tempPingPeriod = this.defaultPingPeriod;
/*     */ 
/* 187 */       for (Iterator i = this.clients.values().iterator(); i.hasNext(); )
/*     */       {
/* 189 */         ClientHolder clientHolder = (ClientHolder)i.next();
/* 190 */         long clientHolderLeasePeriod = clientHolder.getLeasePeriod();
/* 191 */         if ((clientHolderLeasePeriod > 0L) && (clientHolderLeasePeriod < tempPingPeriod))
/*     */         {
/* 193 */           tempPingPeriod = clientHolderLeasePeriod;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 198 */       if (tempPingPeriod != this.pingPeriod)
/*     */       {
/* 201 */         this.pingPeriod = tempPingPeriod;
/*     */ 
/* 203 */         if (this.timerTask != null)
/*     */         {
/* 205 */           this.timerTask.cancel();
/* 206 */           this.timerTask = null;
/*     */         }
/* 208 */         startPing();
/*     */       }
/*     */     }
/*     */ 
/* 212 */     return isLastClientLease;
/*     */   }
/*     */ 
/*     */   public long getLeasePeriod(String sessionID)
/*     */   {
/* 217 */     if (this.timerTask == null)
/*     */     {
/* 219 */       return -1L;
/*     */     }
/*     */ 
/* 223 */     if (this.clients.containsKey(sessionID))
/*     */     {
/* 225 */       return this.pingPeriod;
/*     */     }
/*     */ 
/* 229 */     return -1L;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 235 */     return "LeasePinger[" + this.invoker + "(" + this.invokerSessionID + ")]";
/*     */   }
/*     */ 
/*     */   protected int getDisconnectTimeout()
/*     */   {
/* 245 */     return this.disconnectTimeout;
/*     */   }
/*     */ 
/*     */   protected void setDisconnectTimeout(int disconnectTimeout)
/*     */   {
/* 250 */     this.disconnectTimeout = disconnectTimeout;
/* 251 */     log.debug(this + " setting disconnect timeout to: " + disconnectTimeout);
/*     */   }
/*     */ 
/*     */   private void sendClientPing()
/*     */   {
/*     */     try
/*     */     {
/* 260 */       if (trace)
/*     */       {
/* 262 */         StringBuffer sb = new StringBuffer();
/*     */         Iterator i;
/* 263 */         if (this.clients != null)
/*     */         {
/* 265 */           for (i = this.clients.values().iterator(); i.hasNext(); )
/*     */           {
/* 267 */             ClientHolder h = (ClientHolder)i.next();
/* 268 */             sb.append("    ").append(h.getSessionId()).append('\n');
/*     */           }
/*     */         }
/*     */ 
/* 272 */         log.trace(this + " sending ping to server. Currently managing lease " + "for following clients:\n" + sb.toString());
/*     */       }
/*     */ 
/* 276 */       Map clientsClone = new ConcurrentHashMap(this.clients);
/* 277 */       Map requestClients = new ConcurrentHashMap();
/* 278 */       requestClients.put("ClientHolderKey", clientsClone);
/*     */ 
/* 280 */       InvocationRequest ir = new InvocationRequest(this.invokerSessionID, null, "$PING$", requestClients, null, null);
/*     */ 
/* 283 */       this.invoker.invoke(ir);
/*     */ 
/* 285 */       if (trace) log.trace(this + " successfully pinged the server");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 289 */       log.debug(this + " failed to ping to server", t);
/* 290 */       log.warn(this + " failed to ping to server: " + t.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class LeaseTimerTask extends TimerTask
/*     */   {
/*     */     private LeasePinger pinger;
/*     */ 
/*     */     LeaseTimerTask(LeasePinger pinger)
/*     */     {
/* 302 */       this.pinger = pinger;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       LeasePinger currentPinger;
/* 308 */       synchronized (this)
/*     */       {
/* 310 */         currentPinger = this.pinger;
/*     */       }
/*     */       LeasePinger currentPinger;
/* 313 */       if (currentPinger != null)
/*     */       {
/* 315 */         currentPinger.sendClientPing();
/*     */       }
/*     */     }
/*     */ 
/*     */     public boolean cancel()
/*     */     {
/* 321 */       synchronized (this)
/*     */       {
/* 323 */         this.pinger = null;
/*     */       }
/* 325 */       return super.cancel();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.LeasePinger
 * JD-Core Version:    0.6.0
 */