/*     */ package org.jboss.remoting;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*     */ import org.jboss.remoting.transport.ClientFactory;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ import org.jboss.remoting.transport.ServerFactory;
/*     */ import org.jboss.remoting.transport.local.LocalClientInvoker;
/*     */ 
/*     */ public class InvokerRegistry
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(InvokerRegistry.class);
/*     */ 
/*  57 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/*  59 */   private static final Map clientLocators = new HashMap();
/*  60 */   private static final Map serverLocators = new HashMap();
/*     */ 
/*  62 */   private static final Set registeredLocators = new HashSet();
/*  63 */   private static final Object serverLock = new Object();
/*  64 */   private static final Object clientLock = new Object();
/*     */ 
/*  66 */   private static final Map transportClientFactoryClasses = new HashMap();
/*  67 */   private static final Map transportServerFactoryClasses = new HashMap();
/*     */ 
/*     */   public static final synchronized InvokerLocator[] getRegisteredServerLocators()
/*     */   {
/*  74 */     return (InvokerLocator[])registeredLocators.toArray(new InvokerLocator[registeredLocators.size()]);
/*     */   }
/*     */ 
/*     */   public static synchronized InvokerLocator getSuitableServerLocatorForRemote(InvokerLocator remote)
/*     */   {
/*  85 */     Iterator iter = registeredLocators.iterator();
/*  86 */     while (iter.hasNext())
/*     */     {
/*  88 */       InvokerLocator l = (InvokerLocator)iter.next();
/*  89 */       if (l.getProtocol().equals(remote.getProtocol()))
/*     */       {
/*  92 */         return l;
/*     */       }
/*     */     }
/*  95 */     return null;
/*     */   }
/*     */ 
/*     */   public static final String[] getRegisteredInvokerTransports()
/*     */   {
/* 103 */     synchronized (clientLock)
/*     */     {
/* 105 */       Set set = transportClientFactoryClasses.keySet();
/* 106 */       String[] transports = new String[set.size()];
/* 107 */       return (String[])set.toArray(transports);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final ClientInvoker[] getClientInvokers()
/*     */   {
/* 116 */     synchronized (clientLock)
/*     */     {
/* 118 */       if (clientLocators.isEmpty())
/*     */       {
/* 120 */         return new ClientInvoker[0];
/*     */       }
/* 122 */       List clientInvokerList = new ArrayList();
/* 123 */       Collection collection = clientLocators.values();
/* 124 */       Iterator itr = collection.iterator();
/* 125 */       while (itr.hasNext())
/*     */       {
/* 127 */         List holderList = (List)itr.next();
/* 128 */         if (holderList != null)
/*     */         {
/* 130 */           for (int x = 0; x < holderList.size(); x++)
/*     */           {
/* 132 */             ClientInvokerHolder holder = (ClientInvokerHolder)holderList.get(x);
/* 133 */             clientInvokerList.add(holder.getClientInvoker());
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 138 */       return (ClientInvoker[])clientInvokerList.toArray(new ClientInvoker[clientInvokerList.size()]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final ServerInvoker[] getServerInvokers()
/*     */   {
/* 147 */     synchronized (serverLock)
/*     */     {
/* 149 */       if (serverLocators.isEmpty())
/*     */       {
/* 151 */         return new ServerInvoker[0];
/*     */       }
/* 153 */       Collection collection = serverLocators.values();
/* 154 */       return (ServerInvoker[])collection.toArray(new ServerInvoker[collection.size()]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static synchronized void registerInvokerFactories(String transport, Class clientFactory, Class serverFactory)
/*     */   {
/* 167 */     transportClientFactoryClasses.put(transport, clientFactory);
/* 168 */     transportServerFactoryClasses.put(transport, serverFactory);
/*     */   }
/*     */ 
/*     */   public static synchronized void unregisterInvokerFactories(String transport)
/*     */   {
/* 179 */     transportClientFactoryClasses.remove(transport);
/* 180 */     transportServerFactoryClasses.remove(transport);
/*     */   }
/*     */ 
/*     */   public static synchronized void unregisterLocator(InvokerLocator locator)
/*     */   {
/* 185 */     serverLocators.remove(locator);
/* 186 */     registeredLocators.remove(locator);
/*     */   }
/*     */ 
/*     */   public static boolean isClientInvokerRegistered(InvokerLocator locator)
/*     */   {
/* 196 */     synchronized (clientLock)
/*     */     {
/* 198 */       return clientLocators.containsKey(locator);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void destroyClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/* 209 */     synchronized (clientLock)
/*     */     {
/* 211 */       if (trace)
/*     */       {
/* 213 */         log.trace("destroying client invoker " + locator + ", config " + configuration);
/*     */       }
/*     */ 
/* 216 */       ClientInvoker invoker = decrementClientInvokerCounter(locator, configuration);
/*     */ 
/* 218 */       if (invoker != null)
/*     */       {
/* 220 */         if (trace)
/*     */         {
/* 222 */           log.trace("disconnecting " + invoker);
/*     */         }
/* 224 */         invoker.disconnect();
/* 225 */         invoker = null;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static ClientInvoker createClientInvoker(InvokerLocator locator)
/*     */     throws Exception
/*     */   {
/* 241 */     return createClientInvoker(locator, null);
/*     */   }
/*     */ 
/*     */   public static ClientInvoker createClientInvoker(InvokerLocator locator, Map configuration)
/*     */     throws Exception
/*     */   {
/* 255 */     if (locator == null)
/*     */     {
/* 257 */       throw new NullPointerException("locator cannot be null");
/*     */     }
/* 259 */     synchronized (clientLock)
/*     */     {
/* 261 */       ClientInvoker invoker = getRegisteredClientInvoker(locator, configuration);
/* 262 */       if (invoker != null)
/*     */       {
/* 264 */         if (trace) log.trace("Found and returning cached client invoker (" + invoker + ")");
/* 265 */         return invoker;
/*     */       }
/*     */ 
/* 268 */       boolean isForceRemote = false;
/* 269 */       boolean isPassByValue = false;
/* 270 */       Map parameters = locator.getParameters();
/* 271 */       if (parameters != null)
/*     */       {
/* 273 */         String value = (String)parameters.get("byvalue");
/* 274 */         if ((value != null) && (Boolean.valueOf(value).booleanValue()))
/*     */         {
/* 276 */           isPassByValue = true;
/*     */         }
/* 278 */         value = (String)parameters.get("force_remote");
/* 279 */         if ((value != null) && (Boolean.valueOf(value).booleanValue()))
/*     */         {
/* 281 */           isForceRemote = true;
/*     */         }
/*     */       }
/*     */ 
/* 285 */       if (configuration != null)
/*     */       {
/* 287 */         String value = (String)configuration.get("byvalue");
/* 288 */         if ((value != null) && (Boolean.valueOf(value).booleanValue()))
/*     */         {
/* 290 */           isPassByValue = true;
/*     */         }
/* 292 */         value = (String)configuration.get("force_remote");
/* 293 */         if ((value != null) && (Boolean.valueOf(value).booleanValue()))
/*     */         {
/* 295 */           isForceRemote = true;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 301 */       ServerInvoker svrInvoker = (ServerInvoker)serverLocators.get(locator);
/* 302 */       if ((svrInvoker != null) && (!isForceRemote))
/*     */       {
/* 304 */         LocalClientInvoker localInvoker = new LocalClientInvoker(locator, configuration, isPassByValue);
/*     */ 
/* 306 */         localInvoker.setServerInvoker(svrInvoker);
/* 307 */         invoker = localInvoker;
/* 308 */         InvokerLocator l = invoker.getLocator();
/*     */ 
/* 310 */         addRegisteredClientInvoker(invoker, l, configuration);
/*     */       }
/*     */       else
/*     */       {
/* 314 */         String protocol = locator.getProtocol();
/* 315 */         if (protocol == null)
/*     */         {
/* 317 */           throw new NullPointerException("protocol cannot be null for the locator");
/*     */         }
/*     */ 
/* 320 */         invoker = loadClientInvoker(protocol, locator, configuration);
/*     */ 
/* 322 */         InvokerLocator l = invoker.getLocator();
/*     */ 
/* 324 */         addRegisteredClientInvoker(invoker, l, configuration);
/*     */       }
/* 326 */       return invoker;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void addRegisteredClientInvoker(ClientInvoker invoker, InvokerLocator locator, Map configuration)
/*     */   {
/* 332 */     ClientInvokerHolder holder = new ClientInvokerHolder(invoker, configuration);
/* 333 */     List holderList = (List)clientLocators.get(locator);
/* 334 */     if (holderList != null)
/*     */     {
/* 336 */       if (holderList.contains(holder))
/*     */       {
/* 338 */         throw new RuntimeException("Registering new ClientInvoker (" + invoker + "), but it already exists.");
/*     */       }
/*     */ 
/* 342 */       holderList.add(holder);
/*     */     }
/*     */     else
/*     */     {
/* 347 */       holderList = new ArrayList();
/* 348 */       holderList.add(holder);
/* 349 */       clientLocators.put(locator, holderList);
/*     */     }
/*     */ 
/* 352 */     incrementClientInvokerCounter(holder);
/*     */   }
/*     */ 
/*     */   private static ClientInvoker getRegisteredClientInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/* 365 */     ClientInvoker invoker = null;
/*     */ 
/* 367 */     List holderList = (List)clientLocators.get(locator);
/* 368 */     if (holderList != null)
/*     */     {
/* 370 */       for (int x = 0; x < holderList.size(); x++)
/*     */       {
/* 372 */         ClientInvokerHolder holder = (ClientInvokerHolder)holderList.get(x);
/* 373 */         if (!sameInvoker(holder, configuration))
/*     */           continue;
/* 375 */         incrementClientInvokerCounter(holder);
/* 376 */         invoker = holder.getClientInvoker();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 381 */     return invoker;
/*     */   }
/*     */ 
/*     */   private static boolean sameInvoker(ClientInvokerHolder holder, Map configuration)
/*     */   {
/* 387 */     boolean isSame = false;
/*     */ 
/* 389 */     if ((holder != null) && (holder.getClientInvoker() != null))
/*     */     {
/* 391 */       Map config = holder.getConfig();
/* 392 */       if ((config == null) && (configuration == null))
/*     */       {
/* 394 */         isSame = true;
/*     */       }
/* 396 */       else if ((config != null) && (configuration != null))
/*     */       {
/* 398 */         isSame = config.equals(configuration);
/*     */       }
/*     */     }
/*     */ 
/* 402 */     return isSame;
/*     */   }
/*     */ 
/*     */   private static void incrementClientInvokerCounter(ClientInvokerHolder holder)
/*     */   {
/* 407 */     holder.incrementCount();
/*     */   }
/*     */ 
/*     */   private static ClientInvoker loadClientInvoker(String protocol, InvokerLocator locator, Map configuration) throws Exception
/*     */   {
/* 412 */     ClientInvoker clientInvoker = null;
/*     */ 
/* 414 */     Class transportFactoryClass = getTransportClientFactory(protocol);
/* 415 */     if (transportFactoryClass != null)
/*     */     {
/* 417 */       ClientFactory transportFactory = (ClientFactory)transportFactoryClass.newInstance();
/* 418 */       Method getClientInvokerMethod = transportFactoryClass.getMethod("createClientInvoker", new Class[] { InvokerLocator.class, Map.class });
/* 419 */       clientInvoker = (ClientInvoker)getClientInvokerMethod.invoke(transportFactory, new Object[] { locator, configuration });
/*     */     }
/*     */     else
/*     */     {
/* 423 */       throw new ClassNotFoundException("Could not find class " + transportFactoryClass);
/*     */     }
/*     */ 
/* 426 */     return clientInvoker;
/*     */   }
/*     */ 
/*     */   private static ServerInvoker loadServerInvoker(String protocol, InvokerLocator locator, Map configuration) throws Exception
/*     */   {
/* 431 */     ServerInvoker serverInvoker = null;
/*     */ 
/* 433 */     Class transportFactoryClass = getTransportServerFactory(protocol);
/* 434 */     if (transportFactoryClass != null)
/*     */     {
/* 436 */       ServerFactory transportFactory = (ServerFactory)transportFactoryClass.newInstance();
/* 437 */       Method getClientInvokerMethod = transportFactoryClass.getMethod("createServerInvoker", new Class[] { InvokerLocator.class, Map.class });
/* 438 */       serverInvoker = (ServerInvoker)getClientInvokerMethod.invoke(transportFactory, new Object[] { locator, configuration });
/*     */     }
/*     */     else
/*     */     {
/* 442 */       throw new ClassNotFoundException("Could not find class " + transportFactoryClass);
/*     */     }
/*     */ 
/* 445 */     return serverInvoker;
/*     */   }
/*     */ 
/*     */   private static Class getTransportClientFactory(String protocol)
/*     */     throws ClassNotFoundException
/*     */   {
/* 451 */     Class transportFactoryClass = (Class)transportClientFactoryClasses.get(protocol);
/* 452 */     if (transportFactoryClass == null)
/*     */     {
/* 454 */       String transportFactoryClassName = "org.jboss.remoting.transport." + protocol + ".TransportClientFactory";
/* 455 */       transportFactoryClass = ClassLoaderUtility.loadClass(InvokerRegistry.class, transportFactoryClassName);
/* 456 */       transportClientFactoryClasses.put(protocol, transportFactoryClass);
/*     */     }
/* 458 */     return transportFactoryClass;
/*     */   }
/*     */ 
/*     */   private static Class getTransportServerFactory(String protocol)
/*     */     throws ClassNotFoundException
/*     */   {
/* 464 */     Class transportFactoryClass = (Class)transportServerFactoryClasses.get(protocol);
/* 465 */     if (transportFactoryClass == null)
/*     */     {
/* 467 */       String transportFactoryClassName = "org.jboss.remoting.transport." + protocol + ".TransportServerFactory";
/* 468 */       transportFactoryClass = ClassLoaderUtility.loadClass(transportFactoryClassName, InvokerRegistry.class);
/* 469 */       transportServerFactoryClasses.put(protocol, transportFactoryClass);
/*     */     }
/* 471 */     return transportFactoryClass;
/*     */   }
/*     */ 
/*     */   public static boolean isServerInvokerRegistered(InvokerLocator locator)
/*     */   {
/* 481 */     synchronized (serverLock)
/*     */     {
/* 483 */       return serverLocators.containsKey(locator);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static ServerInvoker createServerInvoker(InvokerLocator locator)
/*     */     throws Exception
/*     */   {
/* 498 */     return createServerInvoker(locator, null);
/*     */   }
/*     */ 
/*     */   public static ServerInvoker createServerInvoker(InvokerLocator locator, Map configuration)
/*     */     throws Exception
/*     */   {
/* 513 */     ServerInvoker invoker = null;
/* 514 */     synchronized (serverLock)
/*     */     {
/* 516 */       invoker = (ServerInvoker)serverLocators.get(locator);
/* 517 */       if (invoker != null)
/*     */       {
/* 519 */         throw new InvalidConfigurationException("The invoker for locator (" + locator + ") is already " + "in use by another Connector.  Either change the locator or " + "add new handlers to existing Connector.");
/*     */       }
/*     */ 
/* 523 */       String protocol = locator.getProtocol();
/*     */ 
/* 525 */       invoker = loadServerInvoker(protocol, locator, configuration);
/*     */ 
/* 527 */       serverLocators.put(locator, invoker);
/* 528 */       registeredLocators.add(invoker.getLocator());
/*     */     }
/* 530 */     return invoker;
/*     */   }
/*     */ 
/*     */   public static void destroyServerInvoker(ServerInvoker invoker)
/*     */   {
/* 535 */     if (invoker != null)
/*     */     {
/* 537 */       InvokerLocator locator = invoker.getLocator();
/* 538 */       unregisterLocator(locator);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static ClientInvoker decrementClientInvokerCounter(InvokerLocator locator, Map configuration)
/*     */   {
/* 544 */     List holderList = (List)clientLocators.get(locator);
/*     */ 
/* 546 */     if (holderList == null)
/*     */     {
/* 548 */       log.debug("Could not decrement client invoker counter for locator " + locator + " as does not exist in invoker registry.");
/*     */ 
/* 550 */       return null;
/*     */     }
/*     */ 
/* 553 */     ClientInvokerHolder holder = null;
/*     */ 
/* 556 */     for (int x = 0; x < holderList.size(); x++)
/*     */     {
/* 558 */       holder = (ClientInvokerHolder)holderList.get(x);
/* 559 */       if (holder == null)
/*     */         continue;
/* 561 */       Map config = holder.getConfig();
/* 562 */       if ((config == null) && (configuration == null))
/*     */       {
/*     */         break;
/*     */       }
/* 566 */       if ((config != null) && (configuration != null) && 
/* 568 */         (config.equals(configuration)))
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 576 */     if (holder == null)
/*     */     {
/* 578 */       log.debug("Could not decrement client invoker counter for locator " + locator + "as does not exist in invoker registry with matching configuraion map.");
/*     */ 
/* 580 */       return null;
/*     */     }
/*     */ 
/* 583 */     ClientInvoker clientInvoker = null;
/* 584 */     holder.decrementCount();
/*     */ 
/* 586 */     if (holder.getCount() == 0)
/*     */     {
/* 588 */       clientInvoker = holder.getClientInvoker();
/* 589 */       holderList.remove(holder);
/* 590 */       if (holderList.isEmpty())
/*     */       {
/* 592 */         clientLocators.remove(locator);
/*     */       }
/*     */ 
/* 595 */       log.debug("removed " + clientInvoker + " from registry");
/*     */     }
/*     */     else
/*     */     {
/* 599 */       log.debug("decremented " + holder.getClientInvoker() + "'s count, current count " + holder.getCount());
/*     */     }
/*     */ 
/* 603 */     return clientInvoker;
/*     */   }
/*     */ 
/*     */   public static synchronized void updateServerInvokerLocator(InvokerLocator locator, InvokerLocator newLocator)
/*     */   {
/* 615 */     Object si = serverLocators.get(locator);
/* 616 */     serverLocators.remove(locator);
/* 617 */     registeredLocators.remove(locator);
/* 618 */     serverLocators.put(newLocator, si);
/* 619 */     registeredLocators.add(newLocator);
/*     */   }
/*     */ 
/*     */   public static boolean isSSLSupported(String transport)
/*     */     throws Exception
/*     */   {
/* 633 */     boolean isSSLSupported = false;
/* 634 */     Class transportFactoryClass = null;
/*     */     try
/*     */     {
/* 637 */       transportFactoryClass = getTransportClientFactory(transport);
/* 638 */       ClientFactory clientFactory = (ClientFactory)transportFactoryClass.newInstance();
/* 639 */       Method meth = transportFactoryClass.getMethod("supportsSSL", new Class[0]);
/* 640 */       Boolean boolVal = (Boolean)meth.invoke(clientFactory, null);
/* 641 */       isSSLSupported = boolVal.booleanValue();
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 645 */       Exception ex = new Exception("Can not verify transport (" + transport + ") supports SSL because can not find invoker implementation matching transport.");
/* 646 */       ex.initCause(e);
/* 647 */       throw ex;
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/* 651 */       Exception ex = new Exception("Can not call supportsSSL method on client factory class (" + transportFactoryClass + ") as there is no such method.");
/* 652 */       ex.initCause(e);
/* 653 */       throw ex;
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 657 */       Exception ex = new Exception("Can not call create instance of client factory class (" + transportFactoryClass + ").");
/* 658 */       ex.initCause(e);
/* 659 */       throw ex;
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 663 */       Exception ex = new Exception("Can not call supportsSSL method on client factory class (" + transportFactoryClass + ").");
/* 664 */       ex.initCause(e);
/* 665 */       throw ex;
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/* 669 */       Exception ex = new Exception("Can not call supportsSSL method on client factory class (" + transportFactoryClass + ").");
/* 670 */       ex.initCause(e);
/* 671 */       throw ex;
/*     */     }
/*     */ 
/* 674 */     return isSSLSupported;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 679 */     return "InvokerRegistry[" + Integer.toHexString(hashCode()) + "]";
/*     */   }
/*     */ 
/*     */   private static class ClientInvokerHolder
/*     */   {
/* 684 */     private ClientInvoker invoker = null;
/* 685 */     private Map config = null;
/* 686 */     private int counter = 0;
/*     */ 
/*     */     public ClientInvokerHolder(ClientInvoker invoker, Map config)
/*     */     {
/* 690 */       this.invoker = invoker;
/* 691 */       this.config = config;
/*     */     }
/*     */ 
/*     */     public void incrementCount()
/*     */     {
/* 696 */       this.counter += 1;
/*     */     }
/*     */ 
/*     */     public void decrementCount()
/*     */     {
/* 701 */       this.counter -= 1;
/* 702 */       if (this.counter < 0)
/*     */       {
/* 704 */         throw new RuntimeException("ClientInvokerHolder decremented to negative number for client invoker " + this.invoker);
/*     */       }
/*     */     }
/*     */ 
/*     */     public int getCount()
/*     */     {
/* 710 */       return this.counter;
/*     */     }
/*     */ 
/*     */     public ClientInvoker getClientInvoker()
/*     */     {
/* 715 */       return this.invoker;
/*     */     }
/*     */ 
/*     */     public Map getConfig()
/*     */     {
/* 720 */       return this.config;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 725 */       boolean isEqual = false;
/*     */ 
/* 727 */       if ((o instanceof ClientInvokerHolder))
/*     */       {
/* 729 */         ClientInvokerHolder h = (ClientInvokerHolder)o;
/* 730 */         if (this.invoker.equals(h.getClientInvoker()))
/*     */         {
/* 732 */           Map configuration = h.getConfig();
/* 733 */           if ((this.config == null) && (configuration == null))
/*     */           {
/* 735 */             isEqual = true;
/*     */           }
/* 737 */           else if ((this.config != null) && (configuration != null))
/*     */           {
/* 739 */             isEqual = this.config.equals(configuration);
/*     */           }
/*     */         }
/*     */       }
/* 743 */       return isEqual;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.InvokerRegistry
 * JD-Core Version:    0.6.0
 */