/*     */ package org.jboss.remoting;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.TreeMap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ 
/*     */ public class InvokerLocator
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID;
/*  69 */   protected static Logger log = Logger.getLogger(InvokerLocator.class);
/*     */   protected static Boolean legacyParsingFlag;
/*     */   protected String protocol;
/*     */   protected String host;
/*     */   protected int port;
/*     */   protected String path;
/*     */   protected String query;
/*     */   protected Map parameters;
/*     */   private String uri;
/*     */   private String originalURL;
/*     */   public static final String ANY = "0.0.0.0";
/*     */   private static final String SERVER_BIND_ADDRESS = "jboss.bind.address";
/*     */   public static final String BIND_BY_HOST = "remoting.bind_by_host";
/*     */   public static final String DATATYPE = "datatype";
/*     */   public static final String DATATYPE_CASED = "dataType";
/*     */   public static final String SERIALIZATIONTYPE = "serializationtype";
/*     */   public static final String SERIALIZATIONTYPE_CASED = "serializationType";
/*     */   public static final String MARSHALLER = "marshaller";
/*     */   public static final String UNMARSHALLER = "unmarshaller";
/*     */   public static final String LOADER_PORT = "loaderport";
/*     */   public static final String BYVALUE = "byvalue";
/*     */   public static final String FORCE_REMOTE = "force_remote";
/*     */   public static final String CLIENT_LEASE = "leasing";
/*     */   public static final String CLIENT_LEASE_PERIOD = "lease_period";
/*     */   public static final String LEGACY_PARSING = "legacyParsing";
/*     */ 
/*     */   public static boolean getUseLegacyParsing()
/*     */   {
/*  96 */     if (legacyParsingFlag == null)
/*  97 */       return false;
/*  98 */     return legacyParsingFlag.booleanValue();
/*     */   }
/*     */ 
/*     */   public static void setUseLegacyParsing(boolean flag)
/*     */   {
/* 103 */     legacyParsingFlag = new Boolean(flag);
/*     */   }
/*     */ 
/*     */   public InvokerLocator(String uri)
/*     */     throws MalformedURLException
/*     */   {
/* 192 */     this.originalURL = uri;
/* 193 */     parse(uri);
/*     */   }
/*     */ 
/*     */   private void parse(String uriString)
/*     */     throws MalformedURLException
/*     */   {
/* 200 */     boolean doLegacyParsing = false;
/* 201 */     if (legacyParsingFlag != null)
/* 202 */       doLegacyParsing = legacyParsingFlag.booleanValue();
/* 203 */     else if (System.getProperty("legacyParsing") != null) {
/* 204 */       doLegacyParsing = Boolean.getBoolean("legacyParsing");
/*     */     }
/* 206 */     if (doLegacyParsing)
/*     */     {
/* 208 */       log.warn("using deprecated legacy URL parsing routine");
/* 209 */       legacyParse(uriString);
/*     */     }
/*     */     else
/*     */     {
/* 213 */       URIParse(uriString);
/*     */     }
/*     */ 
/* 216 */     if (this.query != null)
/*     */     {
/* 218 */       StringTokenizer tok = new StringTokenizer(this.query, "&");
/* 219 */       this.parameters = new TreeMap();
/* 220 */       while (tok.hasMoreTokens())
/*     */       {
/* 222 */         String token = tok.nextToken();
/* 223 */         int eq = token.indexOf("=");
/* 224 */         String name = eq > -1 ? token.substring(0, eq) : token;
/* 225 */         String value = eq > -1 ? token.substring(eq + 1) : "";
/* 226 */         this.parameters.put(name, value);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 231 */     String portPart = this.port > -1 ? ":" + this.port : "";
/* 232 */     String divider = this.path.startsWith("/") ? "" : "/";
/* 233 */     String parametersPart = this.parameters != null ? "?" : "";
/* 234 */     this.uri = (this.protocol + "://" + this.host + portPart + divider + this.path + parametersPart);
/* 235 */     if (this.parameters != null)
/*     */     {
/* 237 */       Iterator iter = this.parameters.keySet().iterator();
/* 238 */       while (iter.hasNext())
/*     */       {
/* 240 */         String key = (String)iter.next();
/* 241 */         String val = (String)this.parameters.get(key);
/* 242 */         this.uri = (this.uri + key + "=" + val);
/* 243 */         if (iter.hasNext())
/*     */         {
/* 245 */           this.uri += "&";
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void URIParse(String uriString) throws MalformedURLException
/*     */   {
/*     */     try
/*     */     {
/* 255 */       URI uri = new URI(uriString);
/* 256 */       this.protocol = uri.getScheme();
/* 257 */       this.host = resolveHost(uri.getHost());
/* 258 */       this.port = uri.getPort();
/* 259 */       this.path = uri.getPath();
/* 260 */       this.query = uri.getQuery();
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 264 */       throw new MalformedURLException(e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void legacyParse(String uri) throws MalformedURLException
/*     */   {
/* 270 */     log.warn("Legacy InvokerLocator parsing is deprecated");
/* 271 */     int i = uri.indexOf("://");
/* 272 */     if (i < 0)
/*     */     {
/* 274 */       throw new MalformedURLException("Invalid url " + uri);
/*     */     }
/* 276 */     String tmp = uri.substring(i + 3);
/* 277 */     this.protocol = uri.substring(0, i);
/* 278 */     i = tmp.indexOf("/");
/* 279 */     int p = tmp.indexOf(":");
/* 280 */     if (i != -1)
/*     */     {
/* 282 */       p = p < i ? p : -1;
/*     */     }
/* 284 */     if (p != -1)
/*     */     {
/* 286 */       this.host = resolveHost(tmp.substring(0, p).trim());
/* 287 */       if (i > -1)
/*     */       {
/* 289 */         this.port = Integer.parseInt(tmp.substring(p + 1, i));
/*     */       }
/*     */       else
/*     */       {
/* 293 */         this.port = Integer.parseInt(tmp.substring(p + 1));
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 298 */       if (i > -1)
/*     */       {
/* 300 */         this.host = resolveHost(tmp.substring(0, i).trim());
/*     */       }
/*     */       else
/*     */       {
/* 304 */         this.host = resolveHost(tmp.substring(0).trim());
/*     */       }
/* 306 */       this.port = -1;
/*     */     }
/*     */ 
/* 310 */     p = tmp.indexOf("?");
/* 311 */     if (p != -1)
/*     */     {
/* 313 */       this.path = tmp.substring(i + 1, p);
/* 314 */       this.query = tmp.substring(p + 1);
/*     */     }
/*     */     else
/*     */     {
/* 318 */       p = tmp.indexOf("/");
/* 319 */       if (p != -1)
/*     */       {
/* 321 */         this.path = tmp.substring(p + 1);
/*     */       }
/*     */       else
/*     */       {
/* 325 */         this.path = "";
/*     */       }
/* 327 */       this.query = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final String resolveHost(String host)
/*     */   {
/* 333 */     if (host.indexOf("0.0.0.0") != -1)
/*     */     {
/* 335 */       if (System.getProperty("jboss.bind.address", "0.0.0.0").equals("0.0.0.0"))
/*     */       {
/* 337 */         host = fixRemoteAddress(host);
/*     */       }
/*     */       else
/*     */       {
/* 341 */         host = host.replaceAll("0\\.0\\.0\\.0", System.getProperty("jboss.bind.address"));
/*     */       }
/*     */     }
/* 344 */     return host;
/*     */   }
/*     */ 
/*     */   private static String fixRemoteAddress(String address)
/*     */   {
/*     */     try
/*     */     {
/* 351 */       if (address == null)
/*     */       {
/* 353 */         boolean byHost = true;
/* 354 */         String bindByHost = System.getProperty("remoting.bind_by_host", "True");
/*     */         try
/*     */         {
/* 357 */           byHost = Boolean.getBoolean(bindByHost);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/* 362 */         if (byHost)
/*     */         {
/* 364 */           return InetAddress.getLocalHost().getHostName();
/*     */         }
/*     */ 
/* 368 */         return InetAddress.getLocalHost().getHostAddress();
/*     */       }
/*     */     }
/*     */     catch (UnknownHostException ignored)
/*     */     {
/*     */     }
/*     */ 
/* 375 */     return address;
/*     */   }
/*     */ 
/*     */   public InvokerLocator(String protocol, String host, int port, String path, Map parameters)
/*     */   {
/* 388 */     this.protocol = protocol;
/* 389 */     this.host = resolveHost(host);
/* 390 */     this.port = port;
/* 391 */     this.path = path;
/* 392 */     this.parameters = parameters;
/*     */ 
/* 394 */     this.uri = (protocol + "://" + this.host + (port > -1 ? ":" + port : "") + "/" + path + (parameters != null ? "?" : ""));
/* 395 */     if (parameters != null)
/*     */     {
/* 397 */       Iterator iter = parameters.keySet().iterator();
/* 398 */       while (iter.hasNext())
/*     */       {
/* 400 */         String key = (String)iter.next();
/* 401 */         String val = (String)parameters.get(key);
/* 402 */         this.uri = (this.uri + key + "=" + val);
/* 403 */         if (iter.hasNext())
/*     */         {
/* 405 */           this.uri += "&";
/*     */         }
/*     */       }
/*     */     }
/* 409 */     this.originalURL = this.uri;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 414 */     return this.uri.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 428 */     return (obj != null) && ((obj instanceof InvokerLocator)) && (this.uri.equals(((InvokerLocator)obj).getLocatorURI()));
/*     */   }
/*     */ 
/*     */   public boolean isSameEndpoint(InvokerLocator compareMe)
/*     */   {
/* 440 */     return (compareMe != null) && (getProtocol().equalsIgnoreCase(compareMe.getProtocol())) && (getHost().equalsIgnoreCase(compareMe.getHost())) && (getPort() == compareMe.getPort());
/*     */   }
/*     */ 
/*     */   public String getLocatorURI()
/*     */   {
/* 453 */     return this.uri;
/*     */   }
/*     */ 
/*     */   public String getProtocol()
/*     */   {
/* 458 */     return this.protocol;
/*     */   }
/*     */ 
/*     */   public String getHost()
/*     */   {
/* 463 */     return this.host;
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 468 */     return this.port;
/*     */   }
/*     */ 
/*     */   public String getPath()
/*     */   {
/* 473 */     return this.path;
/*     */   }
/*     */ 
/*     */   public Map getParameters()
/*     */   {
/* 478 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 483 */     return "InvokerLocator [" + this.uri + "]";
/*     */   }
/*     */ 
/*     */   public String getOriginalURI()
/*     */   {
/* 492 */     return this.originalURL;
/*     */   }
/*     */ 
/*     */   public ClientInvoker narrow()
/*     */     throws Exception
/*     */   {
/* 503 */     return InvokerRegistry.createClientInvoker(this);
/*     */   }
/*     */ 
/*     */   public String findSerializationType()
/*     */   {
/* 509 */     String serializationTypeLocal = "java";
/* 510 */     if (this.parameters != null)
/*     */     {
/* 512 */       serializationTypeLocal = (String)this.parameters.get("serializationtype");
/* 513 */       if (serializationTypeLocal == null)
/*     */       {
/* 515 */         serializationTypeLocal = (String)this.parameters.get("serializationType");
/* 516 */         if (serializationTypeLocal == null)
/*     */         {
/* 518 */           serializationTypeLocal = "java";
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 523 */     return serializationTypeLocal;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  84 */     if (Version.getDefaultVersion() == 1)
/*     */     {
/*  86 */       serialVersionUID = -2909329895029296248L;
/*     */     }
/*     */     else
/*     */     {
/*  90 */       serialVersionUID = -4977622166779282521L;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.InvokerLocator
 * JD-Core Version:    0.6.0
 */