/*      */ package org.jboss.remoting;
/*      */ 
/*      */ import java.io.Externalizable;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.ObjectInput;
/*      */ import java.io.ObjectOutput;
/*      */ import java.io.StreamCorruptedException;
/*      */ import java.net.InetAddress;
/*      */ import java.net.SocketTimeoutException;
/*      */ import java.rmi.MarshalException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.net.SocketFactory;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.remoting.callback.Callback;
/*      */ import org.jboss.remoting.callback.CallbackPoller;
/*      */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*      */ import org.jboss.remoting.invocation.InternalInvocation;
/*      */ import org.jboss.remoting.invocation.OnewayInvocation;
/*      */ import org.jboss.remoting.marshal.Marshaller;
/*      */ import org.jboss.remoting.marshal.UnMarshaller;
/*      */ import org.jboss.remoting.stream.StreamServer;
/*      */ import org.jboss.remoting.transport.BidirectionalClientInvoker;
/*      */ import org.jboss.remoting.transport.ClientInvoker;
/*      */ import org.jboss.remoting.transport.Connector;
/*      */ import org.jboss.remoting.transport.PortUtil;
/*      */ import org.jboss.remoting.transport.local.LocalClientInvoker;
/*      */ import org.jboss.util.id.GUID;
/*      */ import org.jboss.util.threadpool.BasicThreadPool;
/*      */ import org.jboss.util.threadpool.BlockingMode;
/*      */ import org.jboss.util.threadpool.ThreadPool;
/*      */ 
/*      */ public class Client
/*      */   implements Externalizable
/*      */ {
/*      */   public static final String ONEWAY_FLAG = "oneway";
/*      */   public static final String LISTENER_ID_KEY = "listenerId";
/*      */   public static final int MAX_NUM_ONEWAY_THREADS_DEFAULT = 10;
/*      */   public static final String RAW = "rawPayload";
/*      */   public static final String ENABLE_LEASE = "enableLease";
/*      */   public static final String HANDSHAKE_COMPLETED_LISTENER = "handshakeCompletedListener";
/*      */   public static final String CALLBACK_SERVER_PROTOCOL = "callbackServerProtocol";
/*      */   public static final String CALLBACK_SERVER_HOST = "callbackServerHost";
/*      */   public static final String CALLBACK_SERVER_PORT = "callbackServerPort";
/*      */   public static final String MAX_NUM_ONEWAY_THREADS = "maxNumThreadsOneway";
/*      */   public static final String MAX_ONEWAY_THREAD_POOL_QUEUE_SIZE = "maxOnewayThreadPoolQueueSize";
/*      */   public static final int DEFAULT_DISCONNECT_TIMEOUT = -1;
/*      */   public static final String THROW_CALLBACK_EXCEPTION = "throwCallbackException";
/*  156 */   private static final Logger log = Logger.getLogger(Client.class);
/*      */   private static final long serialVersionUID = 5679279425009837934L;
/*  167 */   private int maxNumberThreads = 10;
/*  168 */   private int maxOnewayThreadPoolQueueSize = -1;
/*      */   private ClientInvoker invoker;
/*      */   private ClassLoader classloader;
/*      */   private String subsystem;
/*      */   private String sessionId;
/*  173 */   private Object onewayThreadPoolLock = new Object();
/*      */   private ThreadPool onewayThreadPool;
/*      */   private InvokerLocator locator;
/*  177 */   private ConnectionValidator connectionValidator = null;
/*  178 */   private Map configuration = new HashMap();
/*      */ 
/*  180 */   private Map callbackConnectors = new HashMap();
/*  181 */   private Map callbackPollers = new HashMap();
/*      */ 
/*  183 */   private Map listeners = new HashMap();
/*      */   private SocketFactory socketFactory;
/*  187 */   private int disconnectTimeout = -1;
/*      */ 
/*  189 */   private boolean connected = false;
/*      */ 
/*      */   public Client()
/*      */   {
/*      */   }
/*      */ 
/*      */   public Client(InvokerLocator locator)
/*      */     throws Exception
/*      */   {
/*  209 */     this(locator, null, null);
/*      */   }
/*      */ 
/*      */   public Client(InvokerLocator locator, Map configuration)
/*      */     throws Exception
/*      */   {
/*  221 */     this(locator, null, configuration);
/*      */   }
/*      */ 
/*      */   public Client(InvokerLocator locator, String subsystem)
/*      */     throws Exception
/*      */   {
/*  230 */     this(locator, subsystem, null);
/*      */   }
/*      */ 
/*      */   public Client(InvokerLocator locator, String subsystem, Map configuration)
/*      */     throws Exception
/*      */   {
/*  243 */     this(Thread.currentThread().getContextClassLoader(), locator, subsystem, configuration);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Client(ClassLoader cl, InvokerLocator locator, String subsystem, Map configuration)
/*      */     throws Exception
/*      */   {
/*  261 */     this.classloader = cl;
/*  262 */     this.locator = locator;
/*  263 */     this.subsystem = (subsystem == null ? null : subsystem.toUpperCase());
/*  264 */     if (configuration != null)
/*      */     {
/*  266 */       this.configuration = new HashMap(configuration);
/*      */     }
/*  268 */     this.sessionId = new GUID().toString();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Client(ClassLoader cl, ClientInvoker invoker, String subsystem)
/*      */     throws Exception
/*      */   {
/*  280 */     this.classloader = cl;
/*  281 */     this.subsystem = (subsystem == null ? null : subsystem.toUpperCase());
/*  282 */     this.invoker = invoker;
/*  283 */     this.sessionId = new GUID().toString();
/*      */   }
/*      */ 
/*      */   public void readExternal(ObjectInput in)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/*  290 */     int version = in.readInt();
/*      */ 
/*  292 */     switch (version)
/*      */     {
/*      */     case 2:
/*      */     case 22:
/*  297 */       this.locator = ((InvokerLocator)in.readObject());
/*  298 */       this.subsystem = ((String)in.readObject());
/*  299 */       this.configuration = ((Map)in.readObject());
/*  300 */       boolean wasConnected = in.readBoolean();
/*      */ 
/*  302 */       this.classloader = Thread.currentThread().getContextClassLoader();
/*      */       try
/*      */       {
/*  305 */         this.invoker = InvokerRegistry.createClientInvoker(this.locator, this.configuration);
/*  306 */         if (wasConnected)
/*      */         {
/*  308 */           connect();
/*      */         }
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  313 */         log.error(e);
/*  314 */         throw new IOException(e.getMessage());
/*      */       }
/*      */ 
/*      */     default:
/*  320 */       throw new StreamCorruptedException("Unkown version seen: " + version);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void writeExternal(ObjectOutput out) throws IOException
/*      */   {
/*  326 */     out.writeInt(Version.getDefaultVersion());
/*  327 */     out.writeObject(this.invoker != null ? this.invoker.getLocator() : this.locator);
/*  328 */     out.writeObject(this.subsystem);
/*  329 */     out.writeObject(this.configuration);
/*  330 */     out.writeBoolean(isConnected());
/*  331 */     out.flush();
/*      */   }
/*      */ 
/*      */   public void addConnectionListener(ConnectionListener listener)
/*      */   {
/*  343 */     addConnectionListener(listener, 2000);
/*      */   }
/*      */ 
/*      */   public void addConnectionListener(ConnectionListener listener, int pingPeriod)
/*      */   {
/*  353 */     HashMap metadata = new HashMap();
/*  354 */     metadata.put("validatorPingPeriod", Integer.toString(pingPeriod));
/*  355 */     addConnectionListener(listener, metadata);
/*      */   }
/*      */ 
/*      */   public void addConnectionListener(ConnectionListener listener, Map metadata)
/*      */   {
/*  367 */     if (this.invoker == null)
/*      */     {
/*  369 */       throw new RuntimeException("Can not add connection listener to remoting client until client has been connected.");
/*      */     }
/*      */ 
/*  375 */     if ((this.invoker instanceof LocalClientInvoker))
/*      */     {
/*  377 */       return;
/*      */     }
/*      */ 
/*  381 */     if (this.connectionValidator == null)
/*      */     {
/*  383 */       this.connectionValidator = new ConnectionValidator(this, metadata);
/*      */     }
/*  385 */     this.connectionValidator.addConnectionListener(listener);
/*      */   }
/*      */ 
/*      */   public boolean removeConnectionListener(ConnectionListener listener)
/*      */   {
/*  394 */     if (this.connectionValidator == null)
/*      */     {
/*  396 */       return false;
/*      */     }
/*  398 */     return this.connectionValidator.removeConnectionListener(listener);
/*      */   }
/*      */ 
/*      */   public void setSessionId(String sessionId)
/*      */   {
/*  408 */     this.sessionId = sessionId;
/*      */   }
/*      */ 
/*      */   public Map getConfiguration()
/*      */   {
/*  416 */     return this.configuration;
/*      */   }
/*      */ 
/*      */   public String getSessionId()
/*      */   {
/*  426 */     return this.sessionId;
/*      */   }
/*      */ 
/*      */   public boolean isConnected()
/*      */   {
/*  434 */     return this.connected;
/*      */   }
/*      */ 
/*      */   public void connect()
/*      */     throws Exception
/*      */   {
/*  444 */     if (isConnected()) {
/*  445 */       return;
/*      */     }
/*  447 */     if (this.locator == null)
/*      */     {
/*  449 */       throw new IllegalStateException("Cannot connect a client with a null locator");
/*      */     }
/*      */ 
/*  452 */     if (this.invoker == null)
/*      */     {
/*  454 */       if (this.socketFactory != null)
/*      */       {
/*  456 */         this.configuration.put("customSocketFactory", this.socketFactory);
/*  457 */         this.socketFactory = null;
/*      */       }
/*  459 */       this.invoker = InvokerRegistry.createClientInvoker(this.locator, this.configuration);
/*      */     }
/*      */ 
/*  462 */     connect(this.invoker);
/*      */ 
/*  464 */     this.connected = true;
/*      */   }
/*      */ 
/*      */   public void disconnect()
/*      */   {
/*  475 */     if (this.invoker != null)
/*      */     {
/*  478 */       this.invoker.terminateLease(this.sessionId, this.disconnectTimeout);
/*      */ 
/*  480 */       if (this.connectionValidator != null)
/*      */       {
/*  482 */         this.connectionValidator.stop();
/*  483 */         this.connectionValidator = null;
/*      */       }
/*      */ 
/*  489 */       InvokerRegistry.destroyClientInvoker(this.invoker.getLocator(), this.configuration);
/*  490 */       this.invoker = null;
/*      */     }
/*      */ 
/*  493 */     this.connected = false;
/*      */   }
/*      */ 
/*      */   public ClientInvoker getInvoker()
/*      */   {
/*  501 */     return this.invoker;
/*      */   }
/*      */ 
/*      */   public void setInvoker(ClientInvoker invoker)
/*      */   {
/*  509 */     this.invoker = invoker;
/*      */   }
/*      */ 
/*      */   public String getSubsystem()
/*      */   {
/*  517 */     return this.subsystem;
/*      */   }
/*      */ 
/*      */   public void setSubsystem(String subsystem)
/*      */   {
/*  527 */     this.subsystem = subsystem;
/*      */   }
/*      */ 
/*      */   public Object invoke(Object param)
/*      */     throws Throwable
/*      */   {
/*  536 */     return invoke(param, null);
/*      */   }
/*      */ 
/*      */   public Object invoke(Object param, Map metadata)
/*      */     throws Throwable
/*      */   {
/*  548 */     return invoke(param, metadata, null);
/*      */   }
/*      */ 
/*      */   public void invokeOneway(Object param, Map sendPayload, boolean clientSide)
/*      */     throws Throwable
/*      */   {
/*  572 */     Map internalSendPayload = sendPayload == null ? new HashMap() : sendPayload;
/*  573 */     internalSendPayload.put("oneway", "true");
/*      */ 
/*  575 */     if (clientSide)
/*      */     {
/*  577 */       ThreadPool threadPool = getOnewayThreadPool();
/*  578 */       Runnable onewayRun = new Runnable(param, internalSendPayload) {
/*      */         private final Object val$param;
/*      */         private final Map val$internalSendPayload;
/*      */ 
/*      */         public void run() { try { Client.this.invoke(this.val$param, this.val$internalSendPayload);
/*      */           }
/*      */           catch (Throwable e)
/*      */           {
/*  589 */             Client.log.error("Error executing client oneway invocation request: " + this.val$param, e);
/*      */           }
/*      */         }
/*      */       };
/*  593 */       threadPool.run(onewayRun);
/*      */     }
/*      */     else
/*      */     {
/*  597 */       OnewayInvocation invocation = new OnewayInvocation(param);
/*  598 */       invoke(invocation, internalSendPayload);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Set getCallbackConnectors(InvokerCallbackHandler callbackHandler)
/*      */   {
/*  607 */     return (Set)this.callbackConnectors.get(callbackHandler);
/*      */   }
/*      */ 
/*      */   public int getDisconnectTimeout()
/*      */   {
/*  615 */     return this.disconnectTimeout;
/*      */   }
/*      */ 
/*      */   public void setDisconnectTimeout(int disconnectTimeout)
/*      */   {
/*  623 */     this.disconnectTimeout = disconnectTimeout;
/*      */   }
/*      */ 
/*      */   public void setMaxOnewayThreadPoolQueueSize(int maxOnewayThreadPoolQueueSize)
/*      */   {
/*  633 */     this.maxOnewayThreadPoolQueueSize = maxOnewayThreadPoolQueueSize;
/*      */   }
/*      */ 
/*      */   public int getMaxOnewayThreadPoolQueueSize()
/*      */   {
/*  643 */     return this.maxOnewayThreadPoolQueueSize;
/*      */   }
/*      */ 
/*      */   public void setMaxNumberOfThreads(int numOfThreads)
/*      */   {
/*  653 */     this.maxNumberThreads = numOfThreads;
/*      */   }
/*      */ 
/*      */   public int getMaxNumberOfThreads()
/*      */   {
/*  663 */     return this.maxNumberThreads;
/*      */   }
/*      */ 
/*      */   public ThreadPool getOnewayThreadPool()
/*      */   {
/*  673 */     synchronized (this.onewayThreadPoolLock)
/*      */     {
/*  675 */       if (this.onewayThreadPool == null)
/*      */       {
/*  677 */         BasicThreadPool pool = new BasicThreadPool("JBossRemoting Client Oneway");
/*  678 */         log.debug("created new thread pool: " + pool);
/*  679 */         Object param = this.configuration.get("maxNumThreadsOneway");
/*  680 */         if ((param instanceof String))
/*      */         {
/*      */           try
/*      */           {
/*  684 */             this.maxNumberThreads = Integer.parseInt((String)param);
/*      */           }
/*      */           catch (NumberFormatException e)
/*      */           {
/*  688 */             log.error("maxNumberThreads parameter has invalid format: " + param);
/*      */           }
/*      */         }
/*  691 */         else if (param != null)
/*      */         {
/*  693 */           log.error("maxNumberThreads parameter must be a string in integer format: " + param);
/*      */         }
/*      */ 
/*  696 */         param = this.configuration.get("maxOnewayThreadPoolQueueSize");
/*      */ 
/*  698 */         if ((param instanceof String))
/*      */         {
/*      */           try
/*      */           {
/*  702 */             this.maxOnewayThreadPoolQueueSize = Integer.parseInt((String)param);
/*      */           }
/*      */           catch (NumberFormatException e)
/*      */           {
/*  706 */             log.error("maxOnewayThreadPoolQueueSize parameter has invalid format: " + param);
/*      */           }
/*      */         }
/*  709 */         else if (param != null)
/*      */         {
/*  711 */           log.error("maxOnewayThreadPoolQueueSize parameter must be a string in integer format: " + param);
/*      */         }
/*      */ 
/*  714 */         pool.setMaximumPoolSize(this.maxNumberThreads);
/*      */ 
/*  716 */         if (this.maxOnewayThreadPoolQueueSize > 0)
/*      */         {
/*  718 */           pool.setMaximumQueueSize(this.maxOnewayThreadPoolQueueSize);
/*      */         }
/*  720 */         pool.setBlockingMode(BlockingMode.RUN);
/*  721 */         this.onewayThreadPool = pool;
/*      */       }
/*      */     }
/*  724 */     return this.onewayThreadPool;
/*      */   }
/*      */ 
/*      */   public void setOnewayThreadPool(ThreadPool pool)
/*      */   {
/*  732 */     this.onewayThreadPool = pool;
/*      */   }
/*      */ 
/*      */   public void setSocketFactory(SocketFactory socketFactory)
/*      */   {
/*  741 */     if (isConnected())
/*      */     {
/*  743 */       throw new RuntimeException("Cannot set socket factory on Client after the connect() method has been called.");
/*      */     }
/*      */ 
/*  747 */     if (this.invoker != null)
/*      */     {
/*  749 */       this.invoker.setSocketFactory(socketFactory);
/*      */     }
/*      */     else
/*      */     {
/*  753 */       this.socketFactory = socketFactory;
/*      */     }
/*      */   }
/*      */ 
/*      */   public SocketFactory getSocketFactory()
/*      */   {
/*  759 */     if (this.invoker != null)
/*      */     {
/*  761 */       return this.invoker.getSocketFactory();
/*      */     }
/*      */ 
/*  765 */     return this.socketFactory;
/*      */   }
/*      */ 
/*      */   public void invokeOneway(Object param)
/*      */     throws Throwable
/*      */   {
/*  776 */     invokeOneway(param, null);
/*      */   }
/*      */ 
/*      */   public void invokeOneway(Object param, Map sendPayload)
/*      */     throws Throwable
/*      */   {
/*  786 */     invokeOneway(param, sendPayload, false);
/*      */   }
/*      */ 
/*      */   public void addListener(InvokerCallbackHandler callbackhandler, Map metadata)
/*      */     throws Throwable
/*      */   {
/*  799 */     addListener(callbackhandler, metadata, null);
/*      */   }
/*      */ 
/*      */   public void addListener(InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject)
/*      */     throws Throwable
/*      */   {
/*  816 */     addListener(callbackhandler, metadata, callbackHandlerObject, false);
/*      */   }
/*      */ 
/*      */   public void addListener(InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject, boolean serverToClient)
/*      */     throws Throwable
/*      */   {
/*  835 */     InvokerLocator callbackLocator = null;
/*      */ 
/*  837 */     if (isConnected())
/*      */     {
/*  839 */       if (callbackhandler != null)
/*      */       {
/*  841 */         boolean isBidirectional = this.invoker instanceof BidirectionalClientInvoker;
/*      */ 
/*  843 */         if ((isBidirectional) || (serverToClient))
/*      */         {
/*  846 */           String transport = null;
/*  847 */           String host = null;
/*  848 */           int port = -1;
/*      */ 
/*  851 */           if (metadata != null)
/*      */           {
/*  853 */             transport = (String)metadata.get("callbackServerProtocol");
/*  854 */             host = (String)metadata.get("callbackServerHost");
/*  855 */             String sPort = (String)metadata.get("callbackServerPort");
/*  856 */             if (sPort != null)
/*      */             {
/*      */               try
/*      */               {
/*  860 */                 port = Integer.parseInt(sPort);
/*      */               }
/*      */               catch (NumberFormatException e)
/*      */               {
/*  864 */                 log.warn("Could not set the internal callback server port as configuration value (" + sPort + ") is not a number.");
/*      */               }
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/*  871 */             metadata = new HashMap();
/*      */           }
/*  873 */           if (transport == null)
/*      */           {
/*  875 */             transport = this.invoker.getLocator().getProtocol();
/*  876 */             metadata.put("callbackServerProtocol", transport);
/*      */           }
/*  878 */           if (host == null)
/*      */           {
/*  880 */             host = InetAddress.getLocalHost().getHostAddress();
/*  881 */             metadata.put("callbackServerHost", host);
/*      */           }
/*  883 */           if (port == -1)
/*      */           {
/*  885 */             port = PortUtil.findFreePort(host);
/*  886 */             metadata.put("callbackServerPort", String.valueOf(port));
/*      */           }
/*      */ 
/*  889 */           if (isBidirectional)
/*      */           {
/*  891 */             callbackLocator = ((BidirectionalClientInvoker)this.invoker).getCallbackLocator(metadata);
/*      */           }
/*      */           else
/*      */           {
/*  896 */             callbackLocator = new InvokerLocator(transport, host, port, null, metadata);
/*      */           }
/*  898 */           log.debug("starting callback Connector: " + callbackLocator);
/*  899 */           Map callbackConfig = new HashMap(this.configuration);
/*      */ 
/*  901 */           if (this.locator.getParameters() != null)
/*      */           {
/*  903 */             callbackConfig.putAll(this.locator.getParameters());
/*      */           }
/*  905 */           Connector callbackServerConnector = new Connector(callbackLocator, callbackConfig);
/*      */ 
/*  907 */           synchronized (this.callbackConnectors)
/*      */           {
/*  909 */             Set connectors = (Set)this.callbackConnectors.get(callbackhandler);
/*  910 */             if (connectors == null)
/*      */             {
/*  912 */               connectors = new HashSet();
/*      */             }
/*  914 */             connectors.add(callbackServerConnector);
/*  915 */             this.callbackConnectors.put(callbackhandler, connectors);
/*      */           }
/*      */ 
/*  918 */           callbackServerConnector.start();
/*      */ 
/*  920 */           callbackLocator = callbackServerConnector.getServerInvoker().getLocator();
/*  921 */           addCallbackListener(callbackhandler, metadata, callbackLocator, callbackHandlerObject);
/*      */         }
/*      */         else
/*      */         {
/*  925 */           if (this.callbackPollers.get(callbackhandler) != null)
/*      */           {
/*  927 */             log.debug(callbackhandler + " already registered");
/*  928 */             return;
/*      */           }
/*      */ 
/*  932 */           CallbackPoller poller = new CallbackPoller(this, callbackhandler, metadata, callbackHandlerObject);
/*      */ 
/*  934 */           this.callbackPollers.put(callbackhandler, poller);
/*  935 */           addCallbackListener(callbackhandler, metadata, callbackLocator, callbackHandlerObject);
/*  936 */           poller.start();
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  941 */         throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  947 */       throw new Exception("Can not add callback listener because remoting client is not connected to server.");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addListener(InvokerCallbackHandler callbackHandler)
/*      */     throws Throwable
/*      */   {
/*  959 */     addListener(callbackHandler, (InvokerLocator)null);
/*      */   }
/*      */ 
/*      */   public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator)
/*      */     throws Throwable
/*      */   {
/*  974 */     addListener(callbackHandler, clientLocator, null);
/*      */   }
/*      */ 
/*      */   public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator, Object callbackHandlerObject)
/*      */     throws Throwable
/*      */   {
/*  992 */     if (callbackHandler != null)
/*      */     {
/*  994 */       if (isConnected())
/*      */       {
/*  996 */         addCallbackListener(callbackHandler, null, clientLocator, callbackHandlerObject);
/*      */       }
/*      */       else
/*      */       {
/* 1000 */         throw new Exception("Can not add callback listener as remoting client is not connected to server.");
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1006 */       throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeListener(InvokerCallbackHandler callbackHandler)
/*      */     throws Throwable
/*      */   {
/* 1017 */     if (isConnected())
/*      */     {
/* 1019 */       if (callbackHandler != null)
/*      */       {
/* 1023 */         String listenerId = (String)this.listeners.get(callbackHandler);
/* 1024 */         if (listenerId != null)
/*      */         {
/* 1028 */           if (this.disconnectTimeout != 0)
/*      */           {
/* 1030 */             Map metadata = new HashMap();
/* 1031 */             metadata.put("listenerId", listenerId);
/*      */ 
/* 1033 */             if (this.disconnectTimeout > 0) {
/* 1034 */               metadata.put("timeout", Integer.toString(this.disconnectTimeout));
/*      */             }
/*      */             try
/*      */             {
/* 1038 */               invoke(new InternalInvocation("removeListener", null), metadata);
/*      */             }
/*      */             catch (Exception e)
/*      */             {
/* 1042 */               log.warn("unable to remove remote callback handler: " + e.getMessage());
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1047 */           CallbackPoller callbackPoller = (CallbackPoller)this.callbackPollers.remove(callbackHandler);
/* 1048 */           if (callbackPoller != null)
/*      */           {
/* 1050 */             callbackPoller.stop();
/*      */           }
/*      */ 
/* 1053 */           this.listeners.remove(callbackHandler);
/*      */         }
/*      */         else
/*      */         {
/* 1058 */           List holderList = this.invoker.getClientLocators(this.sessionId, callbackHandler);
/* 1059 */           if ((holderList != null) && (holderList.size() > 0))
/*      */           {
/* 1061 */             for (int x = 0; x < holderList.size(); x++)
/*      */             {
/* 1063 */               AbstractInvoker.CallbackLocatorHolder holder = (AbstractInvoker.CallbackLocatorHolder)holderList.get(x);
/*      */ 
/* 1065 */               listenerId = holder.getListenerId();
/* 1066 */               InvokerLocator locator = holder.getLocator();
/* 1067 */               Map metadata = new HashMap();
/* 1068 */               metadata.put("listenerId", listenerId);
/*      */ 
/* 1071 */               if (this.disconnectTimeout != 0)
/*      */               {
/* 1073 */                 if (this.disconnectTimeout > 0) {
/* 1074 */                   metadata.put("timeout", Integer.toString(this.disconnectTimeout));
/*      */                 }
/*      */ 
/*      */                 try
/*      */                 {
/* 1079 */                   InternalInvocation ii = new InternalInvocation("removeListener", null);
/*      */ 
/* 1082 */                   invoke(ii, metadata);
/*      */                 }
/*      */                 catch (Exception e)
/*      */                 {
/* 1086 */                   log.warn("unable to remove remote callback handler: " + e.getMessage());
/*      */                 }
/*      */ 
/*      */               }
/*      */ 
/* 1091 */               Client client = new Client(locator, this.subsystem);
/* 1092 */               client.setSessionId(getSessionId());
/* 1093 */               client.connect();
/* 1094 */               InternalInvocation ii = new InternalInvocation("removeClientListener", new Object[] { callbackHandler });
/*      */ 
/* 1098 */               client.invoke(ii, metadata);
/* 1099 */               client.disconnect();
/*      */             }
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1105 */         Set connectors = null;
/* 1106 */         synchronized (this.callbackConnectors)
/*      */         {
/* 1108 */           connectors = (Set)this.callbackConnectors.remove(callbackHandler);
/*      */         }
/*      */ 
/* 1111 */         if (connectors != null)
/*      */         {
/* 1113 */           Iterator it = connectors.iterator();
/* 1114 */           while (it.hasNext())
/*      */           {
/* 1116 */             Connector callbackConnector = (Connector)it.next();
/* 1117 */             callbackConnector.stop();
/* 1118 */             callbackConnector.destroy();
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 1124 */         throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1129 */       throw new Exception("Can not remove callback listener as remoting client is not connected to server.");
/*      */     }
/*      */   }
/*      */ 
/*      */   public List getCallbacks(InvokerCallbackHandler callbackHandler)
/*      */     throws Throwable
/*      */   {
/* 1141 */     return getCallbacks(callbackHandler, null);
/*      */   }
/*      */ 
/*      */   public List getCallbacks(InvokerCallbackHandler callbackHandler, Map metadata)
/*      */     throws Throwable
/*      */   {
/* 1154 */     if (callbackHandler != null)
/*      */     {
/* 1156 */       String listenerId = (String)this.listeners.get(callbackHandler);
/*      */ 
/* 1158 */       if (listenerId != null)
/*      */       {
/* 1160 */         if (metadata == null) {
/* 1161 */           metadata = new HashMap();
/*      */         }
/* 1163 */         metadata.put("listenerId", listenerId);
/* 1164 */         InternalInvocation invocation = new InternalInvocation("getCallbacks", null);
/*      */         try
/*      */         {
/* 1168 */           List response = (List)invoke(invocation, metadata);
/* 1169 */           localObject1 = response;
/*      */           return localObject1;
/*      */         }
/*      */         catch (MarshalException e)
/*      */         {
/*      */           Object localObject1;
/* 1173 */           if ((e.getCause() != null) && ((e.getCause() instanceof SocketTimeoutException)))
/*      */           {
/* 1175 */             if (log.isTraceEnabled()) log.trace(this + ": getCallbacks() timed out: returning empty list");
/* 1176 */             localObject1 = new ArrayList();
/*      */             return localObject1;
/*      */           }
/* 1178 */           throw e;
/*      */         }
/*      */         finally
/*      */         {
/* 1182 */           metadata.remove("listenerId");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1187 */       String errorMessage = "Could not find listener id for InvokerCallbackHandler (" + callbackHandler + "), please verify handler has been registered as listener.";
/*      */ 
/* 1191 */       String errorMode = (String)metadata.get("throwCallbackException");
/* 1192 */       boolean throwError = Boolean.valueOf(errorMode).booleanValue();
/*      */ 
/* 1194 */       if (throwError)
/*      */       {
/* 1196 */         throw new IOException(errorMessage);
/*      */       }
/*      */ 
/* 1200 */       log.error(errorMessage);
/* 1201 */       return null;
/*      */     }
/*      */ 
/* 1207 */     throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
/*      */   }
/*      */ 
/*      */   public int acknowledgeCallback(InvokerCallbackHandler callbackHandler, Callback callback)
/*      */     throws Throwable
/*      */   {
/* 1214 */     return acknowledgeCallback(callbackHandler, callback, null);
/*      */   }
/*      */ 
/*      */   public int acknowledgeCallback(InvokerCallbackHandler callbackHandler, Callback callback, Object response)
/*      */     throws Throwable
/*      */   {
/* 1220 */     ArrayList callbacks = new ArrayList(1);
/* 1221 */     callbacks.add(callback);
/*      */ 
/* 1223 */     ArrayList responses = null;
/* 1224 */     if (response != null)
/*      */     {
/* 1226 */       responses = new ArrayList(1);
/* 1227 */       responses.add(response);
/*      */     }
/*      */ 
/* 1230 */     return acknowledgeCallbacks(callbackHandler, callbacks, responses);
/*      */   }
/*      */ 
/*      */   public int acknowledgeCallbacks(InvokerCallbackHandler callbackHandler, List callbacks)
/*      */     throws Throwable
/*      */   {
/* 1236 */     return acknowledgeCallbacks(callbackHandler, callbacks, null);
/*      */   }
/*      */ 
/*      */   public int acknowledgeCallbacks(InvokerCallbackHandler callbackHandler, List callbacks, List responses)
/*      */     throws Throwable
/*      */   {
/* 1242 */     if (callbackHandler == null)
/*      */     {
/* 1244 */       throw new Exception("InvokerCallbackHandler parameter must not be null");
/*      */     }
/*      */ 
/* 1247 */     if (callbacks == null)
/*      */     {
/* 1249 */       throw new Exception("Callback List parameter must not be null");
/*      */     }
/*      */ 
/* 1252 */     if ((responses != null) && (responses.size() != callbacks.size()))
/*      */     {
/* 1254 */       throw new Exception("Callback response list must be (1) null or (2) the same size as callback list");
/*      */     }
/*      */ 
/* 1258 */     if (callbacks.size() == 0)
/*      */     {
/* 1260 */       return 0;
/*      */     }
/*      */ 
/* 1263 */     if (isConnected())
/*      */     {
/* 1265 */       ArrayList callbackIds = new ArrayList(callbacks.size());
/* 1266 */       Iterator idsIterator = callbacks.iterator();
/* 1267 */       ArrayList responseList = null;
/* 1268 */       Iterator responseIterator = null;
/*      */ 
/* 1270 */       if (responses != null)
/*      */       {
/* 1272 */         responseList = new ArrayList(responses.size());
/* 1273 */         responseIterator = responses.iterator();
/*      */       }
/*      */ 
/* 1276 */       Callback callback = null;
/* 1277 */       Object response = null;
/* 1278 */       String listenerId = null;
/*      */ 
/* 1280 */       for (int i = 0; i < callbacks.size(); i++)
/*      */       {
/* 1282 */         callback = (Callback)idsIterator.next();
/*      */ 
/* 1284 */         if (responseIterator != null)
/*      */         {
/* 1286 */           response = responseIterator.next();
/*      */         }
/*      */ 
/* 1289 */         Map returnPayload = callback.getReturnPayload();
/*      */ 
/* 1291 */         if (returnPayload != null)
/*      */         {
/* 1293 */           Object callbackId = returnPayload.get("callbackId");
/* 1294 */           if (callbackId != null)
/*      */           {
/* 1296 */             callbackIds.add(callbackId);
/*      */ 
/* 1298 */             if (responseIterator != null)
/*      */             {
/* 1300 */               responseList.add(response);
/*      */             }
/*      */ 
/* 1303 */             String nextListenerId = (String)returnPayload.get("listenerId");
/*      */ 
/* 1305 */             if (nextListenerId == null)
/*      */             {
/* 1307 */               throw new Exception("Cannot acknowledge callbacks: callback " + callbackId + " has null listener id");
/*      */             }
/*      */ 
/* 1311 */             if (i == 0)
/*      */             {
/* 1313 */               listenerId = nextListenerId;
/*      */             }
/* 1317 */             else if (!listenerId.equals(nextListenerId)) {
/* 1318 */               throw new Exception("Cannot acknowledge callbacks: all must be from same server side callback handler");
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/* 1324 */             log.error("Cannot acknowledge callback: callback id is missing from return payload");
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 1330 */           log.error("Cannot acknowledge callback: return payload is null");
/*      */         }
/*      */       }
/*      */ 
/* 1334 */       if (callbackIds.size() == 0)
/*      */       {
/* 1336 */         return 0;
/*      */       }
/*      */ 
/* 1339 */       Map metadata = new HashMap();
/* 1340 */       if (listenerId != null)
/*      */       {
/* 1342 */         metadata.put("listenerId", listenerId);
/*      */       }
/*      */       else
/*      */       {
/* 1346 */         throw new Exception("Could not find listener id for InvokerCallbackHandler (" + callbackHandler + "), please verify handler " + "has been registered as listener.");
/*      */       }
/*      */ 
/* 1351 */       Object[] params = { callbackIds, responseList };
/* 1352 */       InternalInvocation invocation = new InternalInvocation("acknowledgeCallback", params);
/*      */ 
/* 1354 */       invoke(invocation, metadata);
/* 1355 */       return callbackIds.size();
/*      */     }
/*      */ 
/* 1359 */     throw new Exception("Can not acknowledge Callback due to not being connected to server.");
/*      */   }
/*      */ 
/*      */   public void setMarshaller(Marshaller marshaller)
/*      */   {
/* 1369 */     if (isConnected())
/*      */     {
/* 1371 */       if (marshaller != null)
/*      */       {
/* 1373 */         this.invoker.setMarshaller(marshaller);
/*      */       }
/*      */       else
/*      */       {
/* 1377 */         throw new NullPointerException("Can not set Marshaller with a null value.");
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1382 */       throw new RuntimeException("Can not set remoting client Marshaller when not connected.");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setUnMarshaller(UnMarshaller unmarshaller)
/*      */   {
/* 1392 */     if (isConnected())
/*      */     {
/* 1394 */       if (unmarshaller != null)
/*      */       {
/* 1397 */         this.invoker.setUnMarshaller(unmarshaller);
/*      */       }
/*      */       else
/*      */       {
/* 1401 */         throw new NullPointerException("Can not set UnMarshaller to null value.");
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1406 */       throw new RuntimeException("Can not set remoting client UnMarhshaller when not connected.");
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object invoke(InputStream inputStream, Object param)
/*      */     throws Throwable
/*      */   {
/* 1422 */     StreamServer streamServer = new StreamServer(inputStream);
/* 1423 */     String locator = streamServer.getInvokerLocator();
/*      */ 
/* 1426 */     InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
/*      */ 
/* 1428 */     return invoke(new InternalInvocation("addStreamCallback", new Object[] { locator, invocationRequest }), null);
/*      */   }
/*      */ 
/*      */   public Object invoke(InputStream inputStream, Object param, Connector streamConnector)
/*      */     throws Throwable
/*      */   {
/* 1447 */     StreamServer streamServer = new StreamServer(inputStream, streamConnector);
/* 1448 */     String locator = streamServer.getInvokerLocator();
/*      */ 
/* 1451 */     InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
/*      */ 
/* 1454 */     return invoke(new InternalInvocation("addStreamCallback", new Object[] { locator, invocationRequest }), null);
/*      */   }
/*      */ 
/*      */   public Object invoke(InputStream inputStream, Object param, InvokerLocator streamServerLocator)
/*      */     throws Throwable
/*      */   {
/* 1468 */     StreamServer streamServer = new StreamServer(inputStream, streamServerLocator);
/* 1469 */     String locator = streamServer.getInvokerLocator();
/*      */ 
/* 1472 */     InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
/*      */ 
/* 1474 */     return invoke(new InternalInvocation("addStreamCallback", new Object[] { locator, invocationRequest }), null);
/*      */   }
/*      */ 
/*      */   public long getPingPeriod()
/*      */   {
/* 1485 */     if (this.connectionValidator == null)
/*      */     {
/* 1487 */       return -1L;
/*      */     }
/*      */ 
/* 1490 */     return this.connectionValidator.getPingPeriod();
/*      */   }
/*      */ 
/*      */   public long getLeasePeriod()
/*      */   {
/* 1499 */     if (this.invoker == null)
/*      */     {
/* 1501 */       return -1L;
/*      */     }
/*      */ 
/* 1504 */     return this.invoker.getLeasePeriod(this.sessionId);
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1509 */     return "Client[" + System.identityHashCode(this) + "]";
/*      */   }
/*      */ 
/*      */   private void connect(ClientInvoker invoker)
/*      */   {
/* 1520 */     if (invoker != null)
/*      */     {
/* 1522 */       invoker.connect();
/*      */       try
/*      */       {
/* 1525 */         setupClientLease(invoker);
/*      */       }
/*      */       catch (Throwable throwable)
/*      */       {
/* 1529 */         RuntimeException e = new RuntimeException("Error setting up client lease upon performing connect.");
/*      */ 
/* 1531 */         e.initCause(throwable);
/* 1532 */         throw e;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1537 */       throw new RuntimeException("Client invoker is null (may have used void constructor for Client, which should only be used for Externalization.");
/*      */     }
/*      */   }
/*      */ 
/*      */   private void setupClientLease(ClientInvoker invoker)
/*      */     throws Throwable
/*      */   {
/* 1544 */     long leasePeriod = -1L;
/* 1545 */     boolean enableLease = false;
/*      */ 
/* 1548 */     if (invoker != null)
/*      */     {
/* 1550 */       if ((invoker instanceof LocalClientInvoker))
/*      */       {
/* 1553 */         return;
/*      */       }
/*      */ 
/* 1556 */       InvokerLocator locator = invoker.getLocator();
/* 1557 */       Map locatorParams = locator.getParameters();
/* 1558 */       if (locatorParams != null)
/*      */       {
/* 1560 */         String leaseValue = (String)locatorParams.get("leasing");
/* 1561 */         if ((leaseValue != null) && (leaseValue.length() > 0))
/*      */         {
/* 1563 */           enableLease = Boolean.valueOf(leaseValue).booleanValue();
/*      */         }
/*      */ 
/* 1566 */         String leasePeriodValue = (String)locatorParams.get("lease_period");
/* 1567 */         if ((leasePeriodValue != null) && (leasePeriodValue.length() > 0))
/*      */         {
/*      */           try
/*      */           {
/* 1571 */             leasePeriod = Long.parseLong(leasePeriodValue);
/*      */           }
/*      */           catch (NumberFormatException e)
/*      */           {
/* 1575 */             log.warn("Could not convert client lease period value (" + leasePeriodValue + ") to a number.");
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1583 */       throw new RuntimeException("Can not set up client lease as client invoker is null.");
/*      */     }
/*      */ 
/* 1586 */     if (this.configuration != null)
/*      */     {
/* 1588 */       Object val = this.configuration.get("enableLease");
/*      */ 
/* 1590 */       if (val != null)
/*      */       {
/* 1592 */         if ((val instanceof Boolean))
/*      */         {
/* 1594 */           enableLease = ((Boolean)val).booleanValue();
/*      */         }
/* 1596 */         else if ((val instanceof String))
/*      */         {
/* 1598 */           enableLease = Boolean.valueOf((String)val).booleanValue();
/*      */         }
/*      */         else
/*      */         {
/* 1602 */           log.warn("Can not evaluate enableLease value (" + val + ") as a boolean type.");
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1607 */       String leasePeriodValue = (String)this.configuration.get("lease_period");
/*      */ 
/* 1609 */       if ((leasePeriodValue != null) && (leasePeriodValue.length() > 0))
/*      */       {
/*      */         try
/*      */         {
/* 1613 */           leasePeriod = Long.parseLong(leasePeriodValue);
/*      */         }
/*      */         catch (NumberFormatException e)
/*      */         {
/* 1617 */           log.warn("Could not convert client lease period value (" + leasePeriodValue + ") to a number.");
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1623 */     if (enableLease)
/*      */     {
/* 1625 */       invoker.establishLease(this.sessionId, this.configuration, leasePeriod);
/*      */     }
/*      */   }
/*      */ 
/*      */   private Object invoke(Object param, Map metadata, InvokerLocator callbackServerLocator)
/*      */     throws Throwable
/*      */   {
/* 1632 */     if (isConnected())
/*      */     {
/* 1634 */       return this.invoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, param, metadata, null, callbackServerLocator));
/*      */     }
/*      */ 
/* 1639 */     throw new Exception("Can not make remoting client invocation due to not being connected to server.");
/*      */   }
/*      */ 
/*      */   private void addCallbackListener(InvokerCallbackHandler callbackhandler, Map metadata, InvokerLocator callbackLocator, Object callbackHandlerObject)
/*      */     throws Throwable
/*      */   {
/* 1650 */     if (callbackLocator == null)
/*      */     {
/* 1652 */       String listenerId = generateListenerId(callbackhandler);
/*      */ 
/* 1656 */       if (listenerId != null)
/*      */       {
/* 1658 */         Map internalMetadata = new HashMap();
/* 1659 */         internalMetadata.put("listenerId", listenerId);
/* 1660 */         if (metadata != null)
/*      */         {
/* 1662 */           internalMetadata.putAll(metadata);
/*      */         }
/*      */ 
/* 1665 */         invoke(new InternalInvocation("addListener", null), internalMetadata, callbackLocator);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1673 */       String listenerId = this.invoker.addClientLocator(this.sessionId, callbackhandler, callbackLocator);
/*      */ 
/* 1675 */       if (listenerId != null)
/*      */       {
/* 1678 */         Map internalMetadata = new HashMap();
/* 1679 */         internalMetadata.put("listenerId", listenerId);
/* 1680 */         if (metadata != null)
/*      */         {
/* 1682 */           internalMetadata.putAll(metadata);
/*      */         }
/*      */ 
/* 1685 */         Client client = new Client(callbackLocator, this.subsystem);
/* 1686 */         client.setSessionId(getSessionId());
/* 1687 */         client.connect();
/*      */         try
/*      */         {
/* 1691 */           InternalInvocation i = new InternalInvocation("addClientListener", new Object[] { callbackhandler, callbackHandlerObject });
/*      */ 
/* 1695 */           client.invoke(i, internalMetadata);
/*      */         }
/*      */         finally
/*      */         {
/* 1699 */           client.disconnect();
/*      */         }
/*      */ 
/* 1703 */         invoke(new InternalInvocation("addListener", null), internalMetadata, callbackLocator);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String generateListenerId(InvokerCallbackHandler callbackhandler)
/*      */   {
/* 1711 */     String listenerId = null;
/* 1712 */     Object obj = this.listeners.get(callbackhandler);
/* 1713 */     if (obj == null)
/*      */     {
/* 1715 */       listenerId = new GUID().toString();
/* 1716 */       this.listeners.put(callbackhandler, listenerId);
/*      */     }
/* 1718 */     return listenerId;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.Client
 * JD-Core Version:    0.6.0
 */