/*    */ package org.jboss.reflect.spi;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ import org.jboss.reflect.plugins.SimpleProgressionConvertor;
/*    */ import org.jboss.reflect.plugins.introspection.ReflectionUtils;
/*    */ 
/*    */ public class ProgressionConvertorFactory
/*    */ {
/* 41 */   private static ProgressionConvertorFactory instance = new ProgressionConvertorFactory();
/*    */   private String convertorClassName;
/*    */   private ProgressionConvertor convertor;
/*    */ 
/*    */   public ProgressionConvertorFactory()
/*    */   {
/* 43 */     this.convertorClassName = SimpleProgressionConvertor.class.getName();
/*    */   }
/*    */ 
/*    */   public static ProgressionConvertorFactory getInstance()
/*    */   {
/* 48 */     return instance;
/*    */   }
/*    */ 
/*    */   public ProgressionConvertor getConvertor()
/*    */     throws Throwable
/*    */   {
/* 54 */     if (this.convertor == null)
/*    */     {
/* 56 */       ConvertorLookup lookup = new ConvertorLookup(null);
/* 57 */       this.convertor = ((ProgressionConvertor)AccessController.doPrivileged(lookup));
/*    */     }
/* 59 */     return this.convertor;
/*    */   }
/*    */ 
/*    */   public void setConvertorClassName(String convertorClassName)
/*    */   {
/* 64 */     this.convertorClassName = convertorClassName;
/*    */   }
/*    */ 
/*    */   private class ConvertorLookup implements PrivilegedExceptionAction<ProgressionConvertor> {
/*    */     private ConvertorLookup() {
/*    */     }
/*    */ 
/*    */     public ProgressionConvertor run() throws Exception {
/*    */       try {
/* 73 */         String convertorClass = System.getProperty("org.jboss.reflect.plugins.progressionConvertor", ProgressionConvertorFactory.this.convertorClassName);
/* 74 */         Object result = ReflectionUtils.newInstance(convertorClass);
/* 75 */         return (ProgressionConvertor)ProgressionConvertor.class.cast(result);
/*    */       }
/*    */       catch (Throwable t) {
/*    */       }
/* 79 */       throw new Exception("Exception while creating convertor instance.", t);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.spi.ProgressionConvertorFactory
 * JD-Core Version:    0.6.0
 */