/*     */ package org.jboss.reflect.spi;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class DelegateClassInfo extends AbstractTypeInfo
/*     */   implements ClassInfo, InterfaceInfo
/*     */ {
/*     */   private static final long serialVersionUID = 6830276668550581673L;
/*     */   protected ClassInfo delegate;
/*     */ 
/*     */   public DelegateClassInfo(ClassInfo delegate)
/*     */   {
/*  50 */     this(delegate, false);
/*     */   }
/*     */ 
/*     */   public DelegateClassInfo(ClassInfo delegate, boolean allowNull)
/*     */   {
/*  61 */     if ((delegate == null) && (!allowNull))
/*  62 */       throw new IllegalArgumentException("Null delegate");
/*  63 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public boolean isInitialized()
/*     */   {
/*  73 */     return this.delegate != null;
/*     */   }
/*     */ 
/*     */   public void setDelegate(TypeInfo delegate)
/*     */   {
/*  84 */     if (delegate == null)
/*  85 */       throw new IllegalArgumentException("Null delegate");
/*  86 */     if (!(delegate instanceof InterfaceInfo))
/*  87 */       throw new IllegalArgumentException("Delegate is not a ClassInfo " + delegate.getClass().getName());
/*  88 */     this.delegate = ((InterfaceInfo)delegate);
/*     */   }
/*     */ 
/*     */   public void setDelegate(ClassInfo delegate)
/*     */   {
/*  99 */     if (delegate == null)
/* 100 */       throw new IllegalArgumentException("Null delegate");
/* 101 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public TypeInfoFactory getTypeInfoFactory()
/*     */   {
/* 106 */     return this.delegate.getTypeInfoFactory();
/*     */   }
/*     */ 
/*     */   public ConstructorInfo getDeclaredConstructor(TypeInfo[] parameters)
/*     */   {
/* 111 */     return this.delegate.getDeclaredConstructor(parameters);
/*     */   }
/*     */ 
/*     */   public ConstructorInfo[] getDeclaredConstructors()
/*     */   {
/* 116 */     return this.delegate.getDeclaredConstructors();
/*     */   }
/*     */ 
/*     */   public FieldInfo getDeclaredField(String name)
/*     */   {
/* 121 */     return this.delegate.getDeclaredField(name);
/*     */   }
/*     */ 
/*     */   public FieldInfo[] getDeclaredFields()
/*     */   {
/* 126 */     return this.delegate.getDeclaredFields();
/*     */   }
/*     */ 
/*     */   public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters)
/*     */   {
/* 131 */     return this.delegate.getDeclaredMethod(name, parameters);
/*     */   }
/*     */ 
/*     */   public MethodInfo[] getDeclaredMethods()
/*     */   {
/* 136 */     return this.delegate.getDeclaredMethods();
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getGenericInterfaces()
/*     */   {
/* 141 */     return this.delegate.getGenericInterfaces();
/*     */   }
/*     */ 
/*     */   public ClassInfo getGenericSuperclass()
/*     */   {
/* 146 */     return this.delegate.getGenericSuperclass();
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getInterfaces()
/*     */   {
/* 151 */     return this.delegate.getInterfaces();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 156 */     return this.delegate.getName();
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */   {
/* 161 */     return this.delegate.getSimpleName();
/*     */   }
/*     */ 
/*     */   public ClassInfo getSuperclass()
/*     */   {
/* 166 */     return this.delegate.getSuperclass();
/*     */   }
/*     */ 
/*     */   public boolean isInterface()
/*     */   {
/* 171 */     return this.delegate.isInterface();
/*     */   }
/*     */ 
/*     */   public AnnotationValue getAnnotation(String name)
/*     */   {
/* 176 */     return this.delegate.getAnnotation(name);
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 181 */     return this.delegate.getAnnotations();
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(String name)
/*     */   {
/* 186 */     return this.delegate.isAnnotationPresent(name);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getUnderlyingAnnotation(Class<T> annotationType)
/*     */   {
/* 191 */     return this.delegate.getUnderlyingAnnotation(annotationType);
/*     */   }
/*     */ 
/*     */   public Annotation[] getUnderlyingAnnotations()
/*     */   {
/* 196 */     return this.delegate.getUnderlyingAnnotations();
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(Class<? extends Annotation> annotationType)
/*     */   {
/* 201 */     return this.delegate.isAnnotationPresent(annotationType);
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/* 206 */     return this.delegate.getModifiers();
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/* 211 */     return this.delegate.isPublic();
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/* 216 */     return this.delegate.isStatic();
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 221 */     return this.delegate.isVolatile();
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value) throws Throwable
/*     */   {
/* 226 */     return this.delegate.convertValue(value);
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value, boolean replaceProperties) throws Throwable
/*     */   {
/* 231 */     return this.delegate.convertValue(value, replaceProperties);
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable
/*     */   {
/* 236 */     return this.delegate.convertValue(value, replaceProperties, trim);
/*     */   }
/*     */ 
/*     */   public TypeInfo getArrayType()
/*     */   {
/* 241 */     return this.delegate.getArrayType();
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Class getType() {
/* 247 */     return this.delegate.getType();
/*     */   }
/*     */ 
/*     */   public boolean isAnnotation()
/*     */   {
/* 252 */     return this.delegate.isAnnotation();
/*     */   }
/*     */ 
/*     */   public boolean isCollection()
/*     */   {
/* 257 */     return this.delegate.isCollection();
/*     */   }
/*     */ 
/*     */   public boolean isMap()
/*     */   {
/* 262 */     return this.delegate.isMap();
/*     */   }
/*     */ 
/*     */   public boolean isArray()
/*     */   {
/* 268 */     return this.delegate.isArray();
/*     */   }
/*     */ 
/*     */   public boolean isEnum()
/*     */   {
/* 274 */     return this.delegate.isEnum();
/*     */   }
/*     */ 
/*     */   public boolean isPrimitive()
/*     */   {
/* 280 */     return this.delegate.isPrimitive();
/*     */   }
/*     */ 
/*     */   public Object newArrayInstance(int size) throws Throwable
/*     */   {
/* 285 */     return this.delegate.newArrayInstance(size);
/*     */   }
/*     */ 
/*     */   public boolean isAssignableFrom(TypeInfo info)
/*     */   {
/* 290 */     return this.delegate.isAssignableFrom(info);
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getActualTypeArguments()
/*     */   {
/* 295 */     return this.delegate.getActualTypeArguments();
/*     */   }
/*     */ 
/*     */   public TypeInfo getOwnerType()
/*     */   {
/* 300 */     return this.delegate.getOwnerType();
/*     */   }
/*     */ 
/*     */   public ClassInfo getRawType()
/*     */   {
/* 305 */     return this.delegate.getRawType();
/*     */   }
/*     */ 
/*     */   public TypeInfo getComponentType()
/*     */   {
/* 310 */     return this.delegate.getComponentType();
/*     */   }
/*     */ 
/*     */   public TypeInfo getKeyType()
/*     */   {
/* 315 */     return this.delegate.getKeyType();
/*     */   }
/*     */ 
/*     */   public TypeInfo getValueType()
/*     */   {
/* 320 */     return this.delegate.getValueType();
/*     */   }
/*     */ 
/*     */   public PackageInfo getPackage()
/*     */   {
/* 325 */     return this.delegate.getPackage();
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 331 */     return this.delegate.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 337 */     if (obj == this) {
/* 338 */       return true;
/*     */     }
/* 340 */     if ((obj == null) || (!(obj instanceof InterfaceInfo))) {
/* 341 */       return false;
/*     */     }
/* 343 */     ClassInfo other = (InterfaceInfo)obj;
/* 344 */     ClassInfo otherDelegate = other;
/* 345 */     if ((other instanceof DelegateClassInfo)) {
/* 346 */       otherDelegate = ((DelegateClassInfo)other).delegate;
/*     */     }
/* 348 */     if (!this.delegate.equals(otherDelegate)) {
/* 349 */       return false;
/*     */     }
/*     */ 
/* 352 */     if (!(other instanceof DelegateClassInfo)) {
/* 353 */       return true;
/*     */     }
/* 355 */     TypeInfo[] typeArguments = getActualTypeArguments();
/* 356 */     TypeInfo[] otherTypeArguments = other.getActualTypeArguments();
/* 357 */     if (typeArguments.length != otherTypeArguments.length) {
/* 358 */       return false;
/*     */     }
/* 360 */     for (int i = 0; i < typeArguments.length; i++)
/*     */     {
/* 362 */       if (!typeArguments[i].equals(otherTypeArguments[i]))
/* 363 */         return false;
/*     */     }
/* 365 */     return true;
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 371 */     this.delegate.toShortString(buffer);
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 377 */     this.delegate.toShortString(buffer);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.spi.DelegateClassInfo
 * JD-Core Version:    0.6.0
 */