/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Collection;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.reflect.plugins.PackageInfoImpl;
/*     */ import org.jboss.reflect.plugins.TypeInfoAttachments;
/*     */ import org.jboss.reflect.plugins.ValueConvertor;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.FieldInfo;
/*     */ import org.jboss.reflect.spi.InterfaceInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.PackageInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public class JavassistTypeInfo extends JavassistInheritableAnnotationHolder
/*     */   implements ClassInfo, InterfaceInfo
/*     */ {
/*     */   private static final long serialVersionUID = -5072033691434335775L;
/*     */   private JavassistTypeInfoFactoryImpl factory;
/*     */   private String name;
/*     */   private Class<? extends Object> clazz;
/*  71 */   private Map<SignatureKey, JavassistConstructorInfo> constructors = new ConcurrentHashMap();
/*     */   private ConstructorInfo[] constructorArray;
/*  77 */   private Map<String, JavassistFieldInfo> fields = new ConcurrentHashMap();
/*     */   private FieldInfo[] fieldArray;
/*  83 */   private Map<SignatureKey, JavassistMethodInfo> methods = new ConcurrentHashMap();
/*     */   private MethodInfo[] methodArray;
/*     */   private PackageInfo packageInfo;
/*     */   private transient TypeInfoAttachments attachments;
/*     */ 
/*     */   JavassistTypeInfo(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class<? extends Object> clazz)
/*     */   {
/* 103 */     this(factory, ctClass.getName(), ctClass, clazz);
/*     */   }
/*     */ 
/*     */   JavassistTypeInfo(JavassistTypeInfoFactoryImpl factory, String name, CtClass ctClass, Class<? extends Object> clazz)
/*     */   {
/* 116 */     super(ctClass, factory);
/* 117 */     this.factory = factory;
/* 118 */     this.clazz = clazz;
/* 119 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 124 */     return this.name;
/*     */   }
/*     */ 
/*     */   public boolean isInterface()
/*     */   {
/* 129 */     return this.ctClass.isInterface();
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */   {
/* 134 */     return getType().getSimpleName();
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/* 139 */     return this.ctClass.getModifiers();
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/* 144 */     return Modifier.isPublic(getModifiers());
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/* 149 */     return Modifier.isStatic(getModifiers());
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 154 */     return Modifier.isVolatile(getModifiers());
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Class<? extends Object> getType() {
/* 160 */     return this.clazz;
/*     */   }
/*     */ 
/*     */   public ClassInfo getSuperclass()
/*     */   {
/* 165 */     if (isInterface())
/* 166 */       return null;
/*     */     try
/*     */     {
/* 169 */       CtClass superclass = this.ctClass.getSuperclass();
/* 170 */       if (superclass == null)
/* 171 */         return null;
/* 172 */       return (InterfaceInfo)this.factory.getTypeInfo(superclass);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 176 */     throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(this.clazz.getSuperclass().getName(), e);
/*     */   }
/*     */ 
/*     */   public ClassInfo getGenericSuperclass()
/*     */   {
/* 183 */     throw new NotImplementedException("getGenericSuperclass");
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getInterfaces()
/*     */   {
/*     */     try
/*     */     {
/* 190 */       CtClass[] interfaces = this.ctClass.getInterfaces();
/* 191 */       if ((interfaces == null) || (interfaces.length == 0))
/* 192 */         return null;
/* 193 */       InterfaceInfo[] result = new InterfaceInfo[interfaces.length];
/* 194 */       for (int i = 0; i < result.length; i++)
/* 195 */         result[i] = ((InterfaceInfo)this.factory.getTypeInfo(interfaces[i]));
/* 196 */       return result;
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 200 */     throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for interfaces of " + getName(), e);
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getGenericInterfaces()
/*     */   {
/* 207 */     throw new NotImplementedException("getGenericInterfaces");
/*     */   }
/*     */ 
/*     */   public ConstructorInfo[] getDeclaredConstructors()
/*     */   {
/* 212 */     if (this.constructorArray == null)
/*     */     {
/* 214 */       CtConstructor[] declaredConstructors = this.ctClass.getDeclaredConstructors();
/* 215 */       if ((declaredConstructors == null) || (declaredConstructors.length == 0)) {
/* 216 */         this.constructorArray = new ConstructorInfo[0];
/*     */       }
/*     */       else {
/* 219 */         synchronized (this.constructors)
/*     */         {
/* 221 */           for (int i = 0; i < declaredConstructors.length; i++)
/* 222 */             generateConstructorInfo(declaredConstructors[i]);
/* 223 */           Collection constructorCollection = this.constructors.values();
/* 224 */           this.constructorArray = ((ConstructorInfo[])constructorCollection.toArray(new ConstructorInfo[constructorCollection.size()]));
/*     */         }
/*     */       }
/*     */     }
/* 228 */     return this.constructorArray;
/*     */   }
/*     */ 
/*     */   public ConstructorInfo getDeclaredConstructor(TypeInfo[] parameters)
/*     */   {
/* 233 */     SignatureKey key = new SignatureKey(null, parameters);
/* 234 */     synchronized (this.constructors)
/*     */     {
/* 236 */       ConstructorInfo constructor = (ConstructorInfo)this.constructors.get(key);
/* 237 */       if (constructor != null)
/* 238 */         return constructor;
/*     */     }
/* 240 */     if (this.constructorArray != null)
/* 241 */       return null;
/* 242 */     return generateConstructorInfo(key);
/*     */   }
/*     */ 
/*     */   public FieldInfo getDeclaredField(String name)
/*     */   {
/* 247 */     synchronized (this.fields)
/*     */     {
/* 249 */       FieldInfo field = (FieldInfo)this.fields.get(name);
/* 250 */       if (field != null)
/* 251 */         return field;
/*     */     }
/* 253 */     if (this.fieldArray != null)
/* 254 */       return null;
/*     */     try
/*     */     {
/* 257 */       CtField field = this.ctClass.getDeclaredField(name);
/* 258 */       if (field == null)
/* 259 */         return null;
/* 260 */       return generateFieldInfo(field);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 264 */     return null;
/*     */   }
/*     */ 
/*     */   public FieldInfo[] getDeclaredFields()
/*     */   {
/* 270 */     if (this.fieldArray == null)
/*     */     {
/* 272 */       CtField[] declaredFields = this.ctClass.getDeclaredFields();
/* 273 */       if ((declaredFields == null) || (declaredFields.length == 0)) {
/* 274 */         this.fieldArray = new FieldInfo[0];
/*     */       }
/*     */       else {
/* 277 */         synchronized (this.fields)
/*     */         {
/* 279 */           for (int i = 0; i < declaredFields.length; i++)
/* 280 */             generateFieldInfo(declaredFields[i]);
/* 281 */           Collection fieldCollection = this.fields.values();
/* 282 */           this.fieldArray = ((FieldInfo[])fieldCollection.toArray(new FieldInfo[fieldCollection.size()]));
/*     */         }
/*     */       }
/*     */     }
/* 286 */     return this.fieldArray;
/*     */   }
/*     */ 
/*     */   public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters)
/*     */   {
/* 291 */     SignatureKey key = new SignatureKey(name, parameters);
/* 292 */     synchronized (this.methods)
/*     */     {
/* 294 */       MethodInfo method = (MethodInfo)this.methods.get(key);
/* 295 */       if (method != null)
/* 296 */         return method;
/*     */     }
/* 298 */     if (this.methodArray != null)
/* 299 */       return null;
/* 300 */     return generateMethodInfo(key);
/*     */   }
/*     */ 
/*     */   public MethodInfo[] getDeclaredMethods()
/*     */   {
/* 305 */     if (this.methodArray == null)
/*     */     {
/* 307 */       CtMethod[] declaredMethods = this.ctClass.getDeclaredMethods();
/* 308 */       if ((declaredMethods == null) || (declaredMethods.length == 0)) {
/* 309 */         this.methodArray = new MethodInfo[0];
/*     */       }
/*     */       else {
/* 312 */         synchronized (this.methods)
/*     */         {
/* 314 */           for (int i = 0; i < declaredMethods.length; i++)
/* 315 */             generateMethodInfo(declaredMethods[i]);
/* 316 */           Collection methodCollection = this.methods.values();
/* 317 */           this.methodArray = ((MethodInfo[])methodCollection.toArray(new MethodInfo[methodCollection.size()]));
/*     */         }
/*     */       }
/*     */     }
/* 321 */     return this.methodArray;
/*     */   }
/*     */ 
/*     */   public boolean isArray()
/*     */   {
/* 326 */     return getType().isArray();
/*     */   }
/*     */ 
/*     */   public boolean isCollection()
/*     */   {
/* 331 */     return Collection.class.isAssignableFrom(getType());
/*     */   }
/*     */ 
/*     */   public boolean isMap()
/*     */   {
/* 336 */     return Map.class.isAssignableFrom(getType());
/*     */   }
/*     */ 
/*     */   public boolean isAnnotation()
/*     */   {
/* 341 */     return getType().isAnnotation();
/*     */   }
/*     */ 
/*     */   public boolean isEnum()
/*     */   {
/* 346 */     return getType().isEnum();
/*     */   }
/*     */ 
/*     */   public boolean isPrimitive()
/*     */   {
/* 351 */     return getType().isPrimitive();
/*     */   }
/*     */ 
/*     */   public static Class getArrayClass(Class clazz)
/*     */   {
/* 362 */     return Array.newInstance(clazz, 0).getClass();
/*     */   }
/*     */ 
/*     */   public TypeInfo getArrayType()
/*     */   {
/* 367 */     Class arrayClass = getArrayClass(getType());
/* 368 */     return this.factory.getTypeInfo(arrayClass);
/*     */   }
/*     */ 
/*     */   public Object newArrayInstance(int size) throws Throwable
/*     */   {
/* 373 */     if (!isArray())
/* 374 */       throw new ClassCastException(this + " is not an array.");
/* 375 */     return Array.newInstance(getComponentType().getType(), size);
/*     */   }
/*     */ 
/*     */   public boolean isAssignableFrom(TypeInfo info)
/*     */   {
/* 380 */     if (info == null)
/*     */     {
/* 382 */       throw new NullPointerException("Parameter info cannot be null!");
/*     */     }
/* 384 */     return getType().isAssignableFrom(info.getType());
/*     */   }
/*     */ 
/*     */   public TypeInfoFactory getTypeInfoFactory()
/*     */   {
/* 389 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value) throws Throwable
/*     */   {
/* 394 */     return ValueConvertor.convertValue(getType(), value);
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value, boolean replaceProperties) throws Throwable
/*     */   {
/* 399 */     return ValueConvertor.convertValue(getType(), value, replaceProperties);
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable
/*     */   {
/* 404 */     return ValueConvertor.convertValue(getType(), value, replaceProperties, trim);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 409 */     return getName().hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 414 */     if (obj == this)
/* 415 */       return true;
/* 416 */     if ((obj == null) || (!(obj instanceof TypeInfo))) {
/* 417 */       return false;
/*     */     }
/* 419 */     TypeInfo other = (TypeInfo)obj;
/* 420 */     return getName().equals(other.getName());
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 425 */     buffer.append(getName());
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 430 */     buffer.append("name=").append(getName());
/* 431 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   protected JavassistTypeInfoFactoryImpl getFactory()
/*     */   {
/* 441 */     return this.factory;
/*     */   }
/*     */ 
/*     */   protected ConstructorInfo generateConstructorInfo(CtConstructor constructor)
/*     */   {
/*     */     try
/*     */     {
/* 454 */       CtClass[] parameterTypes = constructor.getParameterTypes();
/* 455 */       String[] params = new String[parameterTypes.length];
/* 456 */       for (int i = 0; i < params.length; i++)
/* 457 */         params[i] = parameterTypes[i].getName();
/* 458 */       SignatureKey key = new SignatureKey(null, params);
/* 459 */       JavassistConstructorInfo info = new JavassistConstructorInfo(this.factory, this, constructor);
/* 460 */       synchronized (this.constructors)
/*     */       {
/* 462 */         this.constructors.put(key, info);
/*     */       }
/* 464 */       return info;
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 468 */     throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for constructor of " + getName(), e);
/*     */   }
/*     */ 
/*     */   protected ConstructorInfo generateConstructorInfo(SignatureKey key)
/*     */   {
/* 480 */     CtClass[] params = getParameterTypes(key);
/*     */     try
/*     */     {
/* 483 */       CtConstructor ctConstructor = this.ctClass.getDeclaredConstructor(params);
/* 484 */       return generateConstructorInfo(ctConstructor);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 488 */     throw JavassistTypeInfoFactoryImpl.raiseMethodNotFound("for constructor " + getName(), e);
/*     */   }
/*     */ 
/*     */   protected FieldInfo generateFieldInfo(CtField field)
/*     */   {
/* 500 */     JavassistFieldInfo info = new JavassistFieldInfo(this.factory, this, field);
/* 501 */     synchronized (this.fields)
/*     */     {
/* 503 */       this.fields.put(field.getName(), info);
/*     */     }
/* 505 */     return info;
/*     */   }
/*     */ 
/*     */   protected MethodInfo generateMethodInfo(SignatureKey key)
/*     */   {
/* 516 */     CtClass[] params = getParameterTypes(key);
/*     */     try
/*     */     {
/* 519 */       CtMethod ctMethod = this.ctClass.getDeclaredMethod(key.name, params);
/* 520 */       return generateMethodInfo(key, ctMethod);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 524 */     throw JavassistTypeInfoFactoryImpl.raiseMethodNotFound("for method " + key.name, e);
/*     */   }
/*     */ 
/*     */   protected MethodInfo generateMethodInfo(CtMethod method)
/*     */   {
/*     */     try
/*     */     {
/* 538 */       CtClass[] parameterTypes = method.getParameterTypes();
/* 539 */       String[] params = new String[parameterTypes.length];
/* 540 */       for (int i = 0; i < params.length; i++)
/* 541 */         params[i] = parameterTypes[i].getName();
/* 542 */       SignatureKey key = new SignatureKey(method.getName(), params);
/* 543 */       return generateMethodInfo(key, method);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 547 */     throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for method " + method.getName(), e);
/*     */   }
/*     */ 
/*     */   protected MethodInfo generateMethodInfo(SignatureKey key, CtMethod method)
/*     */   {
/* 560 */     JavassistMethodInfo info = new JavassistMethodInfo(this.factory, this, key, method);
/* 561 */     synchronized (this.methods)
/*     */     {
/* 563 */       this.methods.put(key, info);
/*     */     }
/* 565 */     return info;
/*     */   }
/*     */ 
/*     */   protected CtClass[] getParameterTypes(SignatureKey key)
/*     */   {
/* 576 */     if (key.params == null) {
/* 577 */       return null;
/*     */     }
/* 579 */     CtClass[] result = new CtClass[key.params.length];
/* 580 */     for (int i = 0; i < key.params.length; i++) {
/* 581 */       result[i] = this.factory.getCtClass(key.params[i]);
/*     */     }
/* 583 */     return result;
/*     */   }
/*     */ 
/*     */   protected Object getAnnotatedTarget()
/*     */   {
/* 588 */     return this.ctClass;
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 593 */     return getAnnotations(this.ctClass);
/*     */   }
/*     */ 
/*     */   public JavassistInheritableAnnotationHolder getSuperHolder()
/*     */   {
/*     */     try
/*     */     {
/* 601 */       CtClass zuper = this.ctClass.getSuperclass();
/* 602 */       if (zuper == null)
/*     */       {
/* 604 */         return null;
/*     */       }
/* 606 */       return (JavassistTypeInfo)this.factory.getTypeInfo(zuper);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 610 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getActualTypeArguments()
/*     */   {
/* 616 */     return null;
/*     */   }
/*     */ 
/*     */   public TypeInfo getOwnerType()
/*     */   {
/* 621 */     return null;
/*     */   }
/*     */ 
/*     */   public ClassInfo getRawType()
/*     */   {
/* 626 */     return this;
/*     */   }
/*     */ 
/*     */   public TypeInfo getComponentType()
/*     */   {
/* 631 */     return null;
/*     */   }
/*     */ 
/*     */   public TypeInfo getKeyType()
/*     */   {
/* 636 */     return null;
/*     */   }
/*     */ 
/*     */   public TypeInfo getValueType()
/*     */   {
/* 641 */     return null;
/*     */   }
/*     */ 
/*     */   public PackageInfo getPackage()
/*     */   {
/* 646 */     if (this.packageInfo == null)
/*     */     {
/* 648 */       String name = this.ctClass.getPackageName();
/* 649 */       if (name != null) {
/* 650 */         this.packageInfo = new PackageInfoImpl(this.ctClass.getPackageName());
/*     */       }
/*     */     }
/* 653 */     return this.packageInfo;
/*     */   }
/*     */ 
/*     */   public void setAttachment(String name, Object attachment)
/*     */   {
/* 658 */     if (name == null)
/* 659 */       throw new IllegalArgumentException("Null name");
/* 660 */     synchronized (this)
/*     */     {
/* 662 */       if (this.attachments == null)
/*     */       {
/* 664 */         if (attachment == null)
/* 665 */           return;
/* 666 */         this.attachments = new TypeInfoAttachments();
/*     */       }
/*     */     }
/* 669 */     if (attachment == null)
/* 670 */       this.attachments.removeAttachment(name);
/*     */     else
/* 672 */       this.attachments.addAttachment(name, attachment);
/*     */   }
/*     */ 
/*     */   public <T> T getAttachment(Class<T> expectedType)
/*     */   {
/* 677 */     if (expectedType == null)
/* 678 */       throw new IllegalArgumentException("Null expectedType");
/* 679 */     Object result = getAttachment(expectedType.getName());
/* 680 */     if (result == null)
/* 681 */       return null;
/* 682 */     return expectedType.cast(result);
/*     */   }
/*     */ 
/*     */   public Object getAttachment(String name)
/*     */   {
/* 687 */     if (name == null)
/* 688 */       throw new IllegalArgumentException("Null name");
/* 689 */     synchronized (this)
/*     */     {
/* 691 */       if (this.attachments == null)
/* 692 */         return null;
/*     */     }
/* 694 */     return this.attachments.getAttachment(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistTypeInfo
 * JD-Core Version:    0.6.0
 */