/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.concurrent.atomic.AtomicInteger;
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public class JavassistReflectionFactory
/*     */ {
/*  52 */   private static final AtomicInteger counter = new AtomicInteger(0);
/*     */   private final boolean check;
/*     */ 
/*     */   public JavassistReflectionFactory(boolean check)
/*     */   {
/*  64 */     this.check = check;
/*     */   }
/*     */ 
/*     */   public JavassistMethod createMethod(CtMethod ctMethod)
/*     */     throws Throwable
/*     */   {
/*  76 */     ClassPool pool = JavassistTypeInfoFactoryImpl.pool;
/*  77 */     CtClass result = pool.makeClass(JavassistMethod.class.getName() + counter.incrementAndGet());
/*     */ 
/*  87 */     result.addInterface(pool.get(JavassistMethod.class.getName()));
/*     */ 
/*  89 */     CtConstructor constructor = new CtConstructor(null, result);
/*  90 */     constructor.setBody("super();");
/*  91 */     result.addConstructor(constructor);
/*     */ 
/*  93 */     CtClass object = pool.get(Object.class.getName());
/*     */ 
/*  95 */     JBossStringBuilder buffer = new JBossStringBuilder();
/*     */ 
/*  98 */     buffer.append("public Object invoke(Object target, Object[] args) throws Throwable {");
/*     */ 
/* 100 */     boolean isInstanceMethod = !Modifier.isStatic(ctMethod.getModifiers());
/*     */ 
/* 103 */     if ((this.check) && (isInstanceMethod))
/*     */     {
/* 105 */       buffer.append("if (target == null) throw new IllegalArgumentException(\"Null target for ");
/* 106 */       buffer.append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
/*     */     }
/*     */ 
/* 110 */     CtClass declaring = ctMethod.getDeclaringClass();
/* 111 */     boolean needsCast = (isInstanceMethod) && (!object.equals(declaring));
/* 112 */     if ((this.check) && (needsCast))
/*     */     {
/* 114 */       buffer.append("if (target instanceof ").append(declaring.getName()).append(" == false) ");
/* 115 */       buffer.append("throw new IllegalArgumentException(\"Target \" + target + \"");
/* 116 */       buffer.append(" is not an instance of ").append(declaring.getName());
/* 117 */       buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
/*     */     }
/*     */ 
/* 121 */     CtClass[] params = ctMethod.getParameterTypes();
/* 122 */     if (this.check)
/*     */     {
/* 125 */       if (params.length != 0)
/*     */       {
/* 127 */         buffer.append("if (args == null || args.length != ").append(params.length).append(") ");
/* 128 */         buffer.append("throw new IllegalArgumentException(\"Expected ").append(params.length).append(" parameter(s)");
/* 129 */         buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
/*     */       }
/*     */       else
/*     */       {
/* 134 */         buffer.append("if (args != null && args.length != 0)");
/* 135 */         buffer.append("throw new IllegalArgumentException(\"Expected no parameters");
/* 136 */         buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
/*     */       }
/* 138 */       for (int i = 0; i < params.length; i++)
/*     */       {
/* 140 */         if (object.equals(params[i]))
/*     */           continue;
/* 142 */         String paramType = getBoxedType(params[i]);
/*     */ 
/* 144 */         if (params[i].isPrimitive())
/*     */         {
/* 146 */           buffer.append("if (args[").append(i).append("] == null) ");
/* 147 */           buffer.append("throw new IllegalArgumentException(\"Parameter ").append(i);
/* 148 */           buffer.append(" cannot be null for ").append(params[i].getName());
/* 149 */           buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
/*     */         }
/*     */ 
/* 152 */         buffer.append("if (args[").append(i).append("] != null && ");
/* 153 */         buffer.append("args[").append(i).append("] instanceof ").append(paramType).append(" == false) ");
/* 154 */         buffer.append("throw new IllegalArgumentException(\"Parameter ").append(i).append(" \" + args[").append(i).append("] + \"");
/* 155 */         buffer.append(" is not an instance of ").append(paramType);
/* 156 */         buffer.append(" for ").append(ctMethod.getName()).append(ctMethod.getSignature()).append("\");");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 162 */     CtClass returnType = ctMethod.getReturnType();
/* 163 */     boolean isVoid = CtClass.voidType.equals(returnType);
/* 164 */     boolean isPrimitive = returnType.isPrimitive();
/* 165 */     if (!isVoid)
/*     */     {
/* 167 */       buffer.append("return ");
/* 168 */       if (isPrimitive) {
/* 169 */         buffer.append("new ").append(getBoxedType(returnType)).append('(');
/*     */       }
/*     */     }
/*     */ 
/* 173 */     if (isInstanceMethod)
/*     */     {
/* 175 */       buffer.append('(');
/* 176 */       if (needsCast) {
/* 177 */         buffer.append("(").append(declaring.getName()).append(')');
/*     */       }
/* 179 */       buffer.append("target).");
/*     */     }
/*     */     else
/*     */     {
/* 184 */       buffer.append(declaring.getName()).append('.');
/*     */     }
/*     */ 
/* 188 */     buffer.append(ctMethod.getName()).append('(');
/*     */ 
/* 191 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 193 */       buffer.append('(');
/*     */ 
/* 195 */       if (!object.equals(params[i]))
/* 196 */         buffer.append("(").append(getBoxedType(params[i])).append(')');
/* 197 */       buffer.append("args[").append(i).append("])");
/*     */ 
/* 199 */       if (params[i].isPrimitive()) {
/* 200 */         unbox(buffer, params[i]);
/*     */       }
/* 202 */       if (i < params.length - 1)
/* 203 */         buffer.append(", ");
/*     */     }
/* 205 */     buffer.append(')');
/*     */ 
/* 208 */     if ((!isVoid) && (isPrimitive)) {
/* 209 */       buffer.append(')');
/*     */     }
/* 211 */     buffer.append(';');
/*     */ 
/* 214 */     if (isVoid)
/* 215 */       buffer.append("return null;");
/* 216 */     buffer.append('}');
/*     */ 
/* 219 */     String code = buffer.toString();
/*     */     try
/*     */     {
/* 222 */       CtMethod invoke = CtNewMethod.make(code, result);
/* 223 */       result.addMethod(invoke);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 227 */       throw new RuntimeException("Cannot compile " + code, e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 233 */       return (JavassistMethod)AccessController.doPrivileged(new PrivilegedExceptionAction(result)
/*     */       {
/*     */         public JavassistMethod run() throws Exception
/*     */         {
/* 237 */           Class clazz = this.val$result.toClass();
/* 238 */           return (JavassistMethod)clazz.newInstance();
/*     */         } } );
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/*     */     }
/* 244 */     throw e.getCause();
/*     */   }
/*     */ 
/*     */   public JavassistConstructor createConstructor(CtConstructor ctConstructor)
/*     */     throws Throwable
/*     */   {
/* 257 */     ClassPool pool = JavassistTypeInfoFactoryImpl.pool;
/* 258 */     CtClass result = pool.makeClass(JavassistConstructor.class.getName() + counter.incrementAndGet());
/*     */     try
/*     */     {
/* 261 */       CtClass magic = pool.get("sun.reflect.MagicAccessorImpl");
/* 262 */       result.setSuperclass(magic);
/*     */     }
/*     */     catch (NotFoundException ignored)
/*     */     {
/*     */     }
/* 267 */     result.addInterface(pool.get(JavassistConstructor.class.getName()));
/*     */ 
/* 269 */     CtConstructor constructor = new CtConstructor(null, result);
/* 270 */     constructor.setBody("super();");
/* 271 */     result.addConstructor(constructor);
/*     */ 
/* 273 */     CtClass object = pool.get(Object.class.getName());
/*     */ 
/* 275 */     JBossStringBuilder buffer = new JBossStringBuilder();
/*     */ 
/* 278 */     buffer.append("public Object newInstance(Object[] args) throws Throwable {");
/*     */ 
/* 280 */     String declaring = ctConstructor.getDeclaringClass().getName();
/*     */ 
/* 283 */     CtClass[] params = ctConstructor.getParameterTypes();
/* 284 */     if (this.check)
/*     */     {
/* 287 */       if (params.length != 0)
/*     */       {
/* 289 */         buffer.append("if (args == null || args.length != ").append(params.length).append(") ");
/* 290 */         buffer.append("throw new IllegalArgumentException(\"Expected ").append(params.length).append(" parameter(s)");
/* 291 */         buffer.append(" for ").append("new ").append(declaring).append(ctConstructor.getSignature()).append("\");");
/*     */       }
/*     */       else
/*     */       {
/* 296 */         buffer.append("if (args != null && args.length != 0)");
/* 297 */         buffer.append("throw new IllegalArgumentException(\"Expected no parameters");
/* 298 */         buffer.append(" for ").append("new ").append(declaring).append(ctConstructor.getSignature()).append("\");");
/*     */       }
/* 300 */       for (int i = 0; i < params.length; i++)
/*     */       {
/* 302 */         if (object.equals(params[i]))
/*     */           continue;
/* 304 */         String paramType = getBoxedType(params[i]);
/*     */ 
/* 306 */         if (params[i].isPrimitive())
/*     */         {
/* 308 */           buffer.append("if (args[").append(i).append("] == null) ");
/* 309 */           buffer.append("throw new IllegalArgumentException(\"Parameter ").append(i);
/* 310 */           buffer.append(" cannot be null for ").append(params[i].getName());
/* 311 */           buffer.append(" for ").append("new ").append(declaring).append(ctConstructor.getSignature()).append("\");");
/*     */         }
/*     */ 
/* 314 */         buffer.append("if (args[").append(i).append("] != null && ");
/* 315 */         buffer.append("args[").append(i).append("] instanceof ").append(paramType).append(" == false) ");
/* 316 */         buffer.append("throw new IllegalArgumentException(\"Parameter ").append(i).append(" \" + args[").append(i).append("] + \"");
/* 317 */         buffer.append(" is not an instance of ").append(paramType);
/* 318 */         buffer.append(" for ").append("new ").append(declaring).append(ctConstructor.getSignature()).append("\");");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 324 */     buffer.append("return new ").append(declaring).append('(');
/*     */ 
/* 327 */     for (int i = 0; i < params.length; i++)
/*     */     {
/* 329 */       buffer.append('(');
/*     */ 
/* 331 */       if (!object.equals(params[i]))
/* 332 */         buffer.append("(").append(getBoxedType(params[i])).append(')');
/* 333 */       buffer.append("args[").append(i).append("])");
/*     */ 
/* 335 */       if (params[i].isPrimitive()) {
/* 336 */         unbox(buffer, params[i]);
/*     */       }
/* 338 */       if (i < params.length - 1)
/* 339 */         buffer.append(", ");
/*     */     }
/* 341 */     buffer.append(");}");
/*     */ 
/* 344 */     String code = buffer.toString();
/*     */     try
/*     */     {
/* 347 */       CtMethod newInstance = CtNewMethod.make(code, result);
/* 348 */       result.addMethod(newInstance);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 352 */       throw new RuntimeException("Cannot compile " + code, e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 358 */       return (JavassistConstructor)AccessController.doPrivileged(new PrivilegedExceptionAction(result)
/*     */       {
/*     */         public JavassistConstructor run() throws Exception
/*     */         {
/* 362 */           Class clazz = this.val$result.toClass();
/* 363 */           return (JavassistConstructor)clazz.newInstance();
/*     */         } } );
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/*     */     }
/* 369 */     throw e.getCause();
/*     */   }
/*     */ 
/*     */   public JavassistField createField(CtField ctField)
/*     */     throws Throwable
/*     */   {
/* 382 */     ClassPool pool = JavassistTypeInfoFactoryImpl.pool;
/* 383 */     CtClass result = pool.makeClass(JavassistField.class.getName() + counter.incrementAndGet());
/*     */     try
/*     */     {
/* 386 */       CtClass magic = pool.get("sun.reflect.MagicAccessorImpl");
/* 387 */       result.setSuperclass(magic);
/*     */     }
/*     */     catch (NotFoundException ignored)
/*     */     {
/*     */     }
/* 392 */     result.addInterface(pool.get(JavassistField.class.getName()));
/*     */ 
/* 394 */     CtConstructor constructor = new CtConstructor(null, result);
/* 395 */     constructor.setBody("super();");
/* 396 */     result.addConstructor(constructor);
/*     */ 
/* 398 */     CtClass object = pool.get(Object.class.getName());
/*     */ 
/* 401 */     JBossStringBuilder buffer = new JBossStringBuilder();
/*     */ 
/* 404 */     buffer.append("public Object get(Object target) throws Throwable {");
/*     */ 
/* 406 */     boolean isInstanceField = !Modifier.isStatic(ctField.getModifiers());
/*     */ 
/* 409 */     if ((this.check) && (isInstanceField))
/*     */     {
/* 411 */       buffer.append("if (target == null) throw new IllegalArgumentException(\"Null target");
/* 412 */       buffer.append(" for ").append(ctField.getName()).append("\");");
/*     */     }
/*     */ 
/* 416 */     CtClass declaring = ctField.getDeclaringClass();
/* 417 */     boolean needsCast = (isInstanceField) && (!object.equals(declaring));
/* 418 */     if ((this.check) && (needsCast))
/*     */     {
/* 420 */       buffer.append("if (target instanceof ").append(declaring.getName()).append(" == false) ");
/* 421 */       buffer.append("throw new IllegalArgumentException(\"Target \" + target + \"");
/* 422 */       buffer.append(" is not an instance of ").append(declaring.getName());
/* 423 */       buffer.append(" for ").append(ctField.getName()).append("\");");
/*     */     }
/*     */ 
/* 427 */     CtClass type = ctField.getType();
/* 428 */     boolean isPrimitive = type.isPrimitive();
/* 429 */     buffer.append("return ");
/* 430 */     if (isPrimitive) {
/* 431 */       buffer.append("new ").append(getBoxedType(type)).append('(');
/*     */     }
/*     */ 
/* 434 */     if (isInstanceField)
/*     */     {
/* 436 */       buffer.append('(');
/* 437 */       if (needsCast) {
/* 438 */         buffer.append("(").append(declaring.getName()).append(')');
/*     */       }
/* 440 */       buffer.append("target).");
/*     */     }
/*     */     else
/*     */     {
/* 445 */       buffer.append(declaring.getName()).append('.');
/*     */     }
/*     */ 
/* 449 */     buffer.append(ctField.getName());
/*     */ 
/* 452 */     if (isPrimitive) {
/* 453 */       buffer.append(')');
/*     */     }
/* 455 */     buffer.append(";}");
/*     */ 
/* 458 */     String code = buffer.toString();
/* 459 */     CtMethod get = CtNewMethod.make(code, result);
/*     */     try
/*     */     {
/* 462 */       result.addMethod(get);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 466 */       throw new RuntimeException("Cannot compile " + code, e);
/*     */     }
/*     */ 
/* 470 */     buffer = new JBossStringBuilder();
/*     */ 
/* 473 */     buffer.append("public void set(Object target, Object value) throws Throwable {");
/*     */ 
/* 476 */     if ((this.check) && (isInstanceField))
/*     */     {
/* 478 */       buffer.append("if (target == null) throw new IllegalArgumentException(\"Null target");
/* 479 */       buffer.append(" for ").append(ctField.getName()).append("\");");
/*     */     }
/*     */ 
/* 483 */     if ((this.check) && (needsCast))
/*     */     {
/* 485 */       buffer.append("if (target instanceof ").append(declaring.getName()).append(" == false) ");
/* 486 */       buffer.append("throw new IllegalArgumentException(\"Target \" + target + \"");
/* 487 */       buffer.append(" is not an instance of ").append(declaring.getName());
/* 488 */       buffer.append(" for ").append(ctField.getName()).append("\");");
/*     */     }
/*     */ 
/* 492 */     if (this.check)
/*     */     {
/* 494 */       if (!object.equals(type))
/*     */       {
/* 496 */         String paramType = getBoxedType(type);
/*     */ 
/* 498 */         if (type.isPrimitive())
/*     */         {
/* 500 */           buffer.append("if (type == null) ");
/* 501 */           buffer.append("throw new IllegalArgumentException(\"Value ");
/* 502 */           buffer.append(" cannot be null for ").append(type.getName());
/* 503 */           buffer.append(" for ").append(ctField.getName()).append("\");");
/*     */         }
/*     */ 
/* 506 */         buffer.append("if (value != null && ");
/* 507 */         buffer.append("value instanceof ").append(paramType).append(" == false) ");
/* 508 */         buffer.append("throw new IllegalArgumentException(\"Value \" + value + \"");
/* 509 */         buffer.append(" is not an instance of ").append(paramType);
/* 510 */         buffer.append(" for ").append(ctField.getName()).append("\");");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 515 */     if (isInstanceField)
/*     */     {
/* 517 */       buffer.append('(');
/* 518 */       if (needsCast) {
/* 519 */         buffer.append("(").append(declaring.getName()).append(')');
/*     */       }
/* 521 */       buffer.append("target).");
/*     */     }
/*     */     else
/*     */     {
/* 526 */       buffer.append(declaring.getName()).append('.');
/*     */     }
/*     */ 
/* 530 */     buffer.append(ctField.getName()).append("=");
/*     */ 
/* 533 */     buffer.append('(');
/*     */ 
/* 535 */     if (!object.equals(type))
/* 536 */       buffer.append("(").append(getBoxedType(type)).append(')');
/* 537 */     buffer.append("value)");
/*     */ 
/* 539 */     if (type.isPrimitive()) {
/* 540 */       unbox(buffer, type);
/*     */     }
/* 542 */     buffer.append(";}");
/*     */ 
/* 545 */     code = buffer.toString();
/*     */     try
/*     */     {
/* 548 */       CtMethod set = CtNewMethod.make(code, result);
/* 549 */       result.addMethod(set);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 553 */       throw new RuntimeException("Cannot compile " + code, e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 559 */       return (JavassistField)AccessController.doPrivileged(new PrivilegedExceptionAction(result)
/*     */       {
/*     */         public JavassistField run() throws Exception
/*     */         {
/* 563 */           Class clazz = this.val$result.toClass();
/* 564 */           return (JavassistField)clazz.newInstance();
/*     */         } } );
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/*     */     }
/* 570 */     throw e.getCause();
/*     */   }
/*     */ 
/*     */   protected void unbox(JBossStringBuilder buffer, CtClass primitive)
/*     */   {
/* 582 */     if (CtClass.booleanType.equals(primitive))
/* 583 */       buffer.append(".booleanValue()");
/* 584 */     else if (CtClass.byteType.equals(primitive))
/* 585 */       buffer.append(".byteValue()");
/* 586 */     else if (CtClass.charType.equals(primitive))
/* 587 */       buffer.append(".charValue()");
/* 588 */     else if (CtClass.doubleType.equals(primitive))
/* 589 */       buffer.append(".doubleValue()");
/* 590 */     else if (CtClass.floatType.equals(primitive))
/* 591 */       buffer.append(".floatValue()");
/* 592 */     else if (CtClass.intType.equals(primitive))
/* 593 */       buffer.append(".intValue()");
/* 594 */     else if (CtClass.longType.equals(primitive))
/* 595 */       buffer.append(".longValue()");
/* 596 */     else if (CtClass.shortType.equals(primitive)) {
/* 597 */       buffer.append(".shortValue()");
/*     */     }
/*     */     else
/* 600 */       throw new UnreachableStatementException();
/*     */   }
/*     */ 
/*     */   protected String getBoxedType(CtClass type)
/*     */   {
/* 613 */     if (type.isPrimitive())
/*     */     {
/* 615 */       if (CtClass.booleanType.equals(type))
/* 616 */         return Boolean.class.getName();
/* 617 */       if (CtClass.byteType.equals(type))
/* 618 */         return Byte.class.getName();
/* 619 */       if (CtClass.charType.equals(type))
/* 620 */         return Character.class.getName();
/* 621 */       if (CtClass.doubleType.equals(type))
/* 622 */         return Double.class.getName();
/* 623 */       if (CtClass.floatType.equals(type))
/* 624 */         return Float.class.getName();
/* 625 */       if (CtClass.intType.equals(type))
/* 626 */         return Integer.class.getName();
/* 627 */       if (CtClass.longType.equals(type))
/* 628 */         return Long.class.getName();
/* 629 */       if (CtClass.shortType.equals(type))
/* 630 */         return Short.class.getName();
/* 631 */       throw new UnreachableStatementException();
/*     */     }
/* 633 */     return type.getName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistReflectionFactory
 * JD-Core Version:    0.6.0
 */