/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import org.jboss.reflect.plugins.AnnotationHelper;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class JavassistParameterInfo extends JavassistAnnotatedInfo
/*     */   implements ParameterInfo
/*     */ {
/*     */   private static final long serialVersionUID = 7388866103874412735L;
/*     */   private JavassistAnnotatedParameterInfo annotated;
/*     */   private String name;
/*     */   private TypeInfo parameterType;
/*     */ 
/*     */   public JavassistParameterInfo(AnnotationHelper annotationHelper, JavassistAnnotatedParameterInfo annotated, int index, TypeInfo parameterType)
/*     */   {
/*  60 */     super(annotationHelper);
/*  61 */     this.annotated = annotated;
/*  62 */     this.name = ("arg" + index);
/*  63 */     this.parameterType = parameterType;
/*     */   }
/*     */ 
/*     */   protected JavassistAnnotatedInfo getAnnotated()
/*     */   {
/*  73 */     return this.annotated;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  78 */     return this.name;
/*     */   }
/*     */ 
/*     */   public TypeInfo getParameterType()
/*     */   {
/*  83 */     return this.parameterType;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  88 */     if (this == obj)
/*  89 */       return true;
/*  90 */     if ((obj == null) || (!(obj instanceof ParameterInfo))) {
/*  91 */       return false;
/*     */     }
/*  93 */     ParameterInfo other = (ParameterInfo)obj;
/*  94 */     return this.parameterType.equals(other.getParameterType());
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/*  99 */     return getName().hashCode();
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 104 */     buffer.append(getParameterType());
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 109 */     buffer.append("type=").append(getParameterType());
/* 110 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 115 */     if (this.annotationsArray == NOT_CONFIGURED)
/*     */     {
/* 117 */       this.annotated.createParameterAnnotations();
/*     */     }
/* 119 */     return this.annotationsArray;
/*     */   }
/*     */ 
/*     */   public void setAnnotations(AnnotationValue[] annotations)
/*     */   {
/* 124 */     this.annotationsArray = annotations;
/* 125 */     setupAnnotations(annotations);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistParameterInfo
 * JD-Core Version:    0.6.0
 */