/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Arrays;
/*     */ import javassist.CtBehavior;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.reflect.plugins.AnnotationHelper;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class JavassistMethodInfo extends JavassistAnnotatedParameterInfo
/*     */   implements MethodInfo
/*     */ {
/*     */   private static final long serialVersionUID = 101183748227690112L;
/*  46 */   private static final JavassistReflectionFactory reflectionFactory = new JavassistReflectionFactory(true);
/*     */   private SignatureKey key;
/*     */   private CtMethod ctMethod;
/*     */   private transient JavassistMethod method;
/*     */   private transient TypeInfo returnType;
/*     */ 
/*     */   public JavassistMethodInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, SignatureKey key, CtMethod ctMethod)
/*     */   {
/*  70 */     super(annotationHelper);
/*  71 */     this.typeInfo = typeInfo;
/*  72 */     this.key = key;
/*  73 */     this.ctMethod = ctMethod;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  78 */     return this.key.name;
/*     */   }
/*     */ 
/*     */   public ClassInfo getDeclaringClass()
/*     */   {
/*  83 */     return this.typeInfo;
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/*  88 */     return this.ctMethod.getModifiers();
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/*  93 */     return Modifier.isPublic(getModifiers());
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/*  98 */     return Modifier.isStatic(getModifiers());
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 103 */     return Modifier.isVolatile(getModifiers());
/*     */   }
/*     */ 
/*     */   public ClassInfo[] getExceptionTypes()
/*     */   {
/* 108 */     if (this.exceptionTypes == null)
/*     */     {
/*     */       try
/*     */       {
/* 112 */         CtClass[] types = this.ctMethod.getExceptionTypes();
/* 113 */         this.exceptionTypes = new ClassInfo[types.length];
/* 114 */         for (int i = 0; i < types.length; i++)
/* 115 */           this.exceptionTypes[i] = ((ClassInfo)this.typeInfo.getFactory().getTypeInfo(types[i]));
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/* 119 */         throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for exception types of method " + getName(), e);
/*     */       }
/*     */     }
/* 122 */     return this.exceptionTypes;
/*     */   }
/*     */ 
/*     */   public TypeInfo getReturnType()
/*     */   {
/* 127 */     if (this.returnType != null)
/* 128 */       return this.returnType;
/*     */     try
/*     */     {
/* 131 */       CtClass clazz = this.ctMethod.getReturnType();
/* 132 */       this.returnType = this.typeInfo.getFactory().getTypeInfo(clazz);
/* 133 */       return this.returnType;
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 137 */     throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for return type of method " + getName(), e);
/*     */   }
/*     */ 
/*     */   public ParameterInfo[] getParameters()
/*     */   {
/* 143 */     if (this.parameters == null)
/* 144 */       generateParameters();
/* 145 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getParameterTypes()
/*     */   {
/* 150 */     if (this.parameterTypes == null)
/* 151 */       generateParameters();
/* 152 */     return this.parameterTypes;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object target, Object[] args) throws Throwable
/*     */   {
/* 157 */     if (this.method == null)
/* 158 */       this.method = reflectionFactory.createMethod(this.ctMethod);
/* 159 */     return this.method.invoke(target, args);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 164 */     return getName().hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 169 */     if (obj == this)
/* 170 */       return true;
/* 171 */     if ((obj == null) || (!(obj instanceof MethodInfo))) {
/* 172 */       return false;
/*     */     }
/* 174 */     MethodInfo other = (MethodInfo)obj;
/*     */ 
/* 176 */     if (!getName().equals(other.getName()))
/* 177 */       return false;
/* 178 */     if (!getDeclaringClass().equals(other.getDeclaringClass()))
/* 179 */       return false;
/* 180 */     if (!getReturnType().equals(other.getReturnType()))
/* 181 */       return false;
/* 182 */     return Arrays.equals(getParameterTypes(), other.getParameterTypes());
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 187 */     buffer.append(getName());
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 192 */     buffer.append("name=").append(getName());
/* 193 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   protected void generateParameters()
/*     */   {
/*     */     try
/*     */     {
/* 203 */       CtClass[] types = this.ctMethod.getParameterTypes();
/* 204 */       this.parameterTypes = new TypeInfo[types.length];
/* 205 */       for (int i = 0; i < types.length; i++)
/* 206 */         this.parameterTypes[i] = this.typeInfo.getFactory().getTypeInfo(types[i]);
/* 207 */       this.parameters = new ParameterInfo[types.length];
/* 208 */       for (int i = 0; i < types.length; i++)
/* 209 */         this.parameters[i] = new JavassistParameterInfo(this.annotationHelper, this, i, this.parameterTypes[i]);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 213 */       throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for parameters of " + getName(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 219 */     return getAnnotations(this.ctMethod);
/*     */   }
/*     */ 
/*     */   protected CtBehavior getParameterizedObject()
/*     */   {
/* 224 */     return this.ctMethod;
/*     */   }
/*     */ 
/*     */   protected void createParameterAnnotations()
/*     */   {
/*     */     try
/*     */     {
/* 231 */       Object[][] parameterAnnotations = this.ctMethod.getParameterAnnotations();
/* 232 */       super.setupParameterAnnotations(parameterAnnotations);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 237 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistMethodInfo
 * JD-Core Version:    0.6.0
 */