/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.Modifier;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.reflect.plugins.AnnotationHelper;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.FieldInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class JavassistFieldInfo extends JavassistAnnotatedInfo
/*     */   implements FieldInfo
/*     */ {
/*     */   private static final long serialVersionUID = -104555531831318930L;
/*  48 */   private static final JavassistReflectionFactory reflectionFactory = new JavassistReflectionFactory(true);
/*     */   private CtField ctField;
/*     */   private transient JavassistField field;
/*     */   private transient TypeInfo fieldType;
/*     */   protected JavassistTypeInfo typeInfo;
/*     */ 
/*     */   public JavassistFieldInfo(AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtField ctField)
/*     */   {
/*  71 */     super(annotationHelper);
/*  72 */     this.typeInfo = typeInfo;
/*  73 */     this.ctField = ctField;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  78 */     return this.ctField.getName();
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/*  83 */     return this.ctField.getModifiers();
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/*  88 */     return Modifier.isPublic(getModifiers());
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/*  93 */     return Modifier.isStatic(getModifiers());
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/*  98 */     return Modifier.isVolatile(getModifiers());
/*     */   }
/*     */ 
/*     */   public ClassInfo getDeclaringClass()
/*     */   {
/* 103 */     return this.typeInfo;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/* 108 */     if (this.fieldType != null)
/* 109 */       return this.fieldType;
/*     */     try
/*     */     {
/* 112 */       CtClass clazz = this.ctField.getType();
/* 113 */       this.fieldType = this.typeInfo.getFactory().getTypeInfo(clazz);
/* 114 */       return this.fieldType;
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 118 */     throw JavassistTypeInfoFactoryImpl.raiseFieldNotFound(getName(), e);
/*     */   }
/*     */ 
/*     */   public Object get(Object target)
/*     */     throws Throwable
/*     */   {
/* 124 */     if (this.field == null)
/* 125 */       this.field = reflectionFactory.createField(this.ctField);
/* 126 */     return this.field.get(target);
/*     */   }
/*     */ 
/*     */   public Object set(Object target, Object value) throws Throwable
/*     */   {
/* 131 */     if (this.field == null)
/* 132 */       this.field = reflectionFactory.createField(this.ctField);
/* 133 */     this.field.set(target, value);
/* 134 */     return null;
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 139 */     return getName().hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 144 */     if (obj == this)
/* 145 */       return true;
/* 146 */     if ((obj == null) || (!(obj instanceof FieldInfo))) {
/* 147 */       return false;
/*     */     }
/* 149 */     FieldInfo other = (FieldInfo)obj;
/* 150 */     if (!getName().equals(other.getName()))
/* 151 */       return false;
/* 152 */     return getDeclaringClass().equals(other.getDeclaringClass());
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 157 */     buffer.append(getName());
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 162 */     buffer.append("name=").append(getName());
/* 163 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 168 */     return getAnnotations(this.ctField);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistFieldInfo
 * JD-Core Version:    0.6.0
 */