/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import javassist.CtClass;
/*     */ import org.jboss.reflect.plugins.EnumConstantInfoImpl;
/*     */ import org.jboss.reflect.spi.EnumConstantInfo;
/*     */ import org.jboss.reflect.spi.EnumInfo;
/*     */ 
/*     */ public class JavassistEnumInfo extends JavassistTypeInfo
/*     */   implements EnumInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3546645408219542832L;
/*     */   protected EnumConstantInfoImpl[] enumConstants;
/*  46 */   protected HashMap<String, EnumConstantInfo> constants = new HashMap();
/*     */ 
/*     */   public JavassistEnumInfo(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class<? extends Object> clazz)
/*     */   {
/*  57 */     super(factory, ctClass, clazz);
/*     */   }
/*     */ 
/*     */   public void setEnumConstants(EnumConstantInfoImpl[] enumConstants)
/*     */   {
/*  67 */     for (int i = 0; i < enumConstants.length; i++)
/*  68 */       this.constants.put(enumConstants[i].getName(), enumConstants[i]);
/*  69 */     this.enumConstants = enumConstants;
/*     */   }
/*     */ 
/*     */   public EnumConstantInfo[] getEnumConstants()
/*     */   {
/*  74 */     return this.enumConstants;
/*     */   }
/*     */ 
/*     */   public EnumConstantInfo getEnumConstant(String name)
/*     */   {
/*  79 */     return (EnumConstantInfo)this.constants.get(name);
/*     */   }
/*     */ 
/*     */   public Object getEnumValue(String name)
/*     */   {
/*  85 */     return Enum.valueOf(getType(), name);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*  91 */     if (this == o) return true;
/*  92 */     if ((o == null) || (!(o instanceof EnumInfo))) return false;
/*  93 */     if (!super.equals(o)) return false;
/*     */ 
/*  95 */     EnumInfo enumInfo = (EnumInfo)o;
/*     */ 
/*  97 */     return getName().equals(enumInfo.getName());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 105 */     return getName().hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistEnumInfo
 * JD-Core Version:    0.6.0
 */