/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import javassist.CtClass;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ArrayInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class JavassistArrayInfoImpl extends JavassistTypeInfo
/*     */   implements ArrayInfo
/*     */ {
/*     */   private static final long serialVersionUID = 9195834689976459024L;
/*  43 */   static final AnnotationValue[] UNKNOWN_ANNOTATIONS = new AnnotationValue[0];
/*     */   protected TypeInfo componentType;
/*  49 */   protected int hash = -1;
/*     */ 
/*     */   private static String getName(TypeInfo componentType)
/*     */   {
/*  53 */     StringBuilder builder = new StringBuilder();
/*  54 */     builder.append("[");
/*  55 */     TypeInfo temp = componentType;
/*  56 */     while (temp.isArray())
/*     */     {
/*  58 */       builder.append("[");
/*  59 */       temp = ((JavassistArrayInfoImpl)temp).componentType;
/*     */     }
/*  61 */     if (temp.isPrimitive())
/*     */     {
/*  64 */       String encodedName = Signature.getPrimativeArrayType(temp.getName());
/*  65 */       builder.append(encodedName);
/*     */     }
/*     */     else
/*     */     {
/*  69 */       builder.append("L").append(temp.getName()).append(";");
/*     */     }
/*  71 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   JavassistArrayInfoImpl(JavassistTypeInfoFactoryImpl factory, CtClass ctClass, Class<? extends Object> clazz, TypeInfo componentType)
/*     */   {
/*  84 */     super(factory, getName(componentType), ctClass, clazz);
/*  85 */     this.componentType = componentType;
/*  86 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public TypeInfo getComponentType()
/*     */   {
/*  91 */     return this.componentType;
/*     */   }
/*     */ 
/*     */   public AnnotationValue getAnnotation(String name)
/*     */   {
/*  96 */     return null;
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 101 */     return UNKNOWN_ANNOTATIONS;
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(String name)
/*     */   {
/* 106 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 111 */     if (this == o) return true;
/* 112 */     if (!(o instanceof ArrayInfo)) return false;
/* 113 */     if (!super.equals(o)) return false;
/*     */ 
/* 115 */     ArrayInfo arrayInfo = (ArrayInfo)o;
/*     */ 
/* 117 */     return this.componentType.equals(arrayInfo.getComponentType());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 122 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 129 */     int result = super.hashCode();
/* 130 */     result = 29 * result + this.componentType.hashCode();
/* 131 */     this.hash = result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.JavassistArrayInfoImpl
 * JD-Core Version:    0.6.0
 */