/*     */ package org.jboss.reflect.plugins.introspection;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.lang.reflect.Constructor;
/*     */ import org.jboss.reflect.plugins.ConstructorInfoImpl;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class ReflectConstructorInfoImpl extends ConstructorInfoImpl
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected transient Constructor constructor;
/*     */ 
/*     */   public ReflectConstructorInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ReflectConstructorInfoImpl(AnnotationValue[] annotations, TypeInfo[] parameterTypes, AnnotationValue[][] parameterAnnotations, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring)
/*     */   {
/*  67 */     super(annotations, parameterTypes, parameterAnnotations, exceptionTypes, modifiers, declaring);
/*     */   }
/*     */ 
/*     */   public ReflectConstructorInfoImpl(AnnotationValue[] annotations, ParameterInfo[] parameters, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring)
/*     */   {
/*  81 */     super(annotations, parameters, exceptionTypes, modifiers, declaring);
/*     */   }
/*     */ 
/*     */   public void setConstructor(Constructor constructor)
/*     */   {
/*  91 */     this.constructor = constructor;
/*     */   }
/*     */ 
/*     */   public Constructor getConstructor()
/*     */   {
/* 101 */     return this.constructor;
/*     */   }
/*     */ 
/*     */   public Object newInstance(Object[] args) throws Throwable
/*     */   {
/* 106 */     return ReflectionUtils.newInstance(this.constructor, args);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream oistream)
/*     */     throws IOException, ClassNotFoundException, NoSuchMethodException
/*     */   {
/* 120 */     oistream.defaultReadObject();
/* 121 */     int length = this.parameterTypes != null ? this.parameterTypes.length : 0;
/* 122 */     Class[] classes = new Class[length];
/* 123 */     for (int i = 0; i < length; i++)
/* 124 */       classes[i] = this.parameterTypes[i].getType();
/* 125 */     this.constructor = ReflectionUtils.findExactConstructor(getDeclaringClass().getType(), classes);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.introspection.ReflectConstructorInfoImpl
 * JD-Core Version:    0.6.0
 */