/*     */ package org.jboss.reflect.plugins.introspection;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.AnnotatedElement;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.GenericArrayType;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.lang.reflect.TypeVariable;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Collection;
/*     */ import java.util.Map;
/*     */ import org.jboss.reflect.plugins.AnnotationAttributeImpl;
/*     */ import org.jboss.reflect.plugins.AnnotationHelper;
/*     */ import org.jboss.reflect.plugins.AnnotationInfoImpl;
/*     */ import org.jboss.reflect.plugins.AnnotationValueFactory;
/*     */ import org.jboss.reflect.plugins.ArrayInfoImpl;
/*     */ import org.jboss.reflect.plugins.ClassInfoHelper;
/*     */ import org.jboss.reflect.plugins.ClassInfoImpl;
/*     */ import org.jboss.reflect.plugins.ConstructorInfoImpl;
/*     */ import org.jboss.reflect.plugins.EnumConstantInfoImpl;
/*     */ import org.jboss.reflect.plugins.EnumInfoImpl;
/*     */ import org.jboss.reflect.plugins.FieldInfoImpl;
/*     */ import org.jboss.reflect.plugins.MethodInfoImpl;
/*     */ import org.jboss.reflect.plugins.PackageInfoImpl;
/*     */ import org.jboss.reflect.spi.AnnotationInfo;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ArrayInfo;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.InterfaceInfo;
/*     */ import org.jboss.reflect.spi.NumberInfo;
/*     */ import org.jboss.reflect.spi.PrimitiveInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.collection.WeakTypeCache;
/*     */ 
/*     */ public class IntrospectionTypeInfoFactoryImpl extends WeakTypeCache<TypeInfo>
/*     */   implements TypeInfoFactory, AnnotationHelper, ClassInfoHelper
/*     */ {
/*  69 */   static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];
/*     */ 
/*     */   public void generateTypeInfo(Class clazz, ClassInfoImpl info)
/*     */   {
/*     */   }
/*     */ 
/*     */   public ClassInfoImpl getSuperClass(ClassInfoImpl classInfo)
/*     */   {
/*  84 */     Class clazz = classInfo.getType();
/*  85 */     ClassInfoImpl superType = null;
/*  86 */     if (!clazz.isInterface())
/*     */     {
/*  88 */       Class superClazz = clazz.getSuperclass();
/*  89 */       if (superClazz != null)
/*  90 */         superType = (ClassInfoImpl)getTypeInfo(superClazz);
/*     */     }
/*  92 */     return superType;
/*     */   }
/*     */ 
/*     */   public ClassInfo getGenericSuperClass(ClassInfoImpl classInfo)
/*     */   {
/*  97 */     Class clazz = classInfo.getType();
/*  98 */     ClassInfo superType = null;
/*  99 */     if (!clazz.isInterface())
/*     */     {
/* 101 */       Type superClazz = clazz.getGenericSuperclass();
/* 102 */       if (superClazz != null)
/* 103 */         superType = (ClassInfo)getTypeInfo(superClazz);
/*     */     }
/* 105 */     return superType;
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations(Object obj)
/*     */   {
/*     */     Annotation[] annotations;
/* 111 */     if ((obj instanceof AnnotatedElement)) {
/* 112 */       annotations = readAnnotations((AnnotatedElement)obj);
/*     */     }
/*     */     else
/* 115 */       throw new RuntimeException("Attempt was made to read annotations from unsupported type " + obj.getClass().getName() + ": " + obj);
/*     */     Annotation[] annotations;
/* 118 */     if (annotations.length == 0)
/*     */     {
/* 120 */       return NO_ANNOTATIONS;
/*     */     }
/*     */ 
/* 123 */     AnnotationValue[] annotationValues = new AnnotationValue[annotations.length];
/* 124 */     for (int i = 0; i < annotations.length; i++)
/*     */     {
/* 126 */       AnnotationInfo info = (AnnotationInfo)getTypeInfo(annotations[i].annotationType());
/* 127 */       annotationValues[i] = createAnnotationValue(info, annotations[i]);
/*     */     }
/* 129 */     return annotationValues;
/*     */   }
/*     */ 
/*     */   public AnnotationValue createAnnotationValue(AnnotationInfo info, Object ann)
/*     */   {
/* 134 */     return AnnotationValueFactory.createAnnotationValue(this, this, info, ann);
/*     */   }
/*     */ 
/*     */   public ConstructorInfoImpl[] getConstructors(ClassInfoImpl classInfo)
/*     */   {
/* 139 */     Class clazz = classInfo.getType();
/* 140 */     ReflectConstructorInfoImpl[] infos = null;
/* 141 */     if (!clazz.isInterface())
/*     */     {
/* 143 */       Constructor[] constructors = getDeclaredConstructors(clazz);
/* 144 */       if ((constructors != null) && (constructors.length > 0))
/*     */       {
/* 146 */         infos = new ReflectConstructorInfoImpl[constructors.length];
/* 147 */         for (int i = 0; i < constructors.length; i++)
/*     */         {
/* 149 */           AnnotationValue[] annotations = getAnnotations(constructors[i]);
/*     */ 
/* 151 */           Type[] genericParameterTypes = constructors[i].getGenericParameterTypes();
/*     */ 
/* 155 */           Type[] parameterTypes = constructors[i].getParameterTypes();
/* 156 */           if (genericParameterTypes.length != parameterTypes.length) {
/* 157 */             genericParameterTypes = parameterTypes;
/*     */           }
/* 159 */           infos[i] = new ReflectConstructorInfoImpl(annotations, getTypeInfos(genericParameterTypes), getParameterAnnotations(constructors[i].getParameterAnnotations()), getClassInfos(constructors[i].getGenericExceptionTypes()), constructors[i].getModifiers(), (ClassInfo)getTypeInfo(constructors[i].getDeclaringClass()));
/* 160 */           infos[i].setConstructor(constructors[i]);
/*     */         }
/*     */       }
/*     */     }
/* 164 */     return infos;
/*     */   }
/*     */ 
/*     */   public FieldInfoImpl[] getFields(ClassInfoImpl classInfo)
/*     */   {
/* 169 */     Class clazz = classInfo.getType();
/* 170 */     Field[] fields = getDeclaredFields(clazz);
/* 171 */     if ((fields == null) || (fields.length == 0)) {
/* 172 */       return null;
/*     */     }
/* 174 */     ReflectFieldInfoImpl[] infos = new ReflectFieldInfoImpl[fields.length];
/* 175 */     for (int i = 0; i < fields.length; i++)
/*     */     {
/* 177 */       AnnotationValue[] annotations = getAnnotations(fields[i]);
/* 178 */       infos[i] = new ReflectFieldInfoImpl(annotations, fields[i].getName(), getTypeInfo(fields[i].getGenericType()), fields[i].getModifiers(), (ClassInfo)getTypeInfo(fields[i].getDeclaringClass()));
/* 179 */       infos[i].setField(fields[i]);
/*     */     }
/*     */ 
/* 182 */     return infos;
/*     */   }
/*     */ 
/*     */   public MethodInfoImpl[] getMethods(ClassInfoImpl classInfo)
/*     */   {
/* 187 */     Class clazz = classInfo.getType();
/* 188 */     Method[] methods = getDeclaredMethods(clazz);
/* 189 */     if ((methods == null) || (methods.length == 0)) {
/* 190 */       return null;
/*     */     }
/* 192 */     ReflectMethodInfoImpl[] infos = new ReflectMethodInfoImpl[methods.length];
/* 193 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 195 */       AnnotationValue[] annotations = getAnnotations(methods[i]);
/* 196 */       infos[i] = new ReflectMethodInfoImpl(annotations, methods[i].getName(), getTypeInfo(methods[i].getGenericReturnType()), getTypeInfos(methods[i].getGenericParameterTypes()), getParameterAnnotations(methods[i].getParameterAnnotations()), getClassInfos(methods[i].getGenericExceptionTypes()), methods[i].getModifiers(), (ClassInfo)getTypeInfo(methods[i].getDeclaringClass()));
/* 197 */       infos[i].setMethod(methods[i]);
/*     */     }
/* 199 */     return infos;
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getInterfaces(ClassInfoImpl classInfo)
/*     */   {
/* 204 */     Class clazz = classInfo.getType();
/* 205 */     Class[] interfaces = clazz.getInterfaces();
/* 206 */     if ((interfaces == null) || (interfaces.length == 0)) {
/* 207 */       return null;
/*     */     }
/* 209 */     InterfaceInfo[] infos = new InterfaceInfo[interfaces.length];
/* 210 */     for (int i = 0; i < interfaces.length; i++) {
/* 211 */       infos[i] = ((InterfaceInfo)getTypeInfo(interfaces[i]));
/*     */     }
/* 213 */     return infos;
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getGenericInterfaces(ClassInfoImpl classInfo)
/*     */   {
/* 218 */     Class clazz = classInfo.getType();
/* 219 */     Type[] interfaces = clazz.getGenericInterfaces();
/* 220 */     if ((interfaces == null) || (interfaces.length == 0)) {
/* 221 */       return null;
/*     */     }
/* 223 */     InterfaceInfo[] infos = new InterfaceInfo[interfaces.length];
/* 224 */     for (int i = 0; i < interfaces.length; i++) {
/* 225 */       infos[i] = ((InterfaceInfo)getTypeInfo(interfaces[i]));
/*     */     }
/* 227 */     return infos;
/*     */   }
/*     */ 
/*     */   public PackageInfoImpl getPackage(ClassInfoImpl classInfo)
/*     */   {
/* 232 */     Class clazz = classInfo.getType();
/* 233 */     Package pkg = clazz.getPackage();
/* 234 */     if (pkg == null) {
/* 235 */       return null;
/*     */     }
/* 237 */     AnnotationValue[] annotations = getAnnotations(pkg);
/* 238 */     return new PackageInfoImpl(pkg.getName(), annotations);
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getTypeInfos(Type[] classes)
/*     */   {
/* 249 */     if ((classes == null) || (classes.length == 0)) {
/* 250 */       return null;
/*     */     }
/* 252 */     TypeInfo[] result = new TypeInfo[classes.length];
/* 253 */     for (int i = 0; i < classes.length; i++)
/* 254 */       result[i] = getTypeInfo(classes[i]);
/* 255 */     return result;
/*     */   }
/*     */ 
/*     */   public ClassInfo[] getClassInfos(Type[] classes)
/*     */   {
/* 266 */     if ((classes == null) || (classes.length == 0)) {
/* 267 */       return null;
/*     */     }
/* 269 */     ClassInfo[] result = new ClassInfo[classes.length];
/* 270 */     for (int i = 0; i < classes.length; i++)
/* 271 */       result[i] = ((ClassInfo)getTypeInfo(classes[i]));
/* 272 */     return result;
/*     */   }
/*     */ 
/*     */   public TypeInfo getTypeInfo(Class clazz)
/*     */   {
/* 277 */     if (clazz == null) {
/* 278 */       throw new IllegalArgumentException("Null class");
/*     */     }
/* 280 */     TypeInfo primitive = PrimitiveInfo.valueOf(clazz.getName());
/* 281 */     if (primitive != null) {
/* 282 */       return primitive;
/*     */     }
/* 284 */     NumberInfo number = NumberInfo.valueOf(clazz.getName());
/* 285 */     if (number != null)
/*     */     {
/* 287 */       if (!number.isInitialized())
/*     */       {
/* 289 */         number.setDelegate((TypeInfo)get(clazz));
/*     */       }
/* 291 */       return number;
/*     */     }
/*     */ 
/* 294 */     return (TypeInfo)get(clazz);
/*     */   }
/*     */ 
/*     */   public TypeInfo getTypeInfo(Type type)
/*     */   {
/* 299 */     if (type == null) {
/* 300 */       throw new IllegalArgumentException("Null type");
/*     */     }
/* 302 */     String name = null;
/* 303 */     if ((type instanceof Class))
/* 304 */       name = ((Class)type).getName();
/* 305 */     if (name != null)
/*     */     {
/* 307 */       TypeInfo primitive = PrimitiveInfo.valueOf(name);
/* 308 */       if (primitive != null) {
/* 309 */         return primitive;
/*     */       }
/* 311 */       NumberInfo number = NumberInfo.valueOf(name);
/* 312 */       if (number != null)
/*     */       {
/* 314 */         if (!number.isInitialized())
/*     */         {
/* 316 */           number.setDelegate((TypeInfo)get(type));
/*     */         }
/* 318 */         return number;
/*     */       }
/*     */     }
/*     */ 
/* 322 */     return (TypeInfo)get(type);
/*     */   }
/*     */ 
/*     */   public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException
/*     */   {
/* 327 */     if (name == null) {
/* 328 */       throw new IllegalArgumentException("Null class name");
/*     */     }
/* 330 */     TypeInfo primitive = PrimitiveInfo.valueOf(name);
/* 331 */     if (primitive != null) {
/* 332 */       return primitive;
/*     */     }
/* 334 */     NumberInfo number = NumberInfo.valueOf(name);
/* 335 */     if (number != null)
/*     */     {
/* 337 */       if (!number.isInitialized())
/*     */       {
/* 339 */         number.setDelegate(resolveComplexTypeInfo(cl, name));
/*     */       }
/* 341 */       return number;
/*     */     }
/*     */ 
/* 344 */     return resolveComplexTypeInfo(cl, name);
/*     */   }
/*     */ 
/*     */   protected TypeInfo getGenericArrayType(GenericArrayType type)
/*     */   {
/* 356 */     Type compType = type.getGenericComponentType();
/* 357 */     TypeInfo componentType = getTypeInfo(compType);
/* 358 */     return new ArrayInfoImpl(componentType);
/*     */   }
/*     */ 
/*     */   private TypeInfo resolveComplexTypeInfo(ClassLoader cl, String name)
/*     */     throws ClassNotFoundException
/*     */   {
/* 364 */     if (cl == null) {
/* 365 */       cl = Thread.currentThread().getContextClassLoader();
/*     */     }
/* 367 */     Class clazz = cl.loadClass(name);
/* 368 */     return getTypeInfo(clazz);
/*     */   }
/*     */ 
/*     */   protected TypeInfo instantiate(Class<?> clazz)
/*     */   {
/*     */     ClassInfoImpl result;
/*     */     ClassInfoImpl result;
/* 374 */     if (clazz.isArray())
/*     */     {
/* 376 */       TypeInfo componentType = getTypeInfo(clazz.getComponentType());
/* 377 */       result = new ArrayInfoImpl(componentType);
/*     */     }
/* 379 */     else if (clazz.isEnum())
/*     */     {
/* 381 */       EnumInfoImpl enumInfoImpl = new EnumInfoImpl(clazz.getName(), clazz.getModifiers());
/* 382 */       ClassInfoImpl result = enumInfoImpl;
/* 383 */       Field[] fields = clazz.getFields();
/* 384 */       EnumConstantInfoImpl[] constants = new EnumConstantInfoImpl[fields.length];
/* 385 */       int i = 0;
/* 386 */       for (Field field : fields)
/*     */       {
/* 388 */         AnnotationValue[] annotations = getAnnotations(field);
/* 389 */         constants[(i++)] = new EnumConstantInfoImpl(field.getName(), enumInfoImpl, annotations);
/*     */       }
/* 391 */       enumInfoImpl.setEnumConstants(constants);
/*     */     }
/* 393 */     else if (clazz.isAnnotation())
/*     */     {
/* 395 */       ClassInfoImpl result = new AnnotationInfoImpl(clazz.getName(), clazz.getModifiers());
/* 396 */       Method[] methods = getDeclaredMethods(clazz);
/* 397 */       AnnotationAttributeImpl[] atttributes = new AnnotationAttributeImpl[methods.length];
/* 398 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 400 */         atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), getTypeInfo(methods[i].getReturnType()), null);
/*     */       }
/* 402 */       ((AnnotationInfoImpl)result).setAttributes(atttributes);
/*     */     }
/*     */     else
/*     */     {
/* 406 */       result = new ReflectClassInfoImpl(clazz.getName());
/*     */     }
/* 408 */     result.setType(clazz);
/* 409 */     result.setTypeInfoFactory(this);
/* 410 */     result.setClassInfoHelper(this);
/* 411 */     result.setAnnotationHelper(this);
/* 412 */     return result;
/*     */   }
/*     */ 
/*     */   protected TypeInfo instantiate(ParameterizedType type)
/*     */   {
/* 417 */     Class rawType = (Class)type.getRawType();
/* 418 */     ClassInfo rawTypeInfo = (ClassInfo)getTypeInfo(rawType);
/* 419 */     if ((rawTypeInfo instanceof ArrayInfo))
/* 420 */       return new ParameterizedArrayInfo(this, (ArrayInfo)rawTypeInfo, type);
/* 421 */     return new ParameterizedClassInfo(this, rawTypeInfo, type);
/*     */   }
/*     */ 
/*     */   protected void generate(Class<?> clazz, TypeInfo result)
/*     */   {
/* 426 */     generateTypeInfo(clazz, (ClassInfoImpl)result);
/*     */   }
/*     */ 
/*     */   protected void generate(ParameterizedType type, TypeInfo result)
/*     */   {
/*     */   }
/*     */ 
/*     */   protected Constructor[] getDeclaredConstructors(Class clazz)
/*     */   {
/* 436 */     if (System.getSecurityManager() == null) {
/* 437 */       return clazz.getDeclaredConstructors();
/*     */     }
/*     */ 
/* 440 */     PrivilegedAction action = new PrivilegedAction(clazz)
/*     */     {
/*     */       public Constructor[] run()
/*     */       {
/* 444 */         return this.val$clazz.getDeclaredConstructors();
/*     */       }
/*     */     };
/* 447 */     return (Constructor[])AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   protected Field[] getDeclaredFields(Class clazz)
/*     */   {
/* 453 */     if (System.getSecurityManager() == null) {
/* 454 */       return clazz.getDeclaredFields();
/*     */     }
/*     */ 
/* 457 */     PrivilegedAction action = new PrivilegedAction(clazz)
/*     */     {
/*     */       public Field[] run()
/*     */       {
/* 461 */         return this.val$clazz.getDeclaredFields();
/*     */       }
/*     */     };
/* 464 */     return (Field[])AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   protected Method[] getDeclaredMethods(Class clazz)
/*     */   {
/* 470 */     if (System.getSecurityManager() == null) {
/* 471 */       return clazz.getDeclaredMethods();
/*     */     }
/*     */ 
/* 474 */     PrivilegedAction action = new PrivilegedAction(clazz)
/*     */     {
/*     */       public Method[] run()
/*     */       {
/* 478 */         return this.val$clazz.getDeclaredMethods();
/*     */       }
/*     */     };
/* 481 */     return (Method[])AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   private Annotation[] readAnnotations(AnnotatedElement ao)
/*     */   {
/* 487 */     if (System.getSecurityManager() == null) {
/* 488 */       return ao.getAnnotations();
/*     */     }
/*     */ 
/* 491 */     PrivilegedAction action = new PrivilegedAction(ao)
/*     */     {
/*     */       public Annotation[] run()
/*     */       {
/* 495 */         return this.val$ao.getAnnotations();
/*     */       }
/*     */     };
/* 499 */     return (Annotation[])AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   protected AnnotationValue[][] getParameterAnnotations(Annotation[][] annotations)
/*     */   {
/* 505 */     AnnotationValue[][] annotationValues = new AnnotationValue[annotations.length][];
/* 506 */     for (int param = 0; param < annotations.length; param++)
/*     */     {
/* 508 */       annotationValues[param] = new AnnotationValue[annotations[param].length];
/* 509 */       for (int ann = 0; ann < annotations[param].length; ann++)
/*     */       {
/* 511 */         AnnotationInfo info = (AnnotationInfo)getTypeInfo(annotations[param][ann].annotationType());
/* 512 */         annotationValues[param][ann] = createAnnotationValue(info, annotations[param][ann]);
/*     */       }
/*     */     }
/* 515 */     return annotationValues;
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getActualTypeArguments(ParameterizedClassInfo classInfo)
/*     */   {
/* 520 */     ParameterizedType type = classInfo.parameterizedType;
/* 521 */     Type[] types = type.getActualTypeArguments();
/* 522 */     if (types == null) {
/* 523 */       return null;
/*     */     }
/* 525 */     TypeInfo[] result = new TypeInfo[types.length];
/* 526 */     for (int i = 0; i < types.length; i++) {
/* 527 */       result[i] = getTypeInfo(types[i]);
/*     */     }
/* 529 */     return result;
/*     */   }
/*     */ 
/*     */   public TypeInfo getOwnerType(ParameterizedClassInfo classInfo)
/*     */   {
/* 534 */     ParameterizedType type = classInfo.parameterizedType;
/* 535 */     Type owner = type.getOwnerType();
/* 536 */     if (owner == null) {
/* 537 */       return null;
/*     */     }
/* 539 */     return getTypeInfo(owner);
/*     */   }
/*     */ 
/*     */   public TypeInfo getComponentType(ClassInfo classInfo)
/*     */   {
/* 544 */     if (!classInfo.isCollection())
/* 545 */       return null;
/* 546 */     return findActualType(classInfo, Collection.class, 0);
/*     */   }
/*     */ 
/*     */   public TypeInfo getKeyType(ClassInfo classInfo)
/*     */   {
/* 551 */     if (!classInfo.isMap())
/* 552 */       return null;
/* 553 */     return findActualType(classInfo, Map.class, 0);
/*     */   }
/*     */ 
/*     */   public TypeInfo getValueType(ClassInfo classInfo)
/*     */   {
/* 558 */     if (!classInfo.isMap())
/* 559 */       return null;
/* 560 */     return findActualType(classInfo, Map.class, 1);
/*     */   }
/*     */ 
/*     */   protected TypeInfo findActualType(ClassInfo classInfo, Class reference, int parameter)
/*     */   {
/* 565 */     Type type = classInfo.getType();
/* 566 */     if ((classInfo instanceof ParameterizedClassInfo)) {
/* 567 */       type = ((ParameterizedClassInfo)classInfo).parameterizedType;
/*     */     }
/* 569 */     Type result = locateActualType(reference, parameter, classInfo.getType(), type);
/* 570 */     if ((result instanceof TypeVariable))
/*     */     {
/* 572 */       TypeVariable typeVariable = (TypeVariable)result;
/* 573 */       result = typeVariable.getBounds()[0];
/*     */     }
/* 575 */     return getTypeInfo(result);
/*     */   }
/*     */ 
/*     */   protected static Type locateActualType(Class reference, int parameter, Class clazz, Type type)
/*     */   {
/* 581 */     if (reference.equals(clazz))
/*     */     {
/* 583 */       if ((type instanceof Class))
/*     */       {
/* 585 */         Class typeClass = (Class)type;
/* 586 */         return typeClass.getTypeParameters()[parameter];
/*     */       }
/*     */ 
/* 590 */       ParameterizedType parameterized = (ParameterizedType)type;
/* 591 */       return parameterized.getActualTypeArguments()[parameter];
/*     */     }
/*     */ 
/* 595 */     Type[] interfaces = clazz.getGenericInterfaces();
/* 596 */     for (Type intf : interfaces)
/*     */     {
/*     */       Class interfaceClass;
/* 599 */       if ((intf instanceof Class))
/*     */       {
/* 601 */         interfaceClass = (Class)intf;
/*     */       }
/*     */       else
/*     */       {
/*     */         Class interfaceClass;
/* 603 */         if ((intf instanceof ParameterizedType))
/*     */         {
/* 605 */           ParameterizedType interfaceType = (ParameterizedType)intf;
/* 606 */           interfaceClass = (Class)interfaceType.getRawType();
/*     */         }
/*     */         else {
/* 609 */           throw new IllegalStateException("Unexpected type " + intf.getClass());
/*     */         }
/*     */       }
/*     */       Class interfaceClass;
/* 611 */       Type result = null;
/* 612 */       if (reference.isAssignableFrom(interfaceClass))
/*     */       {
/* 614 */         result = locateActualType(reference, parameter, interfaceClass, intf);
/* 615 */         if ((result instanceof TypeVariable))
/* 616 */           result = getParameter(clazz, type, (TypeVariable)result);
/*     */       }
/* 618 */       if (result != null) {
/* 619 */         return result;
/*     */       }
/*     */     }
/* 622 */     Class superClass = clazz.getSuperclass();
/* 623 */     Type genericSuperClass = clazz.getGenericSuperclass();
/* 624 */     Type result = locateActualType(reference, parameter, superClass, genericSuperClass);
/* 625 */     if ((result instanceof TypeVariable))
/* 626 */       result = getParameter(clazz, type, (TypeVariable)result);
/* 627 */     return result;
/*     */   }
/*     */ 
/*     */   private static Type getParameter(Class clazz, Type type, TypeVariable variable)
/*     */   {
/* 632 */     TypeVariable[] variables = clazz.getTypeParameters();
/* 633 */     for (int i = 0; i < variables.length; i++)
/*     */     {
/* 635 */       if (!variables[i].getName().equals(variable.getName()))
/*     */         continue;
/* 637 */       if ((type instanceof ParameterizedType))
/*     */       {
/* 639 */         ParameterizedType parameterized = (ParameterizedType)type;
/* 640 */         return parameterized.getActualTypeArguments()[i];
/*     */       }
/* 642 */       return variable;
/*     */     }
/*     */ 
/* 646 */     return Object.class;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactoryImpl
 * JD-Core Version:    0.6.0
 */