/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.plugins.introspection.ReflectionUtils;
/*     */ import org.jboss.reflect.spi.ProgressionConvertor;
/*     */ import org.jboss.reflect.spi.ProgressionConvertorFactory;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class ValueConvertor
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ValueConvertor.class);
/*     */ 
/*     */   public static Object convertValue(Class<? extends Object> clazz, Object value)
/*     */     throws Throwable
/*     */   {
/*  75 */     return convertValue(clazz, value, false);
/*     */   }
/*     */ 
/*     */   public static Object convertValue(Class<? extends Object> clazz, Object value, boolean replaceProperties)
/*     */     throws Throwable
/*     */   {
/*  90 */     return convertValue(clazz, value, replaceProperties, false);
/*     */   }
/*     */ 
/*     */   public static Object convertValue(Class<? extends Object> clazz, Object value, boolean replaceProperties, boolean trim)
/*     */     throws Throwable
/*     */   {
/* 106 */     if (clazz == null)
/* 107 */       throw new IllegalArgumentException("Null class");
/* 108 */     if (value == null) {
/* 109 */       return null;
/*     */     }
/* 111 */     Class valueClass = value.getClass();
/*     */ 
/* 114 */     if (valueClass == String.class)
/*     */     {
/* 116 */       String string = (String)value;
/* 117 */       if (trim)
/* 118 */         string = string.trim();
/* 119 */       if (replaceProperties) {
/* 120 */         value = StringPropertyReplacer.replaceProperties(string);
/*     */       }
/*     */     }
/* 123 */     if (clazz.isAssignableFrom(valueClass)) {
/* 124 */       return value;
/*     */     }
/*     */ 
/* 127 */     if (clazz.isEnum())
/*     */     {
/* 129 */       Class eclazz = clazz.asSubclass(Enum.class);
/* 130 */       return Enum.valueOf(eclazz, value.toString());
/*     */     }
/*     */ 
/* 134 */     if (valueClass == String.class)
/*     */     {
/* 136 */       PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
/* 137 */       if (editor != null)
/*     */       {
/* 139 */         editor.setAsText((String)value);
/* 140 */         return editor.getValue();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 147 */       Method method = clazz.getMethod("valueOf", new Class[] { valueClass });
/* 148 */       int modifiers = method.getModifiers();
/* 149 */       if ((Modifier.isPublic(modifiers)) && (Modifier.isStatic(modifiers)) && (clazz.isAssignableFrom(method.getReturnType())))
/*     */       {
/* 151 */         return ReflectionUtils.invoke(null, method, new Object[] { value });
/*     */       }
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/*     */ 
/* 158 */     if (valueClass == String.class)
/*     */     {
/*     */       try
/*     */       {
/* 162 */         Constructor constructor = clazz.getConstructor(new Class[] { valueClass });
/* 163 */         if (Modifier.isPublic(constructor.getModifiers())) {
/* 164 */           return ReflectionUtils.newInstance(constructor, new Object[] { value });
/*     */         }
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/* 171 */     return value;
/*     */   }
/*     */ 
/*     */   public static Object progressValue(Class<? extends Object> clazz, Object value)
/*     */     throws Throwable
/*     */   {
/* 185 */     if (value != null)
/*     */     {
/* 187 */       ProgressionConvertor convertor = ProgressionConvertorFactory.getInstance().getConvertor();
/* 188 */       if (convertor.canProgress(clazz, value.getClass()))
/*     */       {
/* 190 */         return convertor.doProgression(clazz, value);
/*     */       }
/*     */ 
/* 194 */       return null;
/*     */     }
/*     */ 
/* 197 */     return value;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  56 */       PropertyEditors.init();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  60 */       log.debug("Unable to initialise property editors", t);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.ValueConvertor
 * JD-Core Version:    0.6.0
 */