/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.Future;
/*     */ 
/*     */ public class TypeInfoAttachments
/*     */ {
/*     */   private transient Map<String, Object> attachments;
/*     */ 
/*     */   public void addAttachment(String name, Object attachment)
/*     */   {
/*  56 */     if (name == null)
/*  57 */       throw new IllegalArgumentException("Null name");
/*  58 */     if (attachment == null)
/*  59 */       return;
/*  60 */     synchronized (this)
/*     */     {
/*  62 */       if (this.attachments == null)
/*  63 */         this.attachments = new HashMap();
/*  64 */       this.attachments.put(name, attachment);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeAttachment(String name)
/*     */   {
/*  76 */     if (name == null)
/*  77 */       throw new IllegalArgumentException("Null name");
/*  78 */     synchronized (this)
/*     */     {
/*  80 */       if (this.attachments == null)
/*  81 */         return;
/*  82 */       this.attachments.remove(name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getAttachment(String name)
/*     */   {
/*  94 */     if (name == null)
/*  95 */       throw new IllegalArgumentException("Null name");
/*  96 */     Object result = null;
/*  97 */     synchronized (this)
/*     */     {
/*  99 */       if (this.attachments == null)
/* 100 */         return null;
/* 101 */       result = this.attachments.get(name);
/*     */     }
/* 103 */     if (result == null) {
/* 104 */       return null;
/*     */     }
/*     */ 
/* 107 */     if ((result instanceof Future))
/*     */     {
/*     */       try
/*     */       {
/* 111 */         return ((Future)result).get();
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 115 */         throw e;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 119 */         throw new RuntimeException("Error getting attachment from future " + result, e);
/*     */       }
/*     */     }
/* 122 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.TypeInfoAttachments
 * JD-Core Version:    0.6.0
 */