/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.util.concurrent.atomic.AtomicInteger;
/*     */ import java.util.concurrent.atomic.AtomicLong;
/*     */ import org.jboss.reflect.spi.ProgressionConvertor;
/*     */ 
/*     */ public class SimpleProgressionConvertor
/*     */   implements ProgressionConvertor
/*     */ {
/*     */   public boolean canProgress(Class<? extends Object> target, Class<? extends Object> source)
/*     */   {
/*  43 */     if ((target == null) || (source == null) || (BigInteger.class == target) || (BigDecimal.class == target))
/*     */     {
/*  45 */       return false;
/*     */     }
/*     */ 
/*  48 */     boolean ipnbt = (target.isPrimitive()) && (target != Boolean.TYPE) && (target != Character.TYPE);
/*  49 */     boolean ipnbs = (source.isPrimitive()) && (source != Boolean.TYPE) && (source != Character.TYPE);
/*  50 */     boolean targetIsNumber = Number.class.isAssignableFrom(target);
/*  51 */     boolean sourceIsNumber = Number.class.isAssignableFrom(source);
/*  52 */     return ((ipnbt) || (targetIsNumber)) && ((ipnbs) || (sourceIsNumber));
/*     */   }
/*     */ 
/*     */   public Object doProgression(Class<? extends Object> target, Object value) throws Throwable
/*     */   {
/*  57 */     if ((value == null) || (target == value.getClass()))
/*     */     {
/*  59 */       return value;
/*     */     }
/*  61 */     if (!canProgress(target, value.getClass()))
/*     */     {
/*  63 */       throw new IllegalArgumentException("This convertor only handles Numbers: " + target + "/" + value);
/*     */     }
/*     */ 
/*  66 */     Number source = (Number)value;
/*     */ 
/*  68 */     if ((Byte.class == target) || (Byte.TYPE == target))
/*     */     {
/*  70 */       return Byte.valueOf(source.byteValue());
/*     */     }
/*  72 */     if ((Double.class == target) || (Double.TYPE == target))
/*     */     {
/*  74 */       return Double.valueOf(source.doubleValue());
/*     */     }
/*  76 */     if ((Float.class == target) || (Float.TYPE == target))
/*     */     {
/*  78 */       return Float.valueOf(source.floatValue());
/*     */     }
/*  80 */     if ((Integer.class == target) || (Integer.TYPE == target))
/*     */     {
/*  82 */       return Integer.valueOf(source.intValue());
/*     */     }
/*  84 */     if ((Long.class == target) || (Long.TYPE == target))
/*     */     {
/*  86 */       return Long.valueOf(source.longValue());
/*     */     }
/*  88 */     if ((Short.class == target) || (Short.TYPE == target))
/*     */     {
/*  90 */       return Short.valueOf(source.shortValue());
/*     */     }
/*  92 */     if (AtomicInteger.class == target)
/*     */     {
/*  94 */       return new AtomicInteger(source.intValue());
/*     */     }
/*  96 */     if (AtomicLong.class == target)
/*     */     {
/*  98 */       return new AtomicLong(source.longValue());
/*     */     }
/*     */ 
/* 111 */     throw new IllegalArgumentException("Unsupported Number subclass: " + target);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.SimpleProgressionConvertor
 * JD-Core Version:    0.6.0
 */