/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Arrays;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public class MethodInfoImpl extends AnnotationHolder
/*     */   implements MethodInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3257007670035756341L;
/*     */   protected String name;
/*     */   protected ClassInfo declaringClass;
/*     */   protected TypeInfo[] parameterTypes;
/*     */   protected ParameterInfo[] parameters;
/*     */   protected ClassInfo[] exceptionTypes;
/*     */   protected int modifiers;
/*     */   protected TypeInfo returnType;
/*     */   protected int hash;
/*     */ 
/*     */   public MethodInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, TypeInfo[] parameterTypes, AnnotationValue[][] parameterAnnotations, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring)
/*     */   {
/*  91 */     super(annotations);
/*  92 */     this.name = name;
/*  93 */     if (parameterTypes == null)
/*     */     {
/*  95 */       this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
/*  96 */       this.parameters = MethodInfo.NO_PARAMS;
/*     */     }
/*     */     else
/*     */     {
/* 100 */       this.parameterTypes = parameterTypes;
/* 101 */       this.parameters = new ParameterInfoImpl[parameterTypes.length];
/* 102 */       for (int i = 0; i < parameterTypes.length; i++)
/* 103 */         this.parameters[i] = new ParameterInfoImpl(parameterAnnotations[i], null, parameterTypes[i]);
/*     */     }
/* 105 */     if (exceptionTypes == null)
/* 106 */       this.exceptionTypes = MethodInfo.NO_EXCEPTIONS;
/*     */     else
/* 108 */       this.exceptionTypes = exceptionTypes;
/* 109 */     this.modifiers = modifiers;
/* 110 */     this.declaringClass = declaring;
/* 111 */     this.returnType = returnType;
/* 112 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public MethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, ParameterInfo[] parameters, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring)
/*     */   {
/* 128 */     super(annotations);
/* 129 */     this.name = name;
/* 130 */     if ((parameters == null) || (parameters.length == 0))
/*     */     {
/* 132 */       this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
/* 133 */       this.parameters = MethodInfo.NO_PARAMS;
/*     */     }
/*     */     else
/*     */     {
/* 137 */       this.parameters = parameters;
/* 138 */       this.parameterTypes = new TypeInfo[parameters.length];
/* 139 */       for (int i = 0; i < parameters.length; i++)
/* 140 */         this.parameterTypes[i] = parameters[i].getParameterType();
/*     */     }
/* 142 */     if ((exceptionTypes == null) || (exceptionTypes.length == 0))
/* 143 */       this.exceptionTypes = MethodInfo.NO_EXCEPTIONS;
/*     */     else
/* 145 */       this.exceptionTypes = exceptionTypes;
/* 146 */     this.modifiers = modifiers;
/* 147 */     this.declaringClass = declaring;
/* 148 */     this.returnType = returnType;
/* 149 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 154 */     return this.name;
/*     */   }
/*     */ 
/*     */   public ClassInfo getDeclaringClass()
/*     */   {
/* 159 */     return this.declaringClass;
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getParameterTypes()
/*     */   {
/* 164 */     return this.parameterTypes;
/*     */   }
/*     */ 
/*     */   public ParameterInfo[] getParameters()
/*     */   {
/* 169 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public ClassInfo[] getExceptionTypes()
/*     */   {
/* 174 */     return this.exceptionTypes;
/*     */   }
/*     */ 
/*     */   public TypeInfo getReturnType()
/*     */   {
/* 179 */     return this.returnType;
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/* 184 */     return this.modifiers;
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/* 189 */     return Modifier.isStatic(this.modifiers);
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/* 194 */     return Modifier.isPublic(this.modifiers);
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 199 */     return Modifier.isVolatile(this.modifiers);
/*     */   }
/*     */ 
/*     */   public Object invoke(Object target, Object[] args) throws Throwable
/*     */   {
/* 204 */     throw new NotImplementedException("invoke");
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 209 */     buffer.append("name=").append(this.name);
/* 210 */     buffer.append(Arrays.asList(this.parameterTypes));
/* 211 */     buffer.append(" return=").append(this.returnType);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 216 */     buffer.append(this.name);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 221 */     if (this == obj) return true;
/* 222 */     if ((obj == null) || (!(obj instanceof MethodInfo))) {
/* 223 */       return false;
/*     */     }
/* 225 */     MethodInfo other = (MethodInfo)obj;
/*     */ 
/* 227 */     if (!this.name.equals(other.getName()))
/* 228 */       return false;
/* 229 */     return Arrays.equals(this.parameterTypes, other.getParameterTypes());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 234 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 242 */     this.hash = this.name.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.MethodInfoImpl
 * JD-Core Version:    0.6.0
 */