/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.lang.annotation.Inherited;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.reflect.spi.AnnotationInfo;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ 
/*     */ public abstract class InheritableAnnotationHolder extends AbstractAnnotatedInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3257290210164289843L;
/*  43 */   private static final String INHERITED_NAME = Inherited.class.getName();
/*     */ 
/*  46 */   static final Map<String, AnnotationValue> UNKNOWN_ANNOTATIONS_MAP = Collections.unmodifiableMap(new HashMap());
/*     */ 
/*  49 */   static final AnnotationValue[] UNKNOWN_ANNOTATIONS = new AnnotationValue[0];
/*     */ 
/*  52 */   protected Map<String, AnnotationValue> declaredAnnotations = UNKNOWN_ANNOTATIONS_MAP;
/*     */ 
/*  55 */   protected Map<String, AnnotationValue> allAnnotations = UNKNOWN_ANNOTATIONS_MAP;
/*     */ 
/*  58 */   protected AnnotationValue[] allAnnotationsArray = UNKNOWN_ANNOTATIONS;
/*     */ 
/*  61 */   protected AnnotationValue[] declaredAnnotationsArray = UNKNOWN_ANNOTATIONS;
/*     */   protected Object annotatedElement;
/*     */   protected transient AnnotationHelper annotationHelper;
/*     */ 
/*     */   public void setAnnotatedElement(Object annotatedElement)
/*     */   {
/*  78 */     this.annotatedElement = annotatedElement;
/*     */   }
/*     */ 
/*     */   public void setAnnotationHelper(AnnotationHelper annotationHelper)
/*     */   {
/*  83 */     this.annotationHelper = annotationHelper;
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getDeclaredAnnotations()
/*     */   {
/*  93 */     if (this.declaredAnnotationsArray == UNKNOWN_ANNOTATIONS)
/*  94 */       setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
/*  95 */     return this.declaredAnnotationsArray;
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 100 */     if (this.allAnnotationsArray == UNKNOWN_ANNOTATIONS)
/* 101 */       setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
/* 102 */     return this.allAnnotationsArray;
/*     */   }
/*     */ 
/*     */   public AnnotationValue getAnnotation(String name)
/*     */   {
/* 107 */     if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP)
/* 108 */       setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
/* 109 */     return (AnnotationValue)this.allAnnotations.get(name);
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(String name)
/*     */   {
/* 114 */     if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP)
/* 115 */       setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
/* 116 */     return this.allAnnotations.containsKey(name);
/*     */   }
/*     */ 
/*     */   public void setupAnnotations(AnnotationValue[] annotations)
/*     */   {
/* 126 */     InheritableAnnotationHolder superHolder = getSuperHolder();
/* 127 */     AnnotationValue[] superAllAnnotations = superHolder != null ? superHolder.getAnnotations() : null;
/*     */ 
/* 129 */     if ((annotations != null) && (annotations.length > 0))
/*     */     {
/* 131 */       this.declaredAnnotations = new HashMap();
/* 132 */       this.declaredAnnotationsArray = annotations;
/* 133 */       for (int i = 0; i < annotations.length; i++)
/* 134 */         this.declaredAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
/* 135 */       this.allAnnotations = new HashMap();
/*     */ 
/* 137 */       if ((superHolder != null) && (superAllAnnotations != null) && (superAllAnnotations.length != 0))
/*     */       {
/* 139 */         for (int i = 0; i < superAllAnnotations.length; i++)
/*     */         {
/* 141 */           AnnotationValue av = superAllAnnotations[i];
/* 142 */           if (!av.getAnnotationType().isAnnotationPresent(INHERITED_NAME))
/*     */             continue;
/* 144 */           this.allAnnotations.put(av.getAnnotationType().getName(), av);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 149 */         this.allAnnotationsArray = this.declaredAnnotationsArray;
/*     */       }
/* 151 */       for (int i = 0; i < annotations.length; i++) {
/* 152 */         this.allAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
/*     */       }
/* 154 */       this.allAnnotationsArray = ((AnnotationValue[])this.allAnnotations.values().toArray(new AnnotationValue[this.allAnnotations.size()]));
/*     */     }
/* 158 */     else if (superHolder != null)
/*     */     {
/* 160 */       this.allAnnotations = superHolder.getAllAnnotations();
/* 161 */       this.allAnnotationsArray = superAllAnnotations;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Map<String, AnnotationValue> getAllAnnotations()
/*     */   {
/* 173 */     if (this.allAnnotations == UNKNOWN_ANNOTATIONS_MAP)
/* 174 */       setupAnnotations(this.annotationHelper.getAnnotations(this.annotatedElement));
/* 175 */     return this.allAnnotations;
/*     */   }
/*     */ 
/*     */   protected abstract InheritableAnnotationHolder getSuperHolder();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.InheritableAnnotationHolder
 * JD-Core Version:    0.6.0
 */