/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Arrays;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public class ConstructorInfoImpl extends AnnotationHolder
/*     */   implements ConstructorInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3256727273163272758L;
/*     */   protected ClassInfo declaringClass;
/*     */   protected TypeInfo[] parameterTypes;
/*     */   protected ParameterInfo[] parameters;
/*     */   protected ClassInfo[] exceptionTypes;
/*     */   protected int modifiers;
/*     */   protected int hash;
/*     */ 
/*     */   public ConstructorInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ConstructorInfoImpl(AnnotationValue[] annotations, TypeInfo[] parameterTypes, AnnotationValue[][] parameterAnnotations, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring)
/*     */   {
/*  84 */     super(annotations);
/*  85 */     if (parameterTypes == null)
/*     */     {
/*  87 */       this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
/*  88 */       this.parameters = MethodInfo.NO_PARAMS;
/*     */     }
/*     */     else
/*     */     {
/*  92 */       this.parameterTypes = parameterTypes;
/*  93 */       this.parameters = new ParameterInfoImpl[parameterTypes.length];
/*  94 */       for (int i = 0; i < parameterTypes.length; i++)
/*  95 */         this.parameters[i] = new ParameterInfoImpl(parameterAnnotations[i], null, parameterTypes[i]);
/*     */     }
/*  97 */     if (exceptionTypes == null)
/*  98 */       this.exceptionTypes = MethodInfo.NO_EXCEPTIONS;
/*     */     else
/* 100 */       this.exceptionTypes = exceptionTypes;
/* 101 */     this.modifiers = modifiers;
/* 102 */     this.declaringClass = declaring;
/* 103 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public ConstructorInfoImpl(AnnotationValue[] annotations, ParameterInfo[] parameters, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring)
/*     */   {
/* 117 */     super(annotations);
/* 118 */     if ((parameters == null) || (parameters.length == 0))
/*     */     {
/* 120 */       this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
/* 121 */       this.parameters = MethodInfo.NO_PARAMS;
/*     */     }
/*     */     else
/*     */     {
/* 125 */       this.parameters = parameters;
/* 126 */       this.parameterTypes = new TypeInfo[parameters.length];
/* 127 */       for (int i = 0; i < parameters.length; i++)
/* 128 */         this.parameterTypes[i] = parameters[i].getParameterType();
/*     */     }
/* 130 */     if ((exceptionTypes == null) || (exceptionTypes.length == 0))
/* 131 */       this.exceptionTypes = MethodInfo.NO_EXCEPTIONS;
/*     */     else
/* 133 */       this.exceptionTypes = exceptionTypes;
/* 134 */     this.modifiers = modifiers;
/* 135 */     this.declaringClass = declaring;
/* 136 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public ClassInfo getDeclaringClass()
/*     */   {
/* 141 */     return this.declaringClass;
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getParameterTypes()
/*     */   {
/* 146 */     return this.parameterTypes;
/*     */   }
/*     */ 
/*     */   public ParameterInfo[] getParameters()
/*     */   {
/* 151 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public ClassInfo[] getExceptionTypes()
/*     */   {
/* 156 */     return this.exceptionTypes;
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/* 161 */     return this.modifiers;
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/* 166 */     return Modifier.isStatic(this.modifiers);
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/* 171 */     return Modifier.isPublic(this.modifiers);
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 176 */     return Modifier.isVolatile(this.modifiers);
/*     */   }
/*     */ 
/*     */   public Object newInstance(Object[] args) throws Throwable
/*     */   {
/* 181 */     throw new NotImplementedException("newInstance");
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 186 */     buffer.append(Arrays.asList(this.parameterTypes));
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 191 */     if (this == obj)
/* 192 */       return true;
/* 193 */     if ((obj == null) || (!(obj instanceof ConstructorInfo))) {
/* 194 */       return false;
/*     */     }
/* 196 */     ConstructorInfo other = (ConstructorInfo)obj;
/*     */ 
/* 198 */     if (!this.declaringClass.equals(other.getDeclaringClass()))
/* 199 */       return false;
/* 200 */     return Arrays.equals(this.parameterTypes, other.getParameterTypes());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 205 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 210 */     int result = this.declaringClass.hashCode();
/* 211 */     if (this.parameterTypes != null)
/*     */     {
/* 213 */       for (int i = 0; i < this.parameterTypes.length; i++)
/*     */       {
/* 215 */         result = 29 * result + this.parameterTypes[i].hashCode();
/*     */       }
/*     */     }
/* 218 */     this.hash = result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.ConstructorInfoImpl
 * JD-Core Version:    0.6.0
 */