/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import org.jboss.reflect.spi.AbstractValue;
/*     */ import org.jboss.reflect.spi.ClassValue;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class ClassValueImpl extends AbstractValue
/*     */   implements ClassValue
/*     */ {
/*     */   private static final long serialVersionUID = 3256721801307566649L;
/*     */   protected String value;
/*     */   protected TypeInfo type;
/*  46 */   protected int hash = -1;
/*     */ 
/*     */   public ClassValueImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ClassValueImpl(String value, TypeInfo type)
/*     */   {
/*  63 */     this.value = value;
/*  64 */     this.type = type;
/*  65 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public boolean isArray()
/*     */   {
/*  71 */     return true;
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/*  76 */     return this.value;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/*  81 */     return this.type;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*  86 */     if (this == o) return true;
/*  87 */     if (!(o instanceof ClassValueImpl)) return false;
/*     */ 
/*  89 */     ClassValueImpl classValue = (ClassValueImpl)o;
/*     */ 
/*  91 */     if (!this.type.equals(classValue.type)) return false;
/*  92 */     return this.value.equals(classValue.value);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  97 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 105 */     int result = this.value != null ? this.value.hashCode() : 0;
/* 106 */     result = 29 * result + this.type.hashCode();
/* 107 */     this.hash = result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.ClassValueImpl
 * JD-Core Version:    0.6.0
 */