/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.DelegateClassInfo;
/*     */ import org.jboss.reflect.spi.FieldInfo;
/*     */ import org.jboss.reflect.spi.InterfaceInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.PackageInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class ClassInfoImpl extends InheritableAnnotationHolder
/*     */   implements ClassInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3545798779904340792L;
/*  54 */   public static final ClassInfo UNKNOWN_CLASS = new DelegateClassInfo(null, true);
/*     */ 
/*  57 */   public static final ClassInfo[] UNKNOWN_CLASSES = new ClassInfo[0];
/*     */ 
/*  60 */   public static final TypeInfo UNKNOWN_TYPE = UNKNOWN_CLASS;
/*     */ 
/*  63 */   public static final TypeInfo[] UNKNOWN_TYPES = new TypeInfo[0];
/*     */ 
/*  66 */   public static final InterfaceInfo[] UNKNOWN_INTERFACES = new InterfaceInfo[0];
/*     */ 
/*  69 */   public static final ConstructorInfo[] UNKNOWN_CONSTRUCTORS = new ConstructorInfo[0];
/*     */ 
/*  72 */   public static final MethodInfo[] UNKNOWN_METHODS = new MethodInfo[0];
/*     */ 
/*  75 */   public static final FieldInfo[] UNKNOWN_FIELDS = new FieldInfo[0];
/*     */   protected String name;
/*     */   protected int modifiers;
/*  84 */   protected InterfaceInfo[] interfaces = UNKNOWN_INTERFACES;
/*     */ 
/*  87 */   protected InterfaceInfo[] genericInterfaces = UNKNOWN_INTERFACES;
/*     */ 
/*  90 */   protected MethodInfo[] methods = UNKNOWN_METHODS;
/*     */ 
/*  93 */   protected FieldInfo[] fields = UNKNOWN_FIELDS;
/*     */   protected HashMap<String, FieldInfo> fieldMap;
/*  99 */   protected ClassInfo superclass = UNKNOWN_CLASS;
/*     */ 
/* 102 */   protected ClassInfo genericSuperclass = UNKNOWN_CLASS;
/*     */ 
/* 105 */   protected ConstructorInfo[] constructors = UNKNOWN_CONSTRUCTORS;
/*     */   protected PackageInfo packageInfo;
/* 111 */   private transient TypeInfo componentType = UNKNOWN_TYPE;
/*     */ 
/* 114 */   private transient TypeInfo keyType = UNKNOWN_TYPE;
/*     */ 
/* 117 */   private transient TypeInfo valueType = UNKNOWN_TYPE;
/*     */   protected transient ClassInfoHelper classInfoHelper;
/*     */   protected transient TypeInfoFactory typeInfoFactory;
/*     */   private transient TypeInfoAttachments attachments;
/*     */ 
/*     */   public ClassInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ClassInfoImpl(String name)
/*     */   {
/* 142 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public ClassInfoImpl(String name, int modifiers)
/*     */   {
/* 153 */     this.name = name;
/* 154 */     this.modifiers = modifiers;
/*     */   }
/*     */ 
/*     */   public ClassInfoImpl(String name, int modifiers, InterfaceInfo[] interfaces, ClassInfoImpl superclass)
/*     */   {
/* 168 */     this.name = name;
/* 169 */     this.modifiers = modifiers;
/* 170 */     this.interfaces = interfaces;
/* 171 */     this.superclass = superclass;
/*     */   }
/*     */ 
/*     */   public TypeInfoFactory getTypeInfoFactory()
/*     */   {
/* 176 */     return this.typeInfoFactory;
/*     */   }
/*     */ 
/*     */   public void setTypeInfoFactory(TypeInfoFactory typeInfoFactory)
/*     */   {
/* 181 */     this.typeInfoFactory = typeInfoFactory;
/*     */   }
/*     */ 
/*     */   public void setClassInfoHelper(ClassInfoHelper classInfoHelper)
/*     */   {
/* 186 */     this.classInfoHelper = classInfoHelper;
/*     */   }
/*     */ 
/*     */   public static MethodInfo findMethod(MethodInfo[] methods, String name, TypeInfo[] parameters)
/*     */   {
/* 199 */     if (methods == null) return null;
/* 200 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 202 */       if (!methods[i].getName().equals(name))
/*     */         continue;
/* 204 */       int length = parameters != null ? parameters.length : 0;
/* 205 */       if (methods[i].getParameterTypes().length != length)
/*     */         continue;
/* 207 */       boolean ok = true;
/* 208 */       for (int j = 0; j < length; j++)
/*     */       {
/* 210 */         if (parameters[j].equals(methods[i].getParameterTypes()[j]))
/*     */           continue;
/* 212 */         ok = false;
/* 213 */         break;
/*     */       }
/*     */ 
/* 216 */       if (ok) return methods[i];
/*     */ 
/*     */     }
/*     */ 
/* 220 */     return null;
/*     */   }
/*     */ 
/*     */   public static ConstructorInfo findConstructor(ConstructorInfo[] constructors, TypeInfo[] parameters)
/*     */   {
/* 232 */     if (constructors == null) return null;
/* 233 */     for (int i = 0; i < constructors.length; i++)
/*     */     {
/* 235 */       int length = parameters != null ? parameters.length : 0;
/* 236 */       if (constructors[i].getParameterTypes().length != length)
/*     */         continue;
/* 238 */       boolean ok = true;
/* 239 */       for (int j = 0; j < length; j++)
/*     */       {
/* 241 */         if (parameters[j].equals(constructors[i].getParameterTypes()[j]))
/*     */           continue;
/* 243 */         ok = false;
/* 244 */         break;
/*     */       }
/*     */ 
/* 247 */       if (ok) return constructors[i];
/*     */     }
/*     */ 
/* 250 */     return null;
/*     */   }
/*     */ 
/*     */   public static Class getArrayClass(Class clazz)
/*     */   {
/* 261 */     return Array.newInstance(clazz, 0).getClass();
/*     */   }
/*     */ 
/*     */   public void setType(Class type)
/*     */   {
/* 271 */     setAnnotatedElement(type);
/* 272 */     if (type != null)
/* 273 */       this.modifiers = type.getModifiers();
/*     */   }
/*     */ 
/*     */   public void setInterfaces(InterfaceInfo[] interfaces)
/*     */   {
/* 283 */     this.interfaces = interfaces;
/*     */   }
/*     */ 
/*     */   public void setGenericInterfaces(InterfaceInfo[] interfaces)
/*     */   {
/* 293 */     this.genericInterfaces = interfaces;
/*     */   }
/*     */ 
/*     */   public void setDeclaredMethods(MethodInfoImpl[] methods)
/*     */   {
/* 303 */     this.methods = methods;
/* 304 */     if (methods != null)
/*     */     {
/* 306 */       for (int i = 0; i < methods.length; i++)
/* 307 */         methods[i].declaringClass = this;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDeclaredFields(FieldInfoImpl[] fields)
/*     */   {
/* 318 */     this.fields = fields;
/* 319 */     if (fields != null)
/*     */     {
/* 321 */       this.fieldMap = new HashMap();
/* 322 */       for (int i = 0; i < fields.length; i++)
/*     */       {
/* 324 */         fields[i].declaringClass = this;
/* 325 */         this.fieldMap.put(fields[i].getName(), fields[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setDeclaredConstructors(ConstructorInfoImpl[] constructors)
/*     */   {
/* 337 */     this.constructors = constructors;
/* 338 */     if (constructors != null)
/*     */     {
/* 340 */       for (int i = 0; i < constructors.length; i++)
/* 341 */         constructors[i].declaringClass = this;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setSuperclass(ClassInfoImpl superInfo)
/*     */   {
/* 352 */     this.superclass = superInfo;
/*     */   }
/*     */ 
/*     */   public void setGenericSuperclass(ClassInfo superInfo)
/*     */   {
/* 362 */     this.genericSuperclass = superInfo;
/*     */   }
/*     */ 
/*     */   public boolean isInterface()
/*     */   {
/* 367 */     return false;
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getInterfaces()
/*     */   {
/* 372 */     if (this.interfaces == UNKNOWN_INTERFACES)
/* 373 */       setInterfaces(this.classInfoHelper.getInterfaces(this));
/* 374 */     return this.interfaces;
/*     */   }
/*     */ 
/*     */   public InterfaceInfo[] getGenericInterfaces()
/*     */   {
/* 379 */     if (this.genericInterfaces == UNKNOWN_INTERFACES)
/* 380 */       setGenericInterfaces(this.classInfoHelper.getGenericInterfaces(this));
/* 381 */     return this.genericInterfaces;
/*     */   }
/*     */ 
/*     */   public MethodInfo getDeclaredMethod(String name, TypeInfo[] parameters)
/*     */   {
/* 386 */     if (this.methods == UNKNOWN_METHODS)
/* 387 */       setDeclaredMethods(this.classInfoHelper.getMethods(this));
/* 388 */     return findMethod(this.methods, name, parameters);
/*     */   }
/*     */ 
/*     */   public MethodInfo[] getDeclaredMethods()
/*     */   {
/* 393 */     if (this.methods == UNKNOWN_METHODS)
/* 394 */       setDeclaredMethods(this.classInfoHelper.getMethods(this));
/* 395 */     return this.methods;
/*     */   }
/*     */ 
/*     */   public FieldInfo getDeclaredField(String name)
/*     */   {
/* 400 */     if (this.fields == UNKNOWN_FIELDS)
/* 401 */       setDeclaredFields(this.classInfoHelper.getFields(this));
/* 402 */     if (this.fieldMap == null)
/* 403 */       return null;
/* 404 */     return (FieldInfo)this.fieldMap.get(name);
/*     */   }
/*     */ 
/*     */   public FieldInfo[] getDeclaredFields()
/*     */   {
/* 409 */     if (this.fields == UNKNOWN_FIELDS)
/* 410 */       setDeclaredFields(this.classInfoHelper.getFields(this));
/* 411 */     return this.fields;
/*     */   }
/*     */ 
/*     */   public ConstructorInfo getDeclaredConstructor(TypeInfo[] parameters)
/*     */   {
/* 416 */     if (this.methods == UNKNOWN_METHODS)
/* 417 */       setDeclaredConstructors(this.classInfoHelper.getConstructors(this));
/* 418 */     return findConstructor(this.constructors, parameters);
/*     */   }
/*     */ 
/*     */   public ConstructorInfo[] getDeclaredConstructors()
/*     */   {
/* 423 */     if (this.constructors == UNKNOWN_CONSTRUCTORS)
/* 424 */       setDeclaredConstructors(this.classInfoHelper.getConstructors(this));
/* 425 */     return this.constructors;
/*     */   }
/*     */ 
/*     */   public ClassInfo getSuperclass()
/*     */   {
/* 430 */     if (this.superclass == UNKNOWN_CLASS)
/* 431 */       setSuperclass(this.classInfoHelper.getSuperClass(this));
/* 432 */     return this.superclass;
/*     */   }
/*     */ 
/*     */   public ClassInfo getGenericSuperclass()
/*     */   {
/* 437 */     if (this.genericSuperclass == UNKNOWN_CLASS)
/* 438 */       setGenericSuperclass(this.classInfoHelper.getGenericSuperClass(this));
/* 439 */     return this.genericSuperclass;
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/* 444 */     return this.modifiers;
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/* 449 */     return Modifier.isStatic(this.modifiers);
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/* 454 */     return Modifier.isPublic(this.modifiers);
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 459 */     return Modifier.isVolatile(this.modifiers);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 464 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */   {
/* 469 */     return getType().getSimpleName();
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Class<? extends Object> getType() {
/* 475 */     return (Class)this.annotatedElement;
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value) throws Throwable
/*     */   {
/* 480 */     return ValueConvertor.convertValue(getType(), value);
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value, boolean replaceProperties) throws Throwable
/*     */   {
/* 485 */     return ValueConvertor.convertValue(getType(), value, replaceProperties);
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable
/*     */   {
/* 490 */     return ValueConvertor.convertValue(getType(), value, replaceProperties, trim);
/*     */   }
/*     */ 
/*     */   public boolean isArray()
/*     */   {
/* 495 */     return getType().isArray();
/*     */   }
/*     */ 
/*     */   public boolean isCollection()
/*     */   {
/* 500 */     return Collection.class.isAssignableFrom(getType());
/*     */   }
/*     */ 
/*     */   public boolean isMap()
/*     */   {
/* 505 */     return Map.class.isAssignableFrom(getType());
/*     */   }
/*     */ 
/*     */   public boolean isAnnotation()
/*     */   {
/* 510 */     return getType().isAnnotation();
/*     */   }
/*     */ 
/*     */   public boolean isEnum()
/*     */   {
/* 515 */     return getType().isEnum();
/*     */   }
/*     */ 
/*     */   public boolean isPrimitive()
/*     */   {
/* 520 */     return false;
/*     */   }
/*     */ 
/*     */   public TypeInfo getArrayType()
/*     */   {
/* 525 */     Class arrayClass = getArrayClass(getType());
/* 526 */     return this.classInfoHelper.getTypeInfo(arrayClass);
/*     */   }
/*     */ 
/*     */   public Object newArrayInstance(int size) throws Throwable
/*     */   {
/* 531 */     if (!isArray())
/* 532 */       throw new ClassCastException(this + " is not an array.");
/* 533 */     return Array.newInstance(getComponentType().getType(), size);
/*     */   }
/*     */ 
/*     */   public boolean isAssignableFrom(TypeInfo info)
/*     */   {
/* 538 */     if (info == null)
/*     */     {
/* 540 */       throw new NullPointerException("Parameter info cannot be null!");
/*     */     }
/* 542 */     return getType().isAssignableFrom(info.getType());
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getActualTypeArguments()
/*     */   {
/* 547 */     return null;
/*     */   }
/*     */ 
/*     */   public TypeInfo getOwnerType()
/*     */   {
/* 552 */     return null;
/*     */   }
/*     */ 
/*     */   public ClassInfo getRawType()
/*     */   {
/* 557 */     return this;
/*     */   }
/*     */ 
/*     */   public TypeInfo getComponentType()
/*     */   {
/* 562 */     if (this.componentType == UNKNOWN_TYPE)
/* 563 */       this.componentType = this.classInfoHelper.getComponentType(this);
/* 564 */     return this.componentType;
/*     */   }
/*     */ 
/*     */   public TypeInfo getKeyType()
/*     */   {
/* 569 */     if (this.keyType == UNKNOWN_TYPE)
/* 570 */       this.keyType = this.classInfoHelper.getKeyType(this);
/* 571 */     return this.keyType;
/*     */   }
/*     */ 
/*     */   public TypeInfo getValueType()
/*     */   {
/* 576 */     if (this.valueType == UNKNOWN_TYPE)
/* 577 */       this.valueType = this.classInfoHelper.getValueType(this);
/* 578 */     return this.valueType;
/*     */   }
/*     */ 
/*     */   public PackageInfo getPackage()
/*     */   {
/* 583 */     if (this.packageInfo == null)
/* 584 */       this.packageInfo = this.classInfoHelper.getPackage(this);
/* 585 */     return this.packageInfo;
/*     */   }
/*     */ 
/*     */   public void setAttachment(String name, Object attachment)
/*     */   {
/* 590 */     if (name == null)
/* 591 */       throw new IllegalArgumentException("Null name");
/* 592 */     synchronized (this)
/*     */     {
/* 594 */       if (this.attachments == null)
/*     */       {
/* 596 */         if (attachment == null)
/* 597 */           return;
/* 598 */         this.attachments = new TypeInfoAttachments();
/*     */       }
/*     */     }
/* 601 */     if (attachment == null)
/* 602 */       this.attachments.removeAttachment(name);
/*     */     else
/* 604 */       this.attachments.addAttachment(name, attachment);
/*     */   }
/*     */ 
/*     */   public <T> T getAttachment(Class<T> expectedType)
/*     */   {
/* 609 */     if (expectedType == null)
/* 610 */       throw new IllegalArgumentException("Null expectedType");
/* 611 */     Object result = getAttachment(expectedType.getName());
/* 612 */     if (result == null)
/* 613 */       return null;
/* 614 */     return expectedType.cast(result);
/*     */   }
/*     */ 
/*     */   public Object getAttachment(String name)
/*     */   {
/* 619 */     if (name == null)
/* 620 */       throw new IllegalArgumentException("Null name");
/* 621 */     synchronized (this)
/*     */     {
/* 623 */       if (this.attachments == null)
/* 624 */         return null;
/*     */     }
/* 626 */     return this.attachments.getAttachment(name);
/*     */   }
/*     */ 
/*     */   protected InheritableAnnotationHolder getSuperHolder()
/*     */   {
/* 632 */     return (ClassInfoImpl)getSuperclass();
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 638 */     buffer.append("name=").append(getName());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 644 */     if (this == obj)
/* 645 */       return true;
/* 646 */     if ((obj == null) || (!(obj instanceof ClassInfo))) {
/* 647 */       return false;
/*     */     }
/* 649 */     ClassInfo other = (ClassInfo)obj;
/*     */ 
/* 651 */     String name = getName();
/*     */ 
/* 653 */     return name != null ? name.equals(other.getName()) : other.getName() == null;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 660 */     return this.name != null ? this.name.hashCode() : 0;
/*     */   }
/*     */ 
/*     */   Object readResolve()
/*     */   {
/* 665 */     TypeInfoFactory typeInfoFactory = SerializationHelper.getTypeInfoFactory();
/* 666 */     return typeInfoFactory.getTypeInfo(getType());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.ClassInfoImpl
 * JD-Core Version:    0.6.0
 */