/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import org.jboss.reflect.spi.AbstractValue;
/*     */ import org.jboss.reflect.spi.ArrayValue;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.Value;
/*     */ 
/*     */ public class ArrayValueImpl extends AbstractValue
/*     */   implements ArrayValue
/*     */ {
/*     */   private static final long serialVersionUID = 3979266949899367475L;
/*     */   protected TypeInfo type;
/*     */   protected Value[] values;
/*  49 */   protected int hash = -1;
/*     */ 
/*     */   public ArrayValueImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ArrayValueImpl(TypeInfo type, Value[] values)
/*     */   {
/*  66 */     this.type = type;
/*  67 */     this.values = values;
/*  68 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public boolean isArray()
/*     */   {
/*  75 */     return true;
/*     */   }
/*     */ 
/*     */   public Value[] getValues()
/*     */   {
/*  80 */     return this.values;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/*  85 */     return this.type;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*  90 */     if (this == o) return true;
/*  91 */     if (!(o instanceof ArrayValueImpl)) return false;
/*     */ 
/*  93 */     ArrayValueImpl arrayValue = (ArrayValueImpl)o;
/*     */ 
/*  95 */     if (!this.type.equals(arrayValue.type)) return false;
/*  96 */     return Arrays.equals(this.values, arrayValue.values);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 103 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 111 */     this.hash = Arrays.hashCode(this.values);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.ArrayValueImpl
 * JD-Core Version:    0.6.0
 */