/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.reflect.spi.AnnotationInfo;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ArrayInfo;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.EnumInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.PrimitiveInfo;
/*     */ import org.jboss.reflect.spi.PrimitiveValue;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.reflect.spi.Value;
/*     */ 
/*     */ public class AnnotationValueFactory
/*     */ {
/*     */   public static Value createValue(AnnotationHelper annotationHelper, TypeInfo type, Object value)
/*     */   {
/*  49 */     Value rtnValue = null;
/*  50 */     if ((type instanceof ArrayInfo))
/*     */     {
/*  52 */       Object[] objects = getArray((ArrayInfo)type, value);
/*  53 */       Value[] values = new Value[objects.length];
/*  54 */       for (int i = 0; i < objects.length; i++)
/*     */       {
/*  56 */         values[i] = createValue(annotationHelper, ((ArrayInfo)type).getComponentType(), objects[i]);
/*     */       }
/*  58 */       rtnValue = new ArrayValueImpl(type, values);
/*     */     }
/*  60 */     else if ((type instanceof PrimitiveInfo))
/*     */     {
/*  62 */       rtnValue = new PrimitiveValue(value.toString(), (PrimitiveInfo)type);
/*     */     }
/*  64 */     else if (type.getName().equals("java.lang.String"))
/*     */     {
/*  66 */       rtnValue = new StringValueImpl((String)value, type);
/*     */     }
/*  68 */     else if ((type instanceof AnnotationInfo))
/*     */     {
/*  70 */       rtnValue = annotationHelper.createAnnotationValue((AnnotationInfo)type, value);
/*     */     }
/*  72 */     else if ((type instanceof EnumInfo))
/*     */     {
/*  74 */       rtnValue = new EnumValueImpl(type, value.toString());
/*     */     }
/*  76 */     else if ((type instanceof ClassInfo))
/*     */     {
/*  79 */       rtnValue = new ClassValueImpl(((Class)value).getName(), type);
/*     */     }
/*     */ 
/*  82 */     return rtnValue;
/*     */   }
/*     */ 
/*     */   public static AnnotationValue createAnnotationValue(TypeInfoFactory typeInfoFactory, AnnotationHelper annotationHelper, AnnotationInfo info, Object ann)
/*     */   {
/*  87 */     Annotation annotation = (Annotation)ann;
/*  88 */     Class clazz = annotation.annotationType();
/*  89 */     ClassInfo clazzInfo = (ClassInfo)typeInfoFactory.getTypeInfo(clazz);
/*     */ 
/*  91 */     HashMap attributes = new HashMap();
/*     */ 
/*  93 */     MethodInfo[] methods = clazzInfo.getDeclaredMethods();
/*  94 */     if (methods != null)
/*     */     {
/*  96 */       for (int j = 0; j < methods.length; j++)
/*     */       {
/*     */         try
/*     */         {
/* 100 */           Object val = methods[j].invoke(annotation, null);
/* 101 */           TypeInfo typeInfo = methods[j].getReturnType();
/* 102 */           Value value = createValue(annotationHelper, typeInfo, val);
/* 103 */           attributes.put(methods[j].getName(), value);
/*     */         }
/*     */         catch (Throwable e)
/*     */         {
/* 107 */           throw new RuntimeException("Error retrieving annotation attribute values", e);
/*     */         }
/*     */       }
/*     */     }
/* 111 */     return new AnnotationValueImpl(info, attributes, annotation);
/*     */   }
/*     */ 
/*     */   private static Object[] getArray(ArrayInfo arrayInfo, Object value)
/*     */   {
/* 117 */     TypeInfo componentType = arrayInfo.getComponentType();
/* 118 */     if (!(componentType instanceof PrimitiveInfo))
/*     */     {
/* 120 */       return (Object[])(Object[])value;
/*     */     }
/*     */ 
/* 124 */     Object[] ret = null;
/* 125 */     String typeName = componentType.getName();
/*     */ 
/* 127 */     if (typeName.equals("boolean"))
/*     */     {
/* 129 */       boolean[] input = (boolean[])(boolean[])value;
/* 130 */       ret = new Boolean[input.length];
/* 131 */       for (int i = 0; i < ret.length; i++)
/*     */       {
/* 133 */         ret[i] = new Boolean(input[i]);
/*     */       }
/*     */     }
/* 136 */     else if (typeName.equals("char"))
/*     */     {
/* 138 */       char[] input = (char[])(char[])value;
/* 139 */       ret = new Character[input.length];
/* 140 */       for (int i = 0; i < ret.length; i++)
/*     */       {
/* 142 */         ret[i] = new Character(input[i]);
/*     */       }
/*     */     }
/* 145 */     else if (typeName.equals("double"))
/*     */     {
/* 147 */       double[] input = (double[])(double[])value;
/* 148 */       ret = new Double[input.length];
/* 149 */       for (int i = 0; i < ret.length; i++)
/*     */       {
/* 151 */         ret[i] = new Double(input[i]);
/*     */       }
/*     */     }
/* 154 */     else if (typeName.equals("float"))
/*     */     {
/* 156 */       float[] input = (float[])(float[])value;
/* 157 */       ret = new Float[input.length];
/* 158 */       for (int i = 0; i < ret.length; i++)
/*     */       {
/* 160 */         ret[i] = new Float(input[i]);
/*     */       }
/*     */ 
/*     */     }
/* 164 */     else if (typeName.equals("int"))
/*     */     {
/* 166 */       int[] input = (int[])(int[])value;
/* 167 */       ret = new Integer[input.length];
/* 168 */       for (int i = 0; i < ret.length; i++)
/*     */       {
/* 170 */         ret[i] = new Integer(input[i]);
/*     */       }
/*     */ 
/*     */     }
/* 174 */     else if (typeName.equals("long"))
/*     */     {
/* 176 */       long[] input = (long[])(long[])value;
/* 177 */       ret = new Long[input.length];
/* 178 */       for (int i = 0; i < ret.length; i++)
/*     */       {
/* 180 */         ret[i] = new Long(input[i]);
/*     */       }
/*     */ 
/*     */     }
/* 184 */     else if (typeName.equals("short"))
/*     */     {
/* 186 */       short[] input = (short[])(short[])value;
/* 187 */       ret = new Short[input.length];
/* 188 */       for (int i = 0; i < ret.length; i++)
/*     */       {
/* 190 */         ret[i] = new Short(input[i]);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 195 */     if (ret == null)
/*     */     {
/* 197 */       throw new RuntimeException("Array component type " + componentType + " is not handled");
/*     */     }
/*     */ 
/* 200 */     return ret;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.AnnotationValueFactory
 * JD-Core Version:    0.6.0
 */