/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import org.jboss.reflect.spi.AnnotationAttribute;
/*     */ import org.jboss.reflect.spi.AnnotationInfo;
/*     */ 
/*     */ public class AnnotationInfoImpl extends InterfaceInfoImpl
/*     */   implements AnnotationInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3546645408219542832L;
/*     */   protected AnnotationAttribute[] attributes;
/*     */   protected HashMap<String, AnnotationAttribute> attributeMap;
/*     */ 
/*     */   public AnnotationInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AnnotationInfoImpl(String name, int modifiers)
/*     */   {
/*  61 */     super(name, modifiers);
/*     */   }
/*     */ 
/*     */   public void setAttributes(AnnotationAttributeImpl[] attributes)
/*     */   {
/*  71 */     this.attributes = attributes;
/*  72 */     if ((attributes != null) && (attributes.length > 0))
/*     */     {
/*  74 */       this.attributes = attributes;
/*  75 */       this.attributeMap = new HashMap();
/*  76 */       for (int i = 0; i < attributes.length; i++)
/*     */       {
/*  78 */         this.attributeMap.put(attributes[i].getName(), attributes[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  85 */     return this.name;
/*     */   }
/*     */ 
/*     */   public boolean isAnnotation()
/*     */   {
/*  90 */     return true;
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/*  95 */     return this.modifiers;
/*     */   }
/*     */ 
/*     */   public AnnotationAttribute[] getAttributes()
/*     */   {
/* 100 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   public AnnotationAttribute getAttribute(String name)
/*     */   {
/* 105 */     if (this.attributeMap == null)
/* 106 */       return null;
/* 107 */     return (AnnotationAttribute)this.attributeMap.get(name);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 112 */     if (this == o) return true;
/* 113 */     if (!(o instanceof AnnotationInfoImpl)) return false;
/*     */ 
/* 115 */     AnnotationInfoImpl annotationInfo = (AnnotationInfoImpl)o;
/*     */ 
/* 117 */     return this.name.equals(annotationInfo.name);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 124 */     return this.name.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.AnnotationInfoImpl
 * JD-Core Version:    0.6.0
 */