/*    */ package org.jboss.reflect.plugins;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import org.jboss.reflect.spi.AnnotationInfo;
/*    */ import org.jboss.reflect.spi.AnnotationValue;
/*    */ 
/*    */ public class AnnotationHolder extends AbstractAnnotatedInfo
/*    */ {
/*    */   private static final long serialVersionUID = 3546645408219542832L;
/*    */   protected AnnotationValue[] annotationsArray;
/*    */   protected HashMap<String, AnnotationValue> annotationMap;
/*    */ 
/*    */   public AnnotationHolder()
/*    */   {
/*    */   }
/*    */ 
/*    */   public AnnotationHolder(AnnotationValue[] annotations)
/*    */   {
/* 60 */     setupAnnotations(annotations);
/*    */   }
/*    */ 
/*    */   public AnnotationValue[] getAnnotations()
/*    */   {
/* 65 */     return this.annotationsArray;
/*    */   }
/*    */ 
/*    */   public AnnotationValue getAnnotation(String name)
/*    */   {
/* 70 */     if (this.annotationMap == null) return null;
/* 71 */     return (AnnotationValue)this.annotationMap.get(name);
/*    */   }
/*    */ 
/*    */   public boolean isAnnotationPresent(String name)
/*    */   {
/* 76 */     if (this.annotationMap == null) return false;
/* 77 */     return this.annotationMap.containsKey(name);
/*    */   }
/*    */ 
/*    */   protected void setupAnnotations(AnnotationValue[] annotations)
/*    */   {
/* 87 */     if ((annotations != null) && (annotations.length > 0))
/*    */     {
/* 89 */       this.annotationsArray = annotations;
/* 90 */       this.annotationMap = new HashMap();
/* 91 */       for (int i = 0; i < annotations.length; i++)
/*    */       {
/* 93 */         AnnotationInfo type = annotations[i].getAnnotationType();
/* 94 */         this.annotationMap.put(type.getName(), annotations[i]);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.AnnotationHolder
 * JD-Core Version:    0.6.0
 */