/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.reflect.spi.AnnotationAttribute;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.Value;
/*     */ import org.jboss.util.JBossObject;
/*     */ 
/*     */ public class AnnotationAttributeImpl extends JBossObject
/*     */   implements AnnotationAttribute, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 3546645408219542832L;
/*     */   protected String name;
/*     */   protected TypeInfo type;
/*     */   protected Value defaultValue;
/*  52 */   protected int hash = -1;
/*     */ 
/*     */   public AnnotationAttributeImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AnnotationAttributeImpl(String name, TypeInfo type, Value defaultValue)
/*     */   {
/*  70 */     this.name = name;
/*  71 */     this.type = type;
/*  72 */     this.defaultValue = defaultValue;
/*  73 */     calcHashCode();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  78 */     return this.name;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/*  83 */     return this.type;
/*     */   }
/*     */ 
/*     */   public Value getDefaultValue()
/*     */   {
/*  88 */     return this.defaultValue;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  93 */     if (this == obj)
/*  94 */       return true;
/*  95 */     if ((obj == null) || (!(obj instanceof AnnotationAttributeImpl))) {
/*  96 */       return false;
/*     */     }
/*  98 */     AnnotationAttributeImpl other = (AnnotationAttributeImpl)obj;
/*     */ 
/* 100 */     if (!this.name.equals(other.name)) {
/* 101 */       return false;
/*     */     }
/* 103 */     return this.type.equals(other.type);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 110 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calcHashCode()
/*     */   {
/* 119 */     int result = this.name.hashCode();
/* 120 */     result = 29 * result + this.type.hashCode();
/* 121 */     this.hash = result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.AnnotationAttributeImpl
 * JD-Core Version:    0.6.0
 */