/*    */ package org.jboss.reflect.plugins;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.lang.annotation.Annotation;
/*    */ import org.jboss.reflect.spi.AnnotatedInfo;
/*    */ import org.jboss.reflect.spi.AnnotationValue;
/*    */ import org.jboss.util.JBossObject;
/*    */ 
/*    */ public abstract class AbstractAnnotatedInfo extends JBossObject
/*    */   implements AnnotatedInfo, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 3546645408219542832L;
/* 42 */   private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
/*    */ 
/*    */   public <T extends Annotation> T getUnderlyingAnnotation(Class<T> annotationType)
/*    */   {
/* 53 */     if (annotationType == null)
/* 54 */       throw new IllegalArgumentException("Null annotationType");
/* 55 */     AnnotationValue value = getAnnotation(annotationType.getName());
/* 56 */     if (value == null)
/* 57 */       return null;
/* 58 */     return value.getUnderlyingAnnotation(annotationType);
/*    */   }
/*    */ 
/*    */   public Annotation[] getUnderlyingAnnotations()
/*    */   {
/* 63 */     AnnotationValue[] values = getAnnotations();
/* 64 */     if (values == null)
/* 65 */       return NO_ANNOTATIONS;
/* 66 */     Annotation[] result = new Annotation[values.length];
/* 67 */     for (int i = 0; i < values.length; i++)
/* 68 */       result[i] = values[i].getUnderlyingAnnotation();
/* 69 */     return result;
/*    */   }
/*    */ 
/*    */   public boolean isAnnotationPresent(Class<? extends Annotation> annotationType)
/*    */   {
/* 74 */     if (annotationType == null)
/* 75 */       throw new IllegalArgumentException("Null annotationType");
/* 76 */     return isAnnotationPresent(annotationType.getName());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.AbstractAnnotatedInfo
 * JD-Core Version:    0.6.0
 */