/*     */ package org.jboss.proxy.ejb.handle;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.ServerException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ 
/*     */ public class StatelessHandleImpl
/*     */   implements Handle
/*     */ {
/*     */   static final long serialVersionUID = 3811452873535097661L;
/*  51 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("jndiName", String.class), new ObjectStreamField("jndiEnv", Hashtable.class) };
/*     */   private String jndiName;
/*     */   private Hashtable jndiEnv;
/*     */ 
/*     */   public StatelessHandleImpl(String jndiName)
/*     */   {
/*  75 */     this.jndiName = jndiName;
/*  76 */     this.jndiEnv = ((Hashtable)NamingContextFactory.lastInitialContextEnv.get());
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject()
/*     */     throws ServerException
/*     */   {
/*     */     try
/*     */     {
/*  86 */       InitialContext ic = null;
/*  87 */       if (this.jndiEnv != null)
/*  88 */         ic = new InitialContext(this.jndiEnv);
/*     */       else
/*  90 */         ic = new InitialContext();
/*  91 */       EJBHome home = (EJBHome)ic.lookup(this.jndiName);
/*  92 */       Class type = home.getClass();
/*  93 */       Method method = type.getMethod("create", new Class[0]);
/*  94 */       return (EJBObject)method.invoke(home, new Object[0]);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  98 */     throw new ServerException("Could not get EJBObject", e);
/*     */   }
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/* 107 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 113 */     ObjectInputStream.GetField getField = ois.readFields();
/* 114 */     this.jndiName = ((String)getField.get("jndiName", null));
/* 115 */     this.jndiEnv = ((Hashtable)getField.get("jndiEnv", null));
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 121 */     ObjectOutputStream.PutField putField = oos.putFields();
/* 122 */     putField.put("jndiName", this.jndiName);
/* 123 */     putField.put("jndiEnv", this.jndiEnv);
/* 124 */     oos.writeFields();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.handle.StatelessHandleImpl
 * JD-Core Version:    0.6.0
 */