/*     */ package org.jboss.proxy.ejb.handle;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.ServerException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ 
/*     */ public class EntityHandleImpl
/*     */   implements Handle
/*     */ {
/*     */   static final long serialVersionUID = -132866169652666721L;
/*  55 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("id", Object.class), new ObjectStreamField("jndiName", String.class), new ObjectStreamField("jndiEnv", Hashtable.class) };
/*     */   private Object id;
/*     */   private String jndiName;
/*     */   private Hashtable jndiEnv;
/*     */ 
/*     */   public EntityHandleImpl(String jndiName, Object id)
/*     */   {
/*  83 */     this.jndiName = jndiName;
/*  84 */     this.id = id;
/*  85 */     this.jndiEnv = ((Hashtable)NamingContextFactory.lastInitialContextEnv.get());
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject()
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 103 */       InitialContext ic = null;
/* 104 */       if (this.jndiEnv != null)
/* 105 */         ic = new InitialContext(this.jndiEnv);
/*     */       else
/* 107 */         ic = new InitialContext();
/* 108 */       EJBHome home = (EJBHome)ic.lookup(this.jndiName);
/* 109 */       Class type = home.getClass();
/* 110 */       Method method = type.getMethod("findByPrimaryKey", new Class[] { home.getEJBMetaData().getPrimaryKeyClass() });
/*     */ 
/* 113 */       return (EJBObject)method.invoke(home, new Object[] { this.id });
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 117 */     throw new ServerException("Could not get EJBObject", e);
/*     */   }
/*     */ 
/*     */   public Object getID()
/*     */   {
/* 126 */     return this.id;
/*     */   }
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/* 134 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 140 */     ObjectInputStream.GetField getField = ois.readFields();
/* 141 */     this.id = getField.get("id", null);
/* 142 */     this.jndiName = ((String)getField.get("jndiName", null));
/* 143 */     this.jndiEnv = ((Hashtable)getField.get("jndiEnv", null));
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 149 */     ObjectOutputStream.PutField putField = oos.putFields();
/* 150 */     putField.put("id", this.id);
/* 151 */     putField.put("jndiName", this.jndiName);
/* 152 */     putField.put("jndiEnv", this.jndiEnv);
/* 153 */     oos.writeFields();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.handle.EntityHandleImpl
 * JD-Core Version:    0.6.0
 */